# 媚薬スライム用 必要画像リスト

## プロジェクト情報
- モンスター名: 媚薬スライム (aphrodisiacSlime)
- ベース: 通常スライム (slime)
- 特徴: 媚薬効果、ピンク色または紫色系の色調

---

## A. バスト画像フォルダ (Bust Images)

媚薬スライムには以下の2つのフォルダが必要です：

### 必要なフォルダ
1. **`img/pictures/busts/aphrodisiacSlime_restrained/`** - 非挿入時
2. **`img/pictures/busts/aphrodisiacSlime_restrained_insert/`** - 挿入時

---

## B. 制服画像 (Uniform) - 各フォルダに必須

### 必須ファイル（両フォルダに必要）
1. **`uniform_intact_base.png`** - 制服（無傷）
2. **`uniform_damaged_base.png`** - 制服（破損）
3. **`uniform_destroyed_base.png`** - 制服（破壊）

- 用途: キャラクターの制服状態を表示
- 説明: ダメージに応じて切り替わる
- 参考: 既存のスライムフォルダから流用可能

---

## C. 表情画像 (Expression) - 各フォルダに必須

### 必須ファイル（両フォルダに必要）
- **`default_pose_face_normal.png`** - 通常表情
- **`default_pose_face_embarrassed.png`** - 恥ずかしい表情
- **`default_pose_face_endure.png`** - 耐える表情
- **`default_pose_face_ahe.png`** - アヘ顔
- **`default_pose_face_crying.png`** - 泣き顔
- **`default_pose_face_angry.png`** - 怒り顔
- **`default_pose_face_surprised.png`** - 驚き顔
- **`default_pose_face_confused.png`** - 困惑顔

- 用途: イベントに応じた表情変化
- 参考: 既存のスライムフォルダから流用可能

---

## D. 頬染め画像 (Blush) - 各フォルダに必須

### 必須ファイル（両フォルダに必要）
- **`default_pose_overlay_blush_low.png`** - 頬染め（弱）
- **`default_pose_overlay_blush_mid.png`** - 頬染め（中）
- **`default_pose_overlay_blush_high.png`** - 頬染め（強）

- 用途: 絶頂回数に応じた頬の赤み
- 参考: 既存のスライムフォルダから流用可能

---

## E. オーバーレイ画像 (Overlay Effects)

### 1. 基本拘束画像 (Base Restraint)

### 必須ファイル（両フォルダに必要）
- **`default_pose_overlay_restrain.png`**
  - 用途: 媚薬スライムの基本拘束状態
  - 説明: 主人公を拘束しているスライムの外観
  - 参考: 通常スライムの色違い/エフェクト違い
  - 推奨色: ピンク/紫系、媚薬を示す煙やキラキラエフェクト

---

### 2. 攻撃エフェクト画像 (Attack Effects)

#### 非挿入フォルダ用
- **`default_pose_overlay_attack_pussy_soft.png`** - 陰部攻撃（弱）
- **`default_pose_overlay_attack_pussy_hard.png`** - 陰部攻撃（強）
- **`default_pose_overlay_slime_breast.png`** - 胸部攻撃
- **`default_pose_overlay_slime_pussy.png`** - 陰部スライム

#### 挿入フォルダ用
- **`default_pose_overlay_insert_pussy_soft.png`** - 挿入（弱）
- **`default_pose_overlay_insert_pussy_hard.png`** - 挿入（強）
- **`default_pose_overlay_insert_mouth_soft.png`** - 口挿入（弱）★媚薬スライム専用
- **`default_pose_overlay_insert_mouth_hard.png`** - 口挿入（強）★媚薬スライム専用

---

## F. SFX画像 (擬音エフェクト)

### 1. 非挿入用SFX（`aphrodisiacSlime_restrained/`）

#### 必須ファイル
- **`default_pose_overlay_ぬちょっ1-6_left.png`**
- **`default_pose_overlay_ぬちょっ1-6_right.png`**
- **`default_pose_overlay_ぐちゅっ1-6_left.png`**
- **`default_pose_overlay_ぐちゅっ1-6_right.png`**
- **`default_pose_overlay_ぐちゃ1-6_left.png`**
- **`default_pose_overlay_ぐちゃ1-6_right.png`**
- **`default_pose_overlay_ぬちゃっ1-6_left.png`**
- **`default_pose_overlay_ぬちゃっ1-6_right.png`**
- **`default_pose_overlay_ヌポッ1-6_left.png`**
- **`default_pose_overlay_ヌポッ1-6_right.png`**
- **`default_pose_overlay_ずぶ3-6_left.png`**
- **`default_pose_overlay_ずぶ3-6_right.png`**

### 2. 挿入用SFX（`aphrodisiacSlime_restrained_insert/`）

#### 必須ファイル（上記の非挿入用に加えて）
- **`default_pose_overlay_ズプッ1-6_left.png`**
- **`default_pose_overlay_ズプッ1-6_right.png`**
- **`default_pose_overlay_ズポ1-6_left.png`**
- **`default_pose_overlay_ズポ1-6_right.png`**
- **`default_pose_overlay_ヌプッ1-6_left.png`**
- **`default_pose_overlay_ヌプッ1-6_right.png`**
- **`default_pose_overlay_ズン1-6_left.png`**
- **`default_pose_overlay_ズン1-6_right.png`**

**注**: 各SFXは`1-6`の6段階のバリエーション（絶頂回数に応じて変化）

---

## G. ポーズ画像（オプション）

### オプショナルファイル
- **`restrained_pose1_base.png`**
- **`restrained_pose2_base.png`**
- **`restrained_pose6_base.png`**

- 用途: 拘束時の特別なポーズ
- 参考: 既存のスライムフォルダから流用可能
- 優先度: 低（autoで代用可能）

---

## 画像仕様

### 共通仕様
- **ファイル形式**: PNG（透過あり）
- **解像度**: 既存のスライム画像と同じサイズ
- **レイヤー**: `underOverlay`（攻撃エフェクトは背面レイヤー）
- **色調**: ピンク系/紫系（媚薬を連想させる色）

### 媚薬スライム特有の表現
1. **色**: 通常スライム（青緑系）→ 媚薬スライム（ピンク/紫系）
2. **エフェクト**: 
   - キラキラ光るパーティクル
   - ハートマーク
   - ピンク色の霧/煙
   - 体液の色が異なる
3. **透明度**: やや透明感を持たせ、媚薬が浸透する様子を表現

---

## 画像ファイルの配置場所

### 非挿入フォルダ: `img/pictures/busts/aphrodisiacSlime_restrained/`
```
aphrodisiacSlime_restrained/
├── uniform_intact_base.png                      (制服・無傷)
├── uniform_damaged_base.png                     (制服・破損)
├── uniform_destroyed_base.png                   (制服・破壊)
├── default_pose_face_normal.png                 (表情・通常)
├── default_pose_face_embarrassed.png            (表情・恥ずかし)
├── default_pose_face_endure.png                 (表情・耐える)
├── default_pose_face_ahe.png                    (表情・アヘ顔)
├── default_pose_face_crying.png                 (表情・泣き顔)
├── default_pose_face_angry.png                  (表情・怒り)
├── default_pose_face_surprised.png              (表情・驚き)
├── default_pose_face_confused.png               (表情・困惑)
├── default_pose_overlay_blush_low.png           (頬染め・弱)
├── default_pose_overlay_blush_mid.png           (頬染め・中)
├── default_pose_overlay_blush_high.png          (頬染め・強)
├── default_pose_overlay_restrain.png            (拘束エフェクト)
├── default_pose_overlay_attack_pussy_soft.png   (陰部攻撃・弱)
├── default_pose_overlay_attack_pussy_hard.png   (陰部攻撃・強)
├── default_pose_overlay_slime_breast.png        (胸スライム)
├── default_pose_overlay_slime_pussy.png         (陰部スライム)
├── default_pose_overlay_ぬちょっ1-6_left.png    (擬音)
├── default_pose_overlay_ぬちょっ1-6_right.png   (擬音)
├── default_pose_overlay_ぐちゅっ1-6_left.png    (擬音)
├── default_pose_overlay_ぐちゅっ1-6_right.png   (擬音)
├── default_pose_overlay_ぐちゃ1-6_left.png      (擬音)
├── default_pose_overlay_ぐちゃ1-6_right.png     (擬音)
├── default_pose_overlay_ぬちゃっ1-6_left.png    (擬音)
├── default_pose_overlay_ぬちゃっ1-6_right.png   (擬音)
├── default_pose_overlay_ヌポッ1-6_left.png      (擬音)
├── default_pose_overlay_ヌポッ1-6_right.png     (擬音)
├── default_pose_overlay_ずぶ3-6_left.png        (擬音)
└── default_pose_overlay_ずぶ3-6_right.png       (擬音)
```

### 挿入フォルダ: `img/pictures/busts/aphrodisiacSlime_restrained_insert/`
```
aphrodisiacSlime_restrained_insert/
├── uniform_intact_base.png                      (制服・無傷)
├── uniform_damaged_base.png                     (制服・破損)
├── uniform_destroyed_base.png                   (制服・破壊)
├── default_pose_face_normal.png                 (表情・通常)
├── default_pose_face_embarrassed.png            (表情・恥ずかし)
├── default_pose_face_endure.png                 (表情・耐える)
├── default_pose_face_ahe.png                    (表情・アヘ顔)
├── default_pose_face_crying.png                 (表情・泣き顔)
├── default_pose_face_angry.png                  (表情・怒り)
├── default_pose_face_surprised.png              (表情・驚き)
├── default_pose_face_confused.png               (表情・困惑)
├── default_pose_overlay_blush_low.png           (頬染め・弱)
├── default_pose_overlay_blush_mid.png           (頬染め・中)
├── default_pose_overlay_blush_high.png          (頬染め・強)
├── default_pose_overlay_restrain.png            (拘束エフェクト)
├── default_pose_overlay_insert_pussy_soft.png   (陰部挿入・弱)
├── default_pose_overlay_insert_pussy_hard.png   (陰部挿入・強)
├── default_pose_overlay_insert_mouth_soft.png   (口挿入・弱) ★新規
├── default_pose_overlay_insert_mouth_hard.png   (口挿入・強) ★新規
├── default_pose_overlay_slime_breast.png        (胸スライム)
├── default_pose_overlay_slime_pussy.png         (陰部スライム)
├── default_pose_overlay_ぬちょっ1-6_left.png    (擬音)
├── default_pose_overlay_ぬちょっ1-6_right.png   (擬音)
├── default_pose_overlay_ズプッ1-6_left.png      (擬音・挿入)
├── default_pose_overlay_ズプッ1-6_right.png     (擬音・挿入)
├── default_pose_overlay_ズポ1-6_left.png        (擬音・挿入)
├── default_pose_overlay_ズポ1-6_right.png       (擬音・挿入)
├── default_pose_overlay_ぐちゅっ1-6_left.png    (擬音)
├── default_pose_overlay_ぐちゅっ1-6_right.png   (擬音)
├── default_pose_overlay_ぐちゃ1-6_left.png      (擬音)
├── default_pose_overlay_ぐちゃ1-6_right.png     (擬音)
├── default_pose_overlay_ぬちゃっ1-6_left.png    (擬音)
├── default_pose_overlay_ぬちゃっ1-6_right.png   (擬音)
├── default_pose_overlay_ヌプッ1-6_left.png      (擬音・挿入)
├── default_pose_overlay_ヌプッ1-6_right.png     (擬音・挿入)
├── default_pose_overlay_ズン1-6_left.png        (擬音・挿入)
├── default_pose_overlay_ズン1-6_right.png       (擬音・挿入)
├── default_pose_overlay_ヌポッ1-6_left.png      (擬音)
├── default_pose_overlay_ヌポッ1-6_right.png     (擬音)
├── default_pose_overlay_ずぶ3-6_left.png        (擬音)
└── default_pose_overlay_ずぶ3-6_right.png       (擬音)
```

---

## 必要画像の総数

### カテゴリ別集計

#### 各フォルダ共通（両方に必要）
1. 制服画像: **3枚** × 2フォルダ = 6枚
2. 表情画像: **8枚** × 2フォルダ = 16枚
3. 頬染め画像: **3枚** × 2フォルダ = 6枚

#### 非挿入フォルダ専用
4. オーバーレイ: **5枚**（restrain, attack_pussy×2, slime×2）
5. SFX擬音: **12枚**（6種類 × left/right）

#### 挿入フォルダ専用
6. オーバーレイ: **7枚**（restrain, insert×4, slime×2）
7. SFX擬音: **20枚**（10種類 × left/right）

### **総計: 約75枚**

ただし、多くは既存のスライムフォルダから**コピー可能**です！

---

## 制作優先度

### 🔴 優先度: 最高（新規制作が必須）

媚薬スライム専用で、既存から流用できない画像：

1. **`default_pose_overlay_insert_mouth_soft.png`** - 口挿入（弱）
2. **`default_pose_overlay_insert_mouth_hard.png`** - 口挿入（強）

これら2枚は**必ず新規作成が必要**です。

---

### 🟡 優先度: 高（色違い版の作成）

通常スライムから色変更して作成：

#### オーバーレイエフェクト（8枚）
3. `default_pose_overlay_restrain.png` - 拘束エフェクト（ピンク/紫化）
4. `default_pose_overlay_attack_pussy_soft.png` - 陰部攻撃・弱（色変更）
5. `default_pose_overlay_attack_pussy_hard.png` - 陰部攻撃・強（色変更）
6. `default_pose_overlay_insert_pussy_soft.png` - 陰部挿入・弱（色変更）
7. `default_pose_overlay_insert_pussy_hard.png` - 陰部挿入・強（色変更）
8. `default_pose_overlay_slime_breast.png` - 胸スライム（色変更）
9. `default_pose_overlay_slime_pussy.png` - 陰部スライム（色変更）

---

### 🟢 優先度: 中（既存からコピー可能）

通常スライムフォルダから**そのままコピー**できる画像：

#### 制服・表情・頬染め（28枚）
- 制服 × 3
- 表情 × 8
- 頬染め × 3
- これらを非挿入/挿入の両フォルダにコピー

#### SFX擬音（32枚）
- 非挿入用: 12枚（6種類 × left/right）
- 挿入用: 20枚（10種類 × left/right）

**コピー元**: `img/pictures/busts/slime_restrained/` および `slime_restrained_insert/`

---

### ⚪ 優先度: 低（オプション）

必須ではないが、あると良い画像：

- `restrained_pose1_base.png`
- `restrained_pose2_base.png`
- `restrained_pose6_base.png`

---

## overlayファイルの設定

### 必要な設定ファイル
- `dataEx/overlays/overlaySets_aphrodisiacSlime.json` ✅ (作成済み)

---

## 参考: 通常スライムとの差異

### 視覚的な違い
| 項目 | 通常スライム | 媚薬スライム |
|------|--------------|--------------|
| 基本色 | 青緑系 | ピンク/紫系 |
| エフェクト | 水滴、ぬめり | ハート、煙、キラキラ |
| 透明度 | やや不透明 | やや透明（媚薬が染み込む） |
| 特殊効果 | なし | 媚薬の霧/パーティクル |

---

## 注意事項

### 画像制作時の注意
1. **既存スライム画像を参考にする**: サイズ、配置、レイヤー構造を統一
2. **色の統一**: 媚薬スライム全体で色調を統一（ピンク/紫系）
3. **透過処理**: PNG形式で適切に透過処理を行う
4. **エフェクトの追加**: 媚薬効果を視覚的に表現するエフェクトを追加

### テスト方法
1. 画像を `img/pictures/` に配置
2. `overlaySets_aphrodisiacSlime.json` に画像名を登録
3. ゲーム内で媚薬スライムとの戦闘をテスト
4. 各Stage、各eventTypeで適切に表示されるか確認

---

## ステータス

### データ実装
- **JSONデータ**: ✅ 完成
  - poseProfiles (low/high, 非挿入/挿入) ✅
  - orgasmDetailProfiles (low/high, 非挿入/挿入) ✅
  - introProfiles (low/high) ✅
  - restraintProfiles (low/high) ✅
  - overlaySets ✅

- **システム連携**: ✅ 完了
  - monsterTraits.json への登録 ✅
  - overlaySets_aphrodisiacSlime.json の作成 ✅
  - PleasurePoseController.js のfallbackMap ✅

### 画像実装
- **画像データ**: ⚠️ 未作成
  - 必要枚数: 約75枚
  - **新規作成**: 0/2枚（口挿入画像）
  - **色変更**: 0/8枚（スライムエフェクト）
  - **コピー**: 0/65枚（制服・表情・SFX等）

---

## 画像作成の手順

### Step 1: フォルダ作成
```
img/pictures/busts/aphrodisiacSlime_restrained/
img/pictures/busts/aphrodisiacSlime_restrained_insert/
```

### Step 2: 新規作成（2枚のみ）
口挿入用の画像を作成：
- `default_pose_overlay_insert_mouth_soft.png`
- `default_pose_overlay_insert_mouth_hard.png`

### Step 3: 色変更（8枚）
通常スライムの画像を開いて、色相を変更（青緑→ピンク/紫）：
- 拘束・攻撃・挿入系のオーバーレイ画像

### Step 4: 一括コピー（65枚）
以下のコマンドで既存画像をコピー：

#### PowerShellスクリプト
```powershell
# 非挿入フォルダへコピー
$source = "img\pictures\busts\slime_restrained\"
$target = "img\pictures\busts\aphrodisiacSlime_restrained\"

# 制服
Copy-Item "${source}uniform_*.png" $target

# 表情
Copy-Item "${source}default_pose_face_*.png" $target

# 頬染め
Copy-Item "${source}default_pose_overlay_blush_*.png" $target

# SFX擬音（非挿入用）
Copy-Item "${source}default_pose_overlay_ぬちょっ*.png" $target
Copy-Item "${source}default_pose_overlay_ぐちゅっ*.png" $target
Copy-Item "${source}default_pose_overlay_ぐちゃ*.png" $target
Copy-Item "${source}default_pose_overlay_ぬちゃっ*.png" $target
Copy-Item "${source}default_pose_overlay_ヌポッ*.png" $target
Copy-Item "${source}default_pose_overlay_ずぶ*.png" $target

# 挿入フォルダへも同様にコピー
$source = "img\pictures\busts\slime_restrained_insert\"
$target = "img\pictures\busts\aphrodisiacSlime_restrained_insert\"

# （上記と同じ＋挿入用SFXを追加）
Copy-Item "${source}default_pose_overlay_ズプッ*.png" $target
Copy-Item "${source}default_pose_overlay_ズポ*.png" $target
Copy-Item "${source}default_pose_overlay_ヌプッ*.png" $target
Copy-Item "${source}default_pose_overlay_ズン*.png" $target
```

---

## 作成日
2025-12-08

## 要約

**媚薬スライムの実装に必要な画像は全部で約75枚です。**

ただし、そのうち**約60枚は既存のスライムフォルダからコピー可能**です！

画像さえ作成すれば、すぐにゲーム内で動作します：
1. JSONデータ（セリフ・イベント）→ ✅ 完成
2. システム連携（プログラム設定）→ ✅ 完成
3. 画像データ → ⚠️ **これから作成・コピーが必要**

---

### 🔴 新規作成が必須（2枚のみ！）
1. `default_pose_overlay_insert_mouth_soft.png` - 口挿入（弱）
2. `default_pose_overlay_insert_mouth_hard.png` - 口挿入（強）

**この2枚だけは完全に新規作成が必要です。**

---

### 🟡 色変更が必要（8枚）
通常スライム（青緑）→ 媚薬スライム（ピンク/紫）に色変更：

3. `default_pose_overlay_restrain.png` - 拘束
4. `default_pose_overlay_attack_pussy_soft.png` - 陰部攻撃・弱
5. `default_pose_overlay_attack_pussy_hard.png` - 陰部攻撃・強
6. `default_pose_overlay_insert_pussy_soft.png` - 陰部挿入・弱
7. `default_pose_overlay_insert_pussy_hard.png` - 陰部挿入・強
8. `default_pose_overlay_slime_breast.png` - 胸スライム
9. `default_pose_overlay_slime_pussy.png` - 陰部スライム

---

### 🟢 コピーのみでOK（約65枚）
既存のスライムフォルダから**そのままコピー**するだけ：

- 制服画像 × 6枚（3種類 × 2フォルダ）
- 表情画像 × 16枚（8種類 × 2フォルダ）
- 頬染め画像 × 6枚（3種類 × 2フォルダ）
- SFX擬音画像 × 32枚（16種類 × 2フォルダ）

**実質的な作業量: 新規2枚 + 色変更8枚 = 10枚の画像編集のみ！**

---

## 🎯 クイックスタートガイド

### 最短手順（10枚の画像編集のみ）

#### Step 1: フォルダ作成
```
mkdir img\pictures\busts\aphrodisiacSlime_restrained
mkdir img\pictures\busts\aphrodisiacSlime_restrained_insert
```

#### Step 2: 新規作成（2枚）★ 最優先
口挿入用の画像を作成：
- `default_pose_overlay_insert_mouth_soft.png` - 口から媚薬スライムが流れ込む様子（弱）
- `default_pose_overlay_insert_mouth_hard.png` - 口から媚薬スライムが流れ込む様子（強）

**配置先**: `aphrodisiacSlime_restrained_insert/`

#### Step 3: 色変更（8枚）
通常スライムの画像を開いて、色相を変更（青緑→ピンク/紫）：
1. `default_pose_overlay_restrain.png`
2. `default_pose_overlay_attack_pussy_soft.png`
3. `default_pose_overlay_attack_pussy_hard.png`
4. `default_pose_overlay_insert_pussy_soft.png`
5. `default_pose_overlay_insert_pussy_hard.png`
6. `default_pose_overlay_slime_breast.png`
7. `default_pose_overlay_slime_pussy.png`

**配置先**: 両フォルダに配置

#### Step 4: 一括コピー（約65枚）
PowerShellで一括コピー：

```powershell
# 非挿入フォルダへコピー
$src = "img\pictures\busts\slime_restrained\"
$dst = "img\pictures\busts\aphrodisiacSlime_restrained\"

# 基本画像
Copy-Item "${src}uniform_*.png" $dst
Copy-Item "${src}default_pose_face_*.png" $dst
Copy-Item "${src}default_pose_overlay_blush_*.png" $dst

# SFX擬音
Copy-Item "${src}default_pose_overlay_ぬちょっ*.png" $dst
Copy-Item "${src}default_pose_overlay_ぐちゅっ*.png" $dst
Copy-Item "${src}default_pose_overlay_ぐちゃ*.png" $dst
Copy-Item "${src}default_pose_overlay_ぬちゃっ*.png" $dst
Copy-Item "${src}default_pose_overlay_ヌポッ*.png" $dst
Copy-Item "${src}default_pose_overlay_ずぶ*.png" $dst

# 挿入フォルダへコピー
$src = "img\pictures\busts\slime_restrained_insert\"
$dst = "img\pictures\busts\aphrodisiacSlime_restrained_insert\"

# 基本画像（同上）
Copy-Item "${src}uniform_*.png" $dst
Copy-Item "${src}default_pose_face_*.png" $dst
Copy-Item "${src}default_pose_overlay_blush_*.png" $dst

# SFX擬音（挿入用を追加）
Copy-Item "${src}default_pose_overlay_ぬちょっ*.png" $dst
Copy-Item "${src}default_pose_overlay_ズプッ*.png" $dst
Copy-Item "${src}default_pose_overlay_ズポ*.png" $dst
Copy-Item "${src}default_pose_overlay_ぐちゅっ*.png" $dst
Copy-Item "${src}default_pose_overlay_ぐちゃ*.png" $dst
Copy-Item "${src}default_pose_overlay_ぬちゃっ*.png" $dst
Copy-Item "${src}default_pose_overlay_ヌプッ*.png" $dst
Copy-Item "${src}default_pose_overlay_ズン*.png" $dst
Copy-Item "${src}default_pose_overlay_ヌポッ*.png" $dst
Copy-Item "${src}default_pose_overlay_ずぶ*.png" $dst
```

**完了！ゲーム内で媚薬スライムが動作します。**

---

## 更新履歴
- 2025-12-08: 初版作成
- 2025-12-08: システム連携ステータス更新、要約追加
- 2025-12-08: uniform系・SFX系を追加、クイックスタートガイド追加

