# HardOnlyパターン実装ドキュメント

**作成日**: 2025-12-09  
**目的**: 差分が少ないモンスター向けに、画像枚数を削減するための汎用パターンを提供

---

## 📋 概要

エロゲーム制作において、モンスターごとに大量の画像差分（soft/hard）を用意するのはコストがかかります。  
特に**予算や時間が限られている場合**、または**ビジュアル的に差分が不要なモンスター**のために、`hardonly`パターンを実装しました。

---

## 🎯 実装内容

### 1. 新しいシーケンスパターン（`VisualOverlayData.js`）

#### A. 通常攻撃用パターン

```javascript
// 短い演出用（1-3行）: react等
hardonlyShort: [
  { frame: 0, intensity: "hard" },
  { frame: 1, intensity: "hard" },
  { frame: 2, intensity: "hard" }
],

// 中程度演出用（3-5行）: danger, climax, down_attack等
hardonlyMedium: [
  { frame: 0, intensity: "hard" },
  { frame: 1, intensity: "hard" },
  { frame: 2, intensity: "hard" },
  { frame: 3, intensity: "hard" },
  { frame: 4, intensity: "hard" }
],

// 長い演出用（5行以上）: orgasm等
hardonlyLong: [
  { frame: 0, intensity: "hard" },
  { frame: 1, intensity: "hard" },
  { frame: 2, intensity: "hard" },
  { frame: 3, intensity: "hard" },
  { frame: 4, intensity: "hard" },
  { frame: 5, intensity: "hard" },
  { frame: 6, intensity: "hard" }
]
```

#### B. 挿入イベント用パターン

```javascript
insertionHardOnly: {
  "insert:pre": [
    { frame: 0, intensity: "hard" },  // pre段階もhardで表現
    { frame: 1, intensity: "hard" }
  ],
  "insert:main": [
    { frame: 0, intensity: "hard" },
    { frame: 1, intensity: "hard" },
    { frame: 2, intensity: "hard" },
    { frame: 3, intensity: "hard" },
    { frame: 4, intensity: "hard" },
    { frame: 5, intensity: "hard" }
  ]
}
```

---

## 💡 使用方法

### 基本的な使い方

```javascript
window.OverlaySets = {
  yourMonster: {
    mapping: {
      restrain: "restrain",
      
      attack: {
        breast: {
          soft: "attack_image",  // softもhardも同じ画像を指定
          hard: "attack_image",  // 同じ画像（またはどちらか片方のみ用意）
          layer: "overlay",
          sequences: {
            react: SEQUENCE_PATTERNS.hardonlyShort,    // ★常にhard
            danger: SEQUENCE_PATTERNS.hardonlyMedium,  // ★常にhard
            climax: SEQUENCE_PATTERNS.hardonlyMedium,
            down_attack: SEQUENCE_PATTERNS.hardonlyMedium,
            orgasm: SEQUENCE_PATTERNS.hardonlyLong
          }
        }
      },
      
      insert: {
        pussy: {
          soft: "insert_image",  // 同じ画像
          hard: "insert_image",  // 同じ画像
          layer: "underOverlay",
          sequences: {
            ...SEQUENCE_PATTERNS.insertionHardOnly,  // ★pre/mainともにhard
            danger: SEQUENCE_PATTERNS.hardonlyMedium,
            climax: SEQUENCE_PATTERNS.hardonlyLong,
            down_attack: SEQUENCE_PATTERNS.hardonlyLong,
            orgasm: SEQUENCE_PATTERNS.hardonlyLong
          }
        }
      }
    }
  }
};
```

---

## 📊 比較: 通常版 vs hardonly版

### 画像枚数

| 項目 | 通常版 | hardonly版 | 削減数 |
|------|--------|------------|--------|
| 非挿入攻撃 | soft + hard (2枚) | hard のみ (1枚) | -1枚 |
| 挿入攻撃 | soft + hard (2枚) | hard のみ (1枚) | -1枚 |
| **合計（2フォルダ）** | **8枚** | **4枚** | **-4枚** |

### 演出の違い

#### 通常版（insertionCommon）
```
insert:pre → soft, soft（優しい表現）
insert:main → hard, hard, hard, hard, hard, hard（激しい表現）
```
- 緩急がある
- 挿入前の受け入れ段階を優しく表現
- 挿入後は激しく表現

#### hardonly版（insertionHardOnly）
```
insert:pre → hard, hard（激しい表現）
insert:main → hard, hard, hard, hard, hard, hard（激しい表現）
```
- 全て激しい
- 挿入前も激しく表現
- 常に1種類の画像のみ使用

---

## 🎨 媚薬スライムでの使用例

`VisualOverlayData.js`に実装済み：

```javascript
aphrodisiacSlime: {
  mapping: {
    attack: {
      breast: {
        soft: "slime_fullbody_soft",
        hard: "slime_fullbody_hard",
        sequences: {
          react: SEQUENCE_PATTERNS.hardonlyShort,    // ★使用例
          danger: SEQUENCE_PATTERNS.hardonlyMedium,
          climax: SEQUENCE_PATTERNS.hardonlyMedium,
          down_attack: SEQUENCE_PATTERNS.hardonlyMedium,
          orgasm: SEQUENCE_PATTERNS.hardonlyLong
        }
      }
    },
    
    insert: {
      mouth: {
        soft: "insert_mouth_pre",
        hard: "insert_mouth_main",
        sequences: {
          ...SEQUENCE_PATTERNS.insertionHardOnly,  // ★使用例
          danger: SEQUENCE_PATTERNS.hardonlyMedium,
          climax: SEQUENCE_PATTERNS.hardonlyLong,
          down_attack: SEQUENCE_PATTERNS.hardonlyLong,
          orgasm: SEQUENCE_PATTERNS.hardonlyLong
        }
      }
    }
  }
}
```

---

## ✅ メリット

1. **画像枚数削減**: soft/hard差分が不要になり、最大50%削減
2. **制作コスト削減**: 差分作業が不要
3. **メモリ節約**: ロードする画像が減る
4. **ファイルサイズ削減**: ゲーム全体のサイズが小さくなる
5. **開発速度向上**: 画像作成・管理の手間が減る

---

## ⚠️ デメリット

1. **演出の緩急が減る**: 常に激しい表現のみになる
2. **ビジュアルバリエーション減少**: 見た目の変化が少なくなる
3. **没入感の低下**: 段階的な表現ができない

---

## 🎯 推奨使用ケース

### ✅ hardonlyパターンが適している場合

- 予算・時間が限られているプロジェクト
- ビジュアル的に差分を作りにくいモンスター
- 常に激しい表現が適しているモンスター（例: 媚薬系）
- テスト実装・プロトタイプ段階
- マイナーなモンスター（登場頻度が低い）

### ❌ hardonlyパターンが不適切な場合

- メインモンスター（登場頻度が高い）
- 緩急のある演出が重要なモンスター
- 高品質・高予算プロジェクト
- ビジュアルバリエーションが重要なゲーム

---

## 📝 実装ファイル

### 変更されたファイル

1. **`js/plugins/VisualOverlayData.js`**
   - `SEQUENCE_PATTERNS.hardonlyShort/Medium/Long` 追加
   - `SEQUENCE_PATTERNS.insertionHardOnly` 追加
   - 媚薬スライムの設定に使用例を追加

2. **`docs/aphrodisiacSlime_images_MINIMUM.md`**
   - コスト削減オプションセクション追加
   - 画像枚数削減の説明追加
   - 実装方法の説明追加

3. **`docs/hardonly_pattern_implementation.md`** (このファイル)
   - 実装内容の詳細ドキュメント

---

## 🔄 今後の展開

### 将来的な改善案

1. **自動判定システム**: 台詞の長さに応じて自動的に適切なパターンを選択
2. **混合パターン**: 特定のイベントのみhardonlyを使用
3. **カスタムパターンジェネレーター**: フレーム数を指定して自動生成
4. **画像不足時の自動フォールバック**: soft画像がない場合、自動的にhardを使用

---

## 📚 参考情報

### 関連システム

- `OverlayBuilder.js`: オーバーレイとSFXの生成を担当
- `VisualAutoFill.js`: 表情・オーバーレイ・SFXの自動補完
- `PleasurePoseController.js`: 台詞とビジュアルの統合管理

### 関連ドキュメント

- `docs/aphrodisiacSlime_images_MINIMUM.md`: 媚薬スライムの画像リスト
- `docs/aphrodisiacSlime_implementation_summary.md`: 媚薬スライムの実装概要

---

## 🎉 まとめ

`hardonly`パターンにより、差分が少ないモンスターの実装が容易になりました。  
制作コストとビジュアル品質のバランスを考慮して、適切に使い分けてください。

**推奨**: まずは通常版で実装し、コスト面で問題があれば`hardonly`に切り替える方式

