# 部位感度/開発度 影響範囲マップ

このドキュメントは、リポジトリ全体から「部位感度/開発度」に関連する識別子を検索し、定義元/読み出し/書き込みに分類したものです。

## 優先スキャン対象ファイル

- `EroStatus.*` (Core, Store, Adapter, Selectors, Controller, Events, UI)
- `Pleasure*` (PleasureActorStatus, PleasurePoseController, PleasureAttackManager, PleasureDataManager, PleasureTriggerManager, PleasureEventManager, PleasureStateManager, PleasureDisplayManager, PleasureIntroManager, PleasureSystem, PleasureFlashFX)
- `InsertEventHandler`
- `RestraintEventHandler`
- `OrgasmEventHandler`
- `PleasurePoseController`

---

## 定義元（Definition）

### PleasureActorStatus.js

#### プロパティ定義
- **`_developPussy`** (行8)
  ```javascript
  if (this._developPussy == null) this._developPussy = 0;
  ```
- **`_developBreasts`** (行9)
  ```javascript
  if (this._developBreasts == null) this._developBreasts = 0;
  ```
- **`_developAss`** (行10)
  ```javascript
  if (this._developAss == null) this._developAss = 0;
  ```
- **`_developMouth`** (行11)
  ```javascript
  if (this._developMouth == null) this._developMouth = 0;
  ```

#### 関数定義
- **`gainDevelopment(part, amount)`** (行59-89)
  ```javascript
  Game_Actor.prototype.gainDevelopment = function(part, amount) {
    const norm = String(part||"").toLowerCase();
    const key  = norm === "pussy"   ? "_developPussy"
               : norm === "breasts" ? "_developBreasts"
               : norm === "ass"     ? "_developAss"
               : norm === "mouth"   ? "_developMouth"
               : null;
  ```
- **`getDevelopment(part)`** (行92-99)
  ```javascript
  Game_Actor.prototype.getDevelopment = function(part){
    const norm = String(part||"").toLowerCase();
    return norm === "pussy"   ? (this._developPussy   || 0)
         : norm === "breasts" ? (this._developBreasts || 0)
         : norm === "ass"     ? (this._developAss     || 0)
         : norm === "mouth"   ? (this._developMouth   || 0)
         : 0;
  };
  ```
- **`getDevelopmentStage(part)`** (行101-106)
  ```javascript
  Game_Actor.prototype.getDevelopmentStage = function(part){
    const val = this.getDevelopment(part);
    if (val >= 80) return "high";
    if (val >= 40) return "mid";
    return "low";
  };
  ```

### EroStatus.Store.js

#### 関数定義
- **`getDevelopmentMaxPercent(actorId)`** (行85)
  ```javascript
  const devMaxPct = S.getDevelopmentMaxPercent?.(actorId) ?? 0;
  ```
  ※ 実装は未確認（メタ参照の可能性）

### EroStatus.Adapter.js

#### 関数定義
- **`collectRaw(actorId)`** (行7-43)
  ```javascript
  const dev = PAS?.getDevelopments?.(actor) ?? {};
  ```
  ※ `getDevelopments` は未定義（メタ参照の可能性）

---

## 書き込み（Write）

### PleasureActorStatus.js

- **`gainDevelopment`** (行59-89)
  - 関数: `Game_Actor.prototype.gainDevelopment`
  - 行: 59-89
  - 抜粋: `this[key] = Math.min(100, Math.max(0, this[key] + delta));`
  - 対象: `_developPussy`, `_developBreasts`, `_developAss`, `_developMouth`

- **`initPleasureStatus`** (行6-35)
  - 関数: `Game_Actor.prototype.initPleasureStatus`
  - 行: 8-11
  - 抜粋: `if (this._developPussy == null) this._developPussy = 0;`
  - 対象: 全開発度プロパティの初期化

### PleasureAttackManager.js

- **`applyPleasureEffect`** (行21-80)
  - 関数: `applyPleasureEffect`
  - 行: 61-62
  - 抜粋: `const developmentGain = Number(skill.meta?.DevelopmentGain || 0); if (developmentGain > 0) actor.gainDevelopment(targetPart, developmentGain);`
  - 対象: `targetPart` に応じた開発度増加

### DevelopmentLogOutput.js

- **`gainDevelopment`** (行17-38)
  - 関数: `Game_Actor.prototype.gainDevelopment` (上書き)
  - 行: 27
  - 抜粋: `this[key] = Math.min(100, this[key] + amount);`
  - 対象: 開発度プロパティ（上書き実装）

---

## 読み出し（Read）

### PleasureActorStatus.js

- **`getDevelopment`** (行92-99)
  - 関数: `Game_Actor.prototype.getDevelopment`
  - 行: 92-99
  - 抜粋: `return norm === "pussy" ? (this._developPussy || 0) : ...`
  - 対象: 全開発度プロパティ

- **`getDevelopmentStage`** (行101-106)
  - 関数: `Game_Actor.prototype.getDevelopmentStage`
  - 行: 101-106
  - 抜粋: `const val = this.getDevelopment(part);`
  - 対象: `getDevelopment` 経由で読み出し

- **`onBattleStart`** (行205-215)
  - 関数: `Game_Actor.prototype.onBattleStart`
  - 行: 214
  - 抜粋: `console.log(\`[PAS] Development at battle start: P=${this._developPussy}, B=${this._developBreasts}, A=${this._developAss}, M=${this._developMouth}\`);`
  - 対象: 全開発度プロパティ（ログ出力）

- **`gainDevelopment`** (行59-89)
  - 関数: `Game_Actor.prototype.gainDevelopment`
  - 行: 84
  - 抜粋: `value: this.getDevelopment(norm),`
  - 対象: 通知用に読み出し

### PleasurePoseController.js

- **`getDisplayInfo`** (行205-376)
  - 関数: `PleasurePoseController.getDisplayInfo`
  - 行: 217
  - 抜粋: `const developmentStageForTargetPart = actor.getDevelopmentStage?.(targetPart) ?? "low";`
  - 対象: `getDevelopmentStage` 経由で読み出し

- **`selectDialogueWithLog`** (行116-199)
  - 関数: `PleasurePoseController.selectDialogueWithLog`
  - 行: 116
  - 抜粋: `function(profile, eventType, targetPart, corruptionStage, developmentStage, orgasmCount = 0, actor = null)`
  - 対象: `developmentStage` パラメータとして使用

### EroStatusUI.js

- **`refresh`** (行115-223)
  - 関数: `Window_EroUnifiedPanel.prototype.refresh`
  - 行: 130-131, 194, 199-200
  - 抜粋: 
    ```javascript
    const devOrder = ["pussy", "breasts", "ass", "mouth"];
    const devLabel = { pussy: "膣感度", breasts: "胸感度", ass: "尻感度", mouth: "口感度" };
    const getDev = (part) => Number(actor.getDevelopment?.(part) ?? 0);
    const value = getDev(partKey);
    ```
  - 対象: 全開発度プロパティ（UI表示）

### EroStatus.Store.js

- **`buildFlavorContext`** (行80-89)
  - 関数: `buildFlavorContext`
  - 行: 85
  - 抜粋: `const devMaxPct = S.getDevelopmentMaxPercent?.(actorId) ?? 0;`
  - 対象: 最大開発度（メタ参照）

### EroStatus.Adapter.js

- **`collectRaw`** (行7-43)
  - 関数: `collectRaw`
  - 行: 13
  - 抜粋: `const dev = PAS?.getDevelopments?.(actor) ?? {};`
  - 対象: 開発度オブジェクト（メタ参照）

### EroStatus.Selectors.js

- **`headerInfo`** (行9-19)
  - 関数: `headerInfo`
  - 行: 16
  - 抜粋: `devPussy: a.dev?.pussy ?? 0,`
  - 対象: `dev.pussy`（メタ参照）

### EroSkill.Adapter.js

- **`collectRaw`** (行89-92)
  - 関数: `collectRaw`
  - 行: 89
  - 抜粋: `const dev = PAS?.getDevelopments?.(actor) ?? {};`
  - 対象: 開発度オブジェクト（メタ参照）

### AddEroStatusCommand.js

- **`saveEroStatus`** (行149-167)
  - 関数: `saveEroStatus`
  - 行: 149-156
  - 抜粋:
    ```javascript
    const devBreast = (p?.development?.breasts?.exp ?? ($gameVariables.value(1) ?? 0)) | 0;
    const devPussy = (p?.development?.pussy?.exp ?? ($gameVariables.value(2) ?? 0)) | 0;
    ```
  - 対象: `development.breasts.exp`, `development.pussy.exp`（メタ参照）

- **`drawItem`** (行225-248)
  - 関数: `Window_EroStatusInfo.prototype.drawItem`
  - 行: 225-226, 243, 248
  - 抜粋:
    ```javascript
    const devBreast = (p?.development?.breasts?.exp ?? ($gameVariables.value(1) ?? 0)) | 0;
    const devPussy = (p?.development?.pussy?.exp ?? ($gameVariables.value(2) ?? 0)) | 0;
    this.drawText(`${devBreast % 100} / 100`, x+120, y, w-120, "left");
    this.drawText(`${devPussy % 100} / 100`, x+120, y, w-120, "left");
    ```
  - 対象: `development.breasts.exp`, `development.pussy.exp`（メタ参照）

### EroMemory.js

- **`aggregateMemory`** (行76-83)
  - 関数: `aggregateMemory`
  - 行: 81-83
  - 抜粋:
    ```javascript
    if (d.dev){
      for (const k in d.dev){
        t.dev[k] = (t.dev[k] || 0) + Number(d.dev[k] || 0);
    ```
  - 対象: `dev` オブジェクト（メタ参照）

### PleasureAttackManager.js

- **`applyPleasureEffect`** (行21-80)
  - 関数: `applyPleasureEffect`
  - 行: 49
  - 抜粋: `const targetPart = skill.meta?.TargetPart || 'pussy';`
  - 対象: `targetPart` として部位名を取得

### InsertEventHandler.js

- **`handleInsertEvent`** (行214-354)
  - 関数: `InsertEventHandler.handleInsertEvent`
  - 行: 114
  - 抜粋: `actor, "insert", "pussy", usePre, { phase: usePre ? "pre" : "main" }`
  - 対象: `targetPart` として "pussy" を固定使用

### OrgasmEventHandler.js

- **`handleOrgasmResolveEvent`** (行86-220)
  - 関数: `OrgasmEventHandler.handleOrgasmResolveEvent`
  - 行: 99
  - 抜粋: `const targetPart = skill?.meta?.TargetPart || "pussy";`
  - 対象: `targetPart` として部位名を取得

### PleasureTriggerManager.js

- **`triggerEvent`** (行17-112)
  - 関数: `triggerEvent`
  - 行: 17
  - 抜粋: `async function triggerEvent(actor, eventType = "react", targetPart = "pussy", options = {})`
  - 対象: `targetPart` パラメータ（デフォルト "pussy"）

### PleasureStateManager.js

- **`triggerBustRedraw`** (行22-75)
  - 関数: `triggerBustRedraw`
  - 行: 22
  - 抜粋: `async function triggerBustRedraw(actor, eventType = null, targetPart = "pussy")`
  - 対象: `targetPart` パラメータ（デフォルト "pussy"）

### PleasureEventManager.js

- **`trigger`** (行10-12)
  - 関数: `PleasureEventManager.trigger`
  - 行: 12
  - 抜粋: `async trigger(actor, eventType = "react", targetPart = "pussy")`
  - 対象: `targetPart` パラメータ（デフォルト "pussy"）

### DevelopmentLogOutput.js

- **`gainDevelopment`** (行17-38)
  - 関数: `Game_Actor.prototype.gainDevelopment` (上書き)
  - 行: 32-33
  - 抜粋:
    ```javascript
    const partLabel = targetPart === "pussy" ? "局部"
                    : targetPart === "breasts" ? "乳房"
                    : targetPart;
    ```
  - 対象: `targetPart` として部位名を取得

---

## 部位名定数

### 使用されている部位名

- **`"pussy"`** - 膣（最も頻繁に使用）
- **`"breasts"`** - 乳房
- **`"ass"`** - 尻
- **`"mouth"`** - 口

### 部位名の使用箇所

#### EroStatusUI.js
- 行130-131: `const devOrder = ["pussy", "breasts", "ass", "mouth"];`

#### PleasureActorStatus.js
- 行61-64: `gainDevelopment` 内の部位名マッピング
- 行75: ログ出力用のラベルマッピング
- 行94-97: `getDevelopment` 内の部位名マッピング

#### PleasureAttackManager.js
- 行12: `const WEAK_PARTS = ['pussy', 'breasts'];`
- 行29, 49: `const targetPart = skill.meta?.TargetPart || 'pussy';`

#### VisualRuleEngine.js
- 行9-10: `"p5_slime_pussy"`, `"p5_slime_breast"` (オーバーレイ名)

---

## Save Compatibility

### セーブデータ構造

RPGツクールMZの標準セーブ機構では、`DataManager.makeSaveContents()` が `$gameActors` を保存し、`DataManager.extractSaveContents()` が復元します。

### 保存されるプロパティ

以下の `Game_Actor` インスタンスプロパティは、自動的にセーブデータに含まれます：

- **`_developPussy`** - 膣開発度 (0-100)
- **`_developBreasts`** - 乳房開発度 (0-100)
- **`_developAss`** - 尻開発度 (0-100)
- **`_developMouth`** - 口開発度 (0-100)

### セーブ互換性リスク

#### 1. プロパティ名の変更

**リスク**: `_developPussy` などのプロパティ名を変更すると、既存のセーブデータから値が復元されません。

**影響範囲**:
- `PleasureActorStatus.js` 行8-11: プロパティ定義
- `PleasureActorStatus.js` 行59-89: `gainDevelopment` 内のキーマッピング
- `PleasureActorStatus.js` 行92-99: `getDevelopment` 内のキーマッピング

**推奨対応**: プロパティ名を変更する場合は、`extractSaveContents` の拡張で旧名から新名への移行処理を実装する。

#### 2. 関数名の変更

**リスク**: `gainDevelopment`, `getDevelopment`, `getDevelopmentStage` の関数名を変更すると、呼び出し元が動作しなくなります。

**影響範囲**:
- `PleasureAttackManager.js` 行62: `actor.gainDevelopment(targetPart, developmentGain)`
- `PleasurePoseController.js` 行217: `actor.getDevelopmentStage?.(targetPart)`
- `EroStatusUI.js` 行194: `actor.getDevelopment?.(part)`
- `DevelopmentLogOutput.js` 行15: `Game_Actor.prototype.gainDevelopment` の上書き

**推奨対応**: 関数名を変更する場合は、旧関数を残して新関数を呼び出すラッパーを実装する。

#### 3. メタ参照の削除

**リスク**: 以下のメタ参照が削除されると、該当機能が動作しなくなります。

- `PAS?.getDevelopments?.(actor)` (EroStatus.Adapter.js 行13, EroSkill.Adapter.js 行89)
- `S.getDevelopmentMaxPercent?.(actorId)` (EroStatus.Store.js 行85)
- `a.dev?.pussy` (EroStatus.Selectors.js 行16)
- `p?.development?.breasts?.exp`, `p?.development?.pussy?.exp` (AddEroStatusCommand.js 行149-156, 225-226)

**推奨対応**: メタ参照を削除する前に、実装を確認し、代替手段を用意する。

#### 4. 部位名の変更

**リスク**: `"pussy"`, `"breasts"`, `"ass"`, `"mouth"` などの文字列定数を変更すると、部位判定が失敗します。

**影響範囲**:
- `PleasureActorStatus.js` 行61-64: 部位名マッピング
- `EroStatusUI.js` 行130: `devOrder` 配列
- `PleasureAttackManager.js` 行12: `WEAK_PARTS` 配列
- 各種 `skill.meta?.TargetPart` の参照

**推奨対応**: 部位名を変更する場合は、定数オブジェクトを定義し、一箇所で管理する。

### セーブデータ移行例

```javascript
// DataManager.extractSaveContents の拡張例
const _DataManager_extractSaveContents = DataManager.extractSaveContents;
DataManager.extractSaveContents = function(contents) {
  _DataManager_extractSaveContents.call(this, contents);
  
  // 旧プロパティ名から新プロパティ名への移行
  $dataActors.forEach((actor, id) => {
    const gameActor = $gameActors.actor(id);
    if (gameActor && gameActor._developPussyOld) {
      gameActor._developPussy = gameActor._developPussyOld;
      delete gameActor._developPussyOld;
    }
  });
};
```

---

## まとめ

### 主要な識別子

1. **プロパティ**: `_developPussy`, `_developBreasts`, `_developAss`, `_developMouth`
2. **関数**: `gainDevelopment`, `getDevelopment`, `getDevelopmentStage`
3. **部位名**: `"pussy"`, `"breasts"`, `"ass"`, `"mouth"`

### 優先スキャン対象ファイルでの使用状況

- **PleasureActorStatus.js**: 定義元・書き込み・読み出しの全てを含む
- **PleasurePoseController.js**: `getDevelopmentStage` を読み出し
- **PleasureAttackManager.js**: `gainDevelopment` を呼び出し
- **EroStatusUI.js**: `getDevelopment` を読み出し（UI表示）
- **InsertEventHandler.js**: `targetPart` として "pussy" を使用
- **OrgasmEventHandler.js**: `targetPart` を取得して使用
- **RestraintEventHandler.js**: 部位感度/開発度の直接参照なし（間接的に関連）

### 注意事項

- メタ参照（`PAS?.getDevelopments?.(actor)` など）が複数存在するが、実装が未確認
- 部位名は文字列定数として複数箇所で使用されているため、変更時は影響範囲が広い
- セーブ互換性を保つため、プロパティ名・関数名の変更には移行処理が必要


