# エロ演出システムフロー図解

このドキュメントでは、エロ演出システムの流れを視覚的に図解します。

---

## 🎮 戦闘フローの全体像

```
┌──────────────────────────────────────────────────────────────┐
│                      戦闘開始                                  │
└─────────────────────┬────────────────────────────────────────┘
                      │
                      ▼
        ┌─────────────────────────┐
        │  通常の戦闘ターン進行    │
        │  (poseProfiles)         │
        │  ・react (初期反応)      │
        │  ・danger (危機状態)     │
        │  ・climax (絶頂寸前)     │
        └─────────┬───────────────┘
                  │
                  ▼
        ┌─────────────────────────┐
        │ 敵が拘束スキルを使用？   │
        └────┬──────────────┬──────┘
             │YES           │NO
             ▼              └─→ 通常戦闘継続
    ┌────────────────┐
    │ 拘束イベント発生 │
    │ (restraintProfiles) │
    │ ・first / repeat    │
    │ ・stage1/2/3        │
    │ ・low/mid/high      │
    └────────┬───────┘
             │
             ▼
    ┌─────────────────────────┐
    │  拘束成功！              │
    │  主人公は動けなくなる    │
    └─────────┬───────────────┘
              │
              ▼
    ┌─────────────────────────┐
    │ 敵が挿入スキルを使用？   │
    └────┬──────────────┬──────┘
         │YES           │NO
         ▼              └─→ 拘束状態で戦闘継続
┌──────────────────┐
│ 挿入イベント発生   │
│ (introProfiles)   │
└────────┬─────────┘
         │
         ▼
┌─────────────────────────────────────────┐
│           【挿入イベントの流れ】           │
├─────────────────────────────────────────┤
│                                           │
│  ① pre_first / pre_repeat                │
│     「挿入される直前の描写」               │
│     ・恐怖、拒絶、予感                    │
│                                           │
│           ▼                               │
│                                           │
│  ② プレイヤー選択                         │
│     「抵抗する」 or 「受け入れる」        │
│                                           │
│     ┌─────────┬─────────┐            │
│     │         │         │            │
│     ▼         ▼         ▼            │
│   成功       失敗      受容            │
│     │         │         │            │
│     ▼         ▼         ▼            │
│  resist_  resist_   accept            │
│  success   fail                       │
│  (防いだ) (挿入)   (受容)             │
│                                           │
│           ▼                               │
│                                           │
│  ③ sequence_first / sequence_repeat      │
│     「挿入完了後の描写」                  │
│     ・衝撃、混乱、身体反応                │
│                                           │
└─────────────────────────────────────────┘
         │
         ▼
┌──────────────────────────┐
│   挿入状態で戦闘継続       │
│   (orgasmDetailProfiles)  │
│   ・快感値が上昇           │
│   ・Stage2 → Stage3        │
└────────┬─────────────────┘
         │
         ▼
┌─────────────────────────┐
│  快感値が限界に達する     │
│  (絶頂判定)                │
└────────┬────────────────┘
         │
         ▼
┌─────────────────────────────────────────┐
│         【絶頂イベントの流れ】              │
├─────────────────────────────────────────┤
│                                             │
│  ① sequence                                │
│     「絶頂前の描写」                        │
│     ・息遣い、予兆、限界                   │
│                                             │
│           ▼                                 │
│                                             │
│  ② choices（プレイヤー選択）               │
│     「まだイかない」 or 「もうイっちゃう」 │
│                                             │
│     ┌─────────────┬──────────────┐      │
│     │             │              │      │
│     ▼             ▼              │      │
│  抵抗          受容              │      │
│     │             │              │      │
│     ▼             ▼              │      │
│ after_resist  after_fall         │      │
│  (我慢)       (絶頂)             │      │
│                                             │
└─────────────────────────────────────────┘
         │
         ▼
┌─────────────────────────┐
│  戦闘継続 or 敗北判定     │
└────────┬────────────────┘
         │
         ▼
    ┌──────────┐
    │ ループ継続 │
    │    or      │
    │  戦闘終了  │
    └────────────┘
```

---

## 📊 堕落度とStageの関係

```
┌─────────────────────────────────────────────────────────────┐
│                    堕落度（Corruption）                       │
├──────────────┬──────────────┬──────────────────────────────┤
│   Low (0-39%) │  Mid (40-79%) │      High (80-100%)         │
├──────────────┼──────────────┼──────────────────────────────┤
│ 純粋・無垢   │  葛藤・矛盾   │   恍惚・受容                  │
│ 拒絶・恐怖   │  快感覚醒     │   快楽渇望                    │
│ ♡控えめ      │  ♡中程度      │   ♡多用                       │
└──────────────┴──────────────┴──────────────────────────────┘

                           ×

┌─────────────────────────────────────────────────────────────┐
│                    興奮度（Stage）                            │
├──────────────┬──────────────┬──────────────────────────────┤
│   Stage1      │    Stage2     │        Stage3                │
├──────────────┼──────────────┼──────────────────────────────┤
│ 平常時        │  興奮中       │   興奮高                      │
│ 冷静・長文    │  やや感情的   │   喘ぎ多い・途切れがち       │
│ 理性保持      │  理性揺らぐ   │   理性薄れる                  │
└──────────────┴──────────────┴──────────────────────────────┘

                           ↓

         3段階 × 3段階 = 9パターンの表現
```

---

## 🗂️ ファイル構造とイベントの対応

```
dataEx/
│
├─ restraintProfiles/         ← 【拘束イベント】
│  ├─ [敵名]_restrained_low.json
│  ├─ [敵名]_restrained_mid.json
│  └─ [敵名]_restrained_high.json
│     │
│     └→ 構造:
│         lines:
│           default:
│             stage1/2/3:
│               low/mid/high:
│                 - first: ["セリフ1", "セリフ2"]
│                 - repeat: ["セリフ1", "セリフ2"]
│
├─ introProfiles/insert/      ← 【挿入イベント】
│  ├─ [敵名]_restrained_low.json
│  ├─ [敵名]_restrained_mid.json
│  └─ [敵名]_restrained_high.json
│     │
│     └→ 構造:
│         - pre_first:
│             stage2/3:
│               low: [{ dialogueSequence: [...] }]
│         - pre_repeat
│         - sequence_resist_success
│         - sequence_resist_fail
│         - sequence_accept
│         - sequence_first
│         - sequence_repeat
│
├─ orgasmDetailProfiles/      ← 【絶頂イベント】
│  ├─ [敵名]_restrained_insert_low.json
│  ├─ [敵名]_restrained_insert_mid.json
│  └─ [敵名]_restrained_insert_high.json
│     │
│     └→ 構造:
│         - choices: ["選択肢1", "選択肢2"]
│         - sequence: [{ dialogue: "..." }]
│         - after_resist: [{ dialogue: "..." }]
│         - after_fall: [{ dialogue: "..." }]
│
├─ poseProfiles/              ← 【通常戦闘反応】
│  ├─ [敵名]_restrained_low.json
│  ├─ [敵名]_restrained_mid.json
│  └─ [敵名]_restrained_high.json
│     │
│     └→ 構造:
│         lines:
│           - react:
│               breast:
│                 stage1:
│                   low: [{ dialogueSequence: [...] }]
│           - danger:
│               breast:
│                 stage2:
│                   low:
│                     resist: [{ dialogueSequence: [...] }]
│                     fall: [{ dialogueSequence: [...] }]
│           - climax:
│           - down_attack:
│
└─ flavor/                    ← 【フレーバーテキスト】
   └─ flavorRules.json
      └→ 構造:
          [
            { "name": "character_intro", "text": "..." },
            { "name": "low_corruption", "when": {...}, "text": "..." },
            { "name": "mid_corruption", "when": {...}, "text": "..." },
            { "name": "high_corruption", "when": {...}, "text": "..." }
          ]
```

---

## 🎭 セリフの分岐パターン

### 拘束イベント

```
拘束イベント発生
    │
    ├─ 初回？ → first
    └─ 2回目以降？ → repeat
         │
         ├─ Stage1 (平常)
         ├─ Stage2 (興奮中)
         └─ Stage3 (興奮高)
              │
              ├─ Low (純粋)
              ├─ Mid (葛藤)
              └─ High (恍惚)

→ 3 Stage × 3 堕落度 × 2 (first/repeat) = 18パターン
```

---

### 挿入イベント

```
挿入イベント発生
    │
    ├─ 挿入前
    │   ├─ 初回？ → pre_first
    │   └─ 2回目以降？ → pre_repeat
    │        │
    │        ├─ Stage2
    │        └─ Stage3
    │
    ├─ プレイヤー選択
    │   ├─ 抵抗 → 判定
    │   │   ├─ 成功 → sequence_resist_success
    │   │   └─ 失敗 → sequence_resist_fail
    │   └─ 受容 → sequence_accept
    │
    └─ 挿入完了
        ├─ 初回 → sequence_first
        └─ 2回目以降 → sequence_repeat

→ 7ブロック × 2 Stage × 1 堕落度 = 14パターン（堕落度1段階あたり）
```

---

### 絶頂イベント

```
絶頂判定
    │
    ├─ 絶頂前 → sequence
    │    │
    │    ├─ Stage2
    │    └─ Stage3
    │
    ├─ プレイヤー選択 → choices
    │   ├─ 「まだイかない」
    │   └─ 「もうイっちゃう」
    │
    └─ 絶頂描写
        ├─ 抵抗 → after_resist
        └─ 受容 → after_fall
             │
             ├─ Stage2
             └─ Stage3

→ 4ブロック × 2 Stage × 1 堕落度 = 8パターン（堕落度1段階あたり）
```

---

### 通常戦闘反応

```
戦闘中の状況
    │
    ├─ react (初期反応)
    │   └─ Stage1 のみ
    │
    ├─ danger (危機)
    │   ├─ Stage1: 単純
    │   └─ Stage2以降: resist / fall 分岐
    │
    ├─ climax (絶頂寸前)
    │   ├─ Stage1: 単純
    │   ├─ Stage2: resist / fall 分岐
    │   └─ Stage3: resist / fall 分岐
    │
    └─ down_attack (ダウン中)
        ├─ Stage1
        └─ Stage2

→ 部位（breast）× 状況 × Stage × 堕落度 × resist/fall
```

---

## 🔄 ゲーム内での実際の流れ例

### シナリオ例：スライムに拘束されて挿入される

```
【戦闘開始】
↓
プレイヤーのターン → 攻撃
↓
敵のターン → スライムが「拘束スキル」を使用
↓
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【拘束イベント発生】(restraintProfiles)
Stage1 / Low / first
セリフ: 「なっ…！？動けな…いっ！？」
       「ぴり…ぴりしてる…なに…？このスライム…！」
立ち絵表示: 拘束された状態
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
↓
プレイヤーは「拘束」状態になる（行動不可）
↓
敵のターン → スライムが「挿入スキル」を使用
↓
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【挿入イベント発生】(introProfiles)

① pre_first (挿入前)
Stage2 / Low
セリフ: 「ひっ…な、なに…するつもり…っ！？」
       「まさか…や、やめなさいよっ…！」
       「やだっ…いやぁっ…近づかないでっ！」

② プレイヤー選択
   [抵抗する] ← プレイヤーが選択
   [受け入れる]

③ 抵抗判定 → 失敗！

④ sequence_resist_fail
Stage2 / Low
セリフ: 「やぁっ…っ…うそっ…なにこれっ…！」
       「あっ…やだ…っ…奥…までぇっ！？」
       「やめっ…ぬ、抜いてぇぇっ…っ！」
       「ひゃあぁっ…っ…あぁぁぁっ！」
       「くぅっ…はぁっ…っ…だめぇ…っ…」
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
↓
プレイヤーは「挿入」状態になる
快感値が徐々に上昇し始める
↓
敵のターン → 通常攻撃（挿入中）
快感値上昇 → Stage2 → Stage3
↓
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【絶頂判定】(orgasmDetailProfiles)

① sequence (絶頂前)
Stage3 / Low
セリフ: 「はぁ…っ…はぁっ…もう…動かないで…っ！」
       「あっ…ぅっ…息…できない…っ…！」
       「だめ…もう…限界…なのに…っ！」

② choices（選択肢）
   [まだ…イかない…！] ← プレイヤーが選択
   [もう…イっちゃう…]

③ after_resist (我慢)
Stage3 / Low
セリフ: 「やっ…あっ…んっ…やめ…っ…！」
       「ひゃあっ…っ…奥…当たって…っ！」
       「はぁ…っ…涙…止まら…ない…っ！」
       「あぁっ…あぁぁぁぁっ…あぁぁぁっ！」
       「だめ…っ…こんな…のに…っ！」
       「はぁ…っ…ひくっ…体…動く…っ…」
       「もう…お願い…ゆるして…っ…」
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
↓
戦闘継続...
```

---

## 📈 セリフの表現段階イメージ

```
堕落度 Low（純粋）
─────────────────────────────────────
Stage1: 「動けない！？ 離して！」
        ↓ 冷静だが恐怖
Stage2: 「やだ…また…っ…！」
        ↓ 動揺・息遣い荒く
Stage3: 「あっ…っ…いやぁぁっ！」
        ↓ 感情的・途切れがち


堕落度 Mid（葛藤）
─────────────────────────────────────
Stage1: 「また拘束…気持ちいい…？」
        ↓ 自覚が芽生える
Stage2: 「なんで…っ拘束されるだけで…ゾクゾクする…」
        ↓ 身体反応を認識
Stage3: 「動けない…っ…のに…また感じてる…！？」
        ↓ 葛藤が強まる


堕落度 High（恍惚）
─────────────────────────────────────
Stage1: 「きた♡ ビリビリ拘束♡ 嬉しぃ…♡」
        ↓ 肯定的な反応
Stage2: 「んっ♡ ぅふ…♡ こんなに…縛られたら…♡」
        ↓ 快楽を表現
Stage3: 「もっとぉ♡もっと縛ってぇ♡動けないまま♡イかせてぇ♡」
        ↓ 懇願・渇望
```

---

## 🎯 ライターが意識すべき分岐の優先度

### 最優先：堕落度の違い

```
Low → Mid → High の変化を最も明確に
```

### 次に重要：Stage の違い

```
Stage1（冷静）→ Stage2（動揺）→ Stage3（恍惚）
```

### 細かい分岐：first / repeat, resist / fall

```
初回と繰り返しの違い
抵抗と受容の違い
```

---

## 📊 セリフ数の集計

| イベント | ファイル数 | セリフ行数/堕落度 | 3堕落度合計 |
|----------|------------|-------------------|-------------|
| 拘束 | 3 | 36行 | 108行 |
| 挿入 | 3 | 54行 | 162行 |
| 絶頂 | 3 | 36行 | 108行 |
| 通常反応 | 3 | 37行 | 111行 |
| フレーバー | 1 | 4テキスト | 4テキスト |
| **合計** | **13ファイル** | | **489行 + 4テキスト** |

※ 1キャラクター × 1敵の完全セットの場合

---

## 🔗 次のステップ

この図解でシステムの全体像を理解したら：

1. **`WRITER_GUIDE_システムフローとセリフ仕様.md`** で詳細な仕様を確認
2. **`TEMPLATE_セリフ記入用テンプレート.md`** でセリフを記入
3. **`JSON変換ガイド.md`** でJSONファイル化

---

**作成日**: 2025-11-25  
**バージョン**: 1.0

