/* ここから：AddEroStatusCommand v2.4（ゲージ削除＋右寄せフィット固定） */

/* ここから：AddEroStatusCommand v2.5（ゲージ削除＋右寄せフィット固定・統一版） */
(() => {
  const PLUGIN_NAME = "AddEroStatusCommand";

  // === 固定配置パラメータ ===
  // L: 左カラムの幅（%）
  const FIX = { L: 50, R_OFFSET: 120 }; 

  // ========== 右カラム立ち絵：自動スケール＋右寄せ＋底揃え（フェード内蔵） ==========
  function fitBustToRightColumn(sprite){
    const marginX = 16;
    const marginY = 8;

    const applyLayout = () => {
      const bm = sprite.bitmap;
      if (!bm || !bm.isReady()) return;

      // 右下基準
      sprite.anchor.set(1, 1);

      // 右カラムの高さに合わせてスケール（上下に薄いマージン）
      const targetH = Math.max(1, Graphics.boxHeight - marginY * 2);
      const scale   = Math.min(1, targetH / Math.max(1, bm.height || 1));
      sprite.scale.set(scale, scale);

      // 右端・下端へ配置
        sprite.x = Math.floor(Graphics.boxWidth - marginX + (FIX.R_OFFSET || 0));
        sprite.y = Math.floor(Graphics.boxHeight - marginY);

      // ロード完了時の軽いフェード
      if (sprite._justLoaded) {
        sprite.opacity = 0;
        sprite._fadeTicker = 15;
        sprite._justLoaded = false;
      }
    };

    // 読み込み完了時フック（重複ガード）
    const bm = sprite.bitmap;
    if (bm && !bm._fitHooked) {
      bm._fitHooked = true;
      bm.addLoadListener(() => {
        sprite._justLoaded = true;
        applyLayout();
      });
    }

    // 既に読み込み済みでも反映
    applyLayout();

    // フェード処理を update に差し込む（既存 update の保持）
    const _update = sprite.update || function(){};
    sprite.update = function() {
      _update.call(this);
      if (this._fadeTicker > 0) {
        this._fadeTicker--;
        this.opacity = 255 - Math.floor(255 * (this._fadeTicker / 15));
      }
    };

    // 外部から再レイアウト可能にしておく
    sprite._applyBustLayout = applyLayout;
  }

  // ========== メニューコマンド追加 ==========
  const _addOriginal = Window_MenuCommand.prototype.addOriginalCommands;
  Window_MenuCommand.prototype.addOriginalCommands = function() {
    if (_addOriginal) _addOriginal.call(this);
    this.addCommand("エロステータス", "eroStatus", true);
  };

  const _createCmd = Scene_Menu.prototype.createCommandWindow;
  Scene_Menu.prototype.createCommandWindow = function() {
    _createCmd.call(this);
    this._commandWindow.setHandler("eroStatus", () => SceneManager.push(Scene_EroStatus));
  };

  // ========== シーン本体 ==========
  function Scene_EroStatus(){ Scene_MenuBase.call(this); }
  Scene_EroStatus.prototype = Object.create(Scene_MenuBase.prototype);
  Scene_EroStatus.prototype.constructor = Scene_EroStatus;

  Scene_EroStatus.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);

    // 左カラム（情報）
    const ww = Math.floor(Graphics.boxWidth * (FIX.L/100));
    const wh = Graphics.boxHeight;
    this._info = new Window_EroStatusInfo(new Rectangle(0, 0, ww, wh));
    this.addWindow(this._info);
    this._info.setHandler("cancel", this.popScene.bind(this));
    this._info.deselect();   // ← これで index = -1
    this._info.activate();

    // 右：立ち絵
    const picName = $gameVariables.value(13) || "soph_1";
    this._bustSprite = new Sprite(ImageManager.loadPicture(picName));
    this.addChild(this._bustSprite);
    fitBustToRightColumn(this._bustSprite); // ★ 右寄せ・底揃え・自動スケール

    // 右カラムの薄い下地
    this._rightPanel = this._rightPanel || new PIXI.Graphics();
    this.addChildAt(this._rightPanel, 0);
    this._refreshRightPanel();

    // ふわっと入る
    this.startFadeIn(18, false);

    // 変更検知用
    this._lastPic  = picName;
    this._lastHash = "";
  };

  Scene_EroStatus.prototype._refreshRightPanel = function(){
    const leftW  = Math.floor(Graphics.boxWidth * (FIX.L/100));
    const g = this._rightPanel;
    g.clear();
    g.beginFill(0x000000, 0.08);
    g.drawRect(leftW, 0, Graphics.boxWidth - leftW, Graphics.boxHeight);
    g.endFill();
  };

  // 変更反映ループ
  Scene_EroStatus.prototype.update = function(){
    Scene_MenuBase.prototype.update.call(this);

    // 画像差し替え（変数13）
    const picName = $gameVariables.value(13) || "soph_1";
    if (picName !== this._lastPic) {
      this._lastPic = picName;
      if (this._bustSprite) this.removeChild(this._bustSprite);
      this._bustSprite = new Sprite(ImageManager.loadPicture(picName));
      this.addChild(this._bustSprite);
      fitBustToRightColumn(this._bustSprite); // 差し替え時も必ず同じ処理を通す
    }

    // 数値等の更新（安全版ハッシュ）
    const a = $gameActors.actor(1);
    const p = (a && a._pleasure) ? a._pleasure : null;

    const corruption = (
      (a?.getCorruption?.()) ??
      (a?._pleasure?.corruption) ??
      0
    );

    const devBreast = (
      p?.development?.breasts?.exp ??
      $gameVariables.value(1) ??
      0
    );

    const devPussy = (
      p?.development?.pussy?.exp ??
      $gameVariables.value(2) ??
      0
    );

    // ★ 重要：セックス回数は devPussy と同じ変数を使わない
    const sexCount = $gameVariables.value(4) ?? 0; // ← 変数IDを分離（例：4）
    const birth    = $gameVariables.value(3) ?? 0;
    const comment  = String($gameVariables.value(10) ?? "");

    const hash = [
      corruption|0, devBreast|0, devPussy|0, sexCount|0, birth|0, comment
    ].join("|");

    if (hash !== this._lastHash) {
      this._lastHash = hash;
      this._info.refresh();
    }
  }; // ← 忘れず閉じる！

  // リサイズ対応（update の外で宣言）
  const _onResize = Scene_EroStatus.prototype.onResize;
  Scene_EroStatus.prototype.onResize = function() {
    if (_onResize) _onResize.call(this);
    const ww = Math.floor(Graphics.boxWidth * (FIX.L/100));
    const wh = Graphics.boxHeight;
    if (this._info) this._info.move(0, 0, ww, wh);
    this._refreshRightPanel();
    if (this._bustSprite && this._bustSprite._applyBustLayout) {
      this._bustSprite._applyBustLayout();
    }
  };

  // ========== 情報ウィンドウ（ゲージ削除版：テキストのみ） ==========
  class Window_EroStatusInfo extends Window_Selectable {
    initialize(rect){
      super.initialize(rect);
      this._baseFontSize = 28;
      this.refresh();
    }
    maxItems(){ return 1; }

    // 複数行高さ見積もり（簡易）
    fittingHeightForLinesEx(text){
      const lines = (String(text||"").split(/\r?\n/).length) || 1;
      return this.fittingHeight(lines);
    }

    refresh(){
      this.contents.clear();

      const a = $gameActors.actor(1);
      const p = (a && a._pleasure) ? a._pleasure : null;

      // タイトル
      this.contents.fontSize = 34;
      this.changeTextColor(ColorManager.textColor(0));
      this.drawText("エロステータス", 20, 12, this.contents.width-40, "left");
      this.contents.fontSize = this._baseFontSize;
      this.resetTextColor();

      // 値の収集
      const corruption = (
        (a?.getCorruption?.()) ??
        (a?._pleasure?.corruption) ??
        0
      ) | 0;
      const stage = corruption>=80 ? "high" : corruption>=40 ? "mid" : "low";

      const devBreast = (p?.development?.breasts?.exp ?? ($gameVariables.value(1) ?? 0)) | 0;
      const devPussy  = (p?.development?.pussy?.exp   ?? ($gameVariables.value(2) ?? 0)) | 0;

      const sexCount  = ($gameVariables.value(4) ?? 0) | 0; // ← 変数ID分離
      const birth     = ($gameVariables.value(3) ?? 0) | 0;

      // 表示（テキストのみ）
      let y = 86;
      const x = 24;
      const w = this.contents.width - x - 24;

      this.changeTextColor(ColorManager.systemColor());
      this.drawText("堕落度", x, y, 120, "left"); this.resetTextColor();
      this.drawText(`${corruption} / 100 （${stage}）`, x+120, y, w-120, "left");
      y += 34;

      this.changeTextColor(ColorManager.systemColor());
      this.drawText("胸感度", x, y, 120, "left"); this.resetTextColor();
      this.drawText(`${devBreast % 100} / 100`, x+120, y, w-120, "left");
      y += 28;

      this.changeTextColor(ColorManager.systemColor());
      this.drawText("膣感度", x, y, 120, "left"); this.resetTextColor();
      this.drawText(`${devPussy % 100} / 100`, x+120, y, w-120, "left");
      y += 34;

      this.changeTextColor(ColorManager.systemColor());
      this.drawText("セックス回数", x, y, 120, "left"); this.resetTextColor();
      this.drawText(`${sexCount} 回`, x+120, y, w-120, "left");
      y += 28;

      this.changeTextColor(ColorManager.systemColor());
      this.drawText("出産回数", x, y, 120, "left"); this.resetTextColor();
      this.drawText(`${birth} 回`, x+120, y, w-120, "left");
      y += 40;

      // コメント
      const comment = String($gameVariables.value(10) ?? "");
      if (comment) {
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("コメント", x, y, 200, "left");
        this.resetTextColor();
        y += 28;
        const maxW = this.contents.width - x - 24;
        const h = this.fittingHeightForLinesEx(comment);
        this.drawTextEx(comment, x, y, maxW);
        y += h;
      }

      this._handlers["cancel"] || this.setHandler("cancel", () => {});
    }
  }
})();
