// BattleCustomUI.js

(function() {
  class Window_BattleCustom extends Window_Base {
      initialize(x, y, width, height) {
          super.initialize(new Rectangle(x, y, width, height));
          this._actor = $gameParty.leader();
          this._lastHp = this._actor.hp;
          this._lastMp = this._actor.mp;
          this.opacity = 180;
          this.refresh();
      }

      drawCustomGauge(x, y, width, rate, color1, color2) {
          const fillW = Math.floor(width * rate);
          const gaugeY = y + this.lineHeight() - 8;
          this.contents.fillRect(x, gaugeY, width, 12, ColorManager.gaugeBackColor());
          this.contents.gradientFillRect(x, gaugeY, fillW, 12, color1, color2);
      }

      refresh() {
          this.contents.clear();
          if (this._actor) {
              this.drawText(this._actor.name(), 20, 10, 300, 'left');
              const hpRate = this._actor.hp / this._actor.mhp;
              const hpColor1 = ColorManager.hpGaugeColor1();
              const hpColor2 = ColorManager.hpGaugeColor2();
              this.drawCustomGauge(20, 40, 300, hpRate, hpColor1, hpColor2);
              this.drawText(`HP: ${this._actor.hp}/${this._actor.mhp}`, 20, 40, 300, 'left');
              const mpRate = this._actor.mp / this._actor.mmp;
              const mpColor1 = ColorManager.mpGaugeColor1();
              const mpColor2 = ColorManager.mpGaugeColor2();
              this.drawCustomGauge(20, 70, 300, mpRate, mpColor1, mpColor2);
              this.drawText(`MP: ${this._actor.mp}/${this._actor.mmp}`, 20, 70, 300, 'left');
          }
      }
  }

  // 顔グラフィックを非表示にするための描画オーバーライド
  Window_BattleStatus.prototype.drawItemImage = function(index) {
      // 何もしないことで顔グラフィックを表示させない
  };

  const alias_Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
  Scene_Battle.prototype.createAllWindows = function() {
      alias_Scene_Battle_createAllWindows.call(this);
      this.createCustomBattleWindow();
      this.createCustomCommandWindow();
      // デフォルトのバトルUIを完全に削除
      if (this._statusWindow) this.removeChild(this._statusWindow);
      if (this._partyCommandWindow) this.removeChild(this._partyCommandWindow);
      if (this._actorCommandWindow) this.removeChild(this._actorCommandWindow);
      if (this._helpWindow) this.removeChild(this._helpWindow);
  };

  Scene_Battle.prototype.createCustomBattleWindow = function() {
      const x = 20;
      const y = Graphics.height - 150;
      const width = 400;
      const height = 120;
      this._battleCustomWindow = new Window_BattleCustom(x, y, width, height);
      this.addWindow(this._battleCustomWindow);
  };

  Scene_Battle.prototype.createCustomCommandWindow = function() {
      const x = Graphics.width / 2 - 100;
      const y = Graphics.height - 150;
      const width = 200;
      const height = 100;
      this._battleCommandWindow = new Window_Command(new Rectangle(x, y, width, height));
      this._battleCommandWindow.setHandler('attack', () => { BattleManager.inputtingAction().setAttack(); this.selectNextCommand(); });
      this._battleCommandWindow.setHandler('skill', () => { SceneManager.push(Scene_Skill); });
      this._battleCommandWindow.addCommand('攻撃', 'attack');
      this._battleCommandWindow.addCommand('必殺技', 'skill');
      this.addWindow(this._battleCommandWindow);
  };

  const alias_Scene_Battle_start = Scene_Battle.prototype.start;
  Scene_Battle.prototype.start = function() {
      alias_Scene_Battle_start.call(this);
      this.updateCustomBattleWindow();
  };

  Scene_Battle.prototype.updateCustomBattleWindow = function() {
      const actor = BattleManager.actor();
      if (actor) {
          this._battleCustomWindow.setActor(actor);
      }
  };
})();
