// BattleLogManager.js
(() => {
  console.log("[BattleLogManager] Loaded");

  /**
   * 戦闘中のログを表示するためのシンプルなマネージャー
   * 他のプラグインや表示ロジックと連携しやすくします
   */
  window.BattleLogManager = {
    /**
     * ログメッセージをバトルログウィンドウに表示する
     * @param {string} message - 表示するテキスト（例：スライムが粘液を這わせた）
     */
    push(message) {
      if (!message || typeof message !== "string") return;

      const scene = SceneManager._scene;
      const logWindow = scene?._logWindow;

      if (logWindow && typeof logWindow.addText === "function") {
        logWindow.addText(message); // バトルログウィンドウに出力
        console.log(`[BattleLogManager] log: ${message}`);
      } else {
        // バトル中でない、またはウィンドウがない場合はメッセージウィンドウへ
        console.warn("[BattleLogManager] logWindow not available. Using $gameMessage instead.");
        $gameMessage.add(message);
      }
    }
  };
})();
