// ClothingDurabilityItem.js
// 衣装耐久を回復するアイテム機能を追加
(() => {
  console.log("[ClothingDurabilityItem] Loaded");

  /* ========== アイテムが衣装回復効果を持つか判定 ========== */
  function hasClothingRepairEffect(item) {
    return !!(item && item.meta && (item.meta.RepairClothing || item.meta.RestoreClothing !== undefined));
  }

  function canRepairClothing(target) {
    // アクターで、衣装耐久が最大未満なら回復可能
    return target && target.isActor() && typeof target.getClothingDurability === "function" 
      && target.getClothingDurability() < 100;
  }

  /* ========== アイテム使用可能判定の拡張 ========== */
  const _Game_Action_testApply = Game_Action.prototype.testApply;
  Game_Action.prototype.testApply = function(target) {
    const originalResult = _Game_Action_testApply.call(this, target);
    
    // 元の判定がtrueならそのまま返す
    if (originalResult) return true;
    
    // 衣装回復アイテムの場合、独自の判定を行う
    const item = this.item();
    if (hasClothingRepairEffect(item)) {
      // 戦闘中は常に使用可能
      if ($gameParty.inBattle()) {
        return this.testLifeAndDeath(target);
      }
      // メニュー画面では衣装耐久が最大未満なら使用可能
      return this.testLifeAndDeath(target) && canRepairClothing(target);
    }
    
    return false;
  };

  /* ========== アイテム使用時の効果処理 ========== */
  const _Game_Action_applyItemUserEffect = Game_Action.prototype.applyItemUserEffect;
  Game_Action.prototype.applyItemUserEffect = function(target) {
    _Game_Action_applyItemUserEffect.call(this, target);
    
    // アイテムのメモ欄をチェック
    const item = this.item();
    if (!item || !item.meta) return;
    
    let clothingRepaired = false;
    
    // <RepairClothing:50> で指定した量だけ回復
    if (item.meta.RepairClothing) {
      const amount = Number(item.meta.RepairClothing) || 0;
      if (amount > 0 && target && typeof target.repairClothing === "function") {
        const beforeDurability = target.getClothingDurability();
        target.repairClothing(amount);
        const afterDurability = target.getClothingDurability();
        const actualRepair = afterDurability - beforeDurability;
        
        if (actualRepair > 0) {
          clothingRepaired = true;
          console.log(`[CDI] Clothing repaired by item: +${actualRepair} (${beforeDurability} -> ${afterDurability}) for ${target.name()}`);
          
          // バトルログに表示（戦闘中の場合）
          if ($gameParty.inBattle() && window.BattleLogManager?.push) {
            BattleLogManager.push(`${target.name()}の衣装が修復された！（+${actualRepair}）`);
          }
          // メニュー画面ではメッセージをキューに追加（マップに戻った時に表示）
          else if ($gameMessage && !$gameParty.inBattle()) {
            $gameMessage.add("セリアは破れた衣装を修復した…");
          }
          
          // 成功フラグを立てる
          target.result().success = true;
        }
      }
    }
    
    // <RestoreClothing> で全回復
    if (item.meta.RestoreClothing !== undefined) {
      if (target && typeof target.restoreClothingFully === "function") {
        const beforeDurability = target.getClothingDurability();
        target.restoreClothingFully();
        const afterDurability = target.getClothingDurability();
        const actualRepair = afterDurability - beforeDurability;
        
        if (actualRepair > 0) {
          clothingRepaired = true;
          console.log(`[CDI] Clothing fully restored: ${beforeDurability} -> ${afterDurability} for ${target.name()}`);
          
          // バトルログに表示（戦闘中の場合）
          if ($gameParty.inBattle() && window.BattleLogManager?.push) {
            BattleLogManager.push(`${target.name()}の衣装が完全に修復された！`);
          }
          // メニュー画面ではメッセージをキューに追加（マップに戻った時に表示）
          else if ($gameMessage && !$gameParty.inBattle()) {
            $gameMessage.add(`${target.name()}は破れた衣装を完全に修復した…`);
          }
          
          // 成功フラグを立てる
          target.result().success = true;
        }
      }
    }
    
    // 回復SEを再生（回復が実際に行われた場合のみ）
    if (clothingRepaired) {
      SoundManager.playRecovery();
    }
  };

  /* ========== グローバルスクリプト用のヘルパー関数 ========== */
  // イベントのスクリプトコマンドで使用可能
  
  // 指定したアクターの衣装耐久を回復
  window.repairActorClothing = function(actorId, amount) {
    const actor = $gameActors.actor(actorId);
    if (actor && typeof actor.repairClothing === "function") {
      actor.repairClothing(amount);
      console.log(`[CDI] Clothing repaired for actor ${actorId}: +${amount}`);
      return true;
    }
    return false;
  };
  
  // 指定したアクターの衣装耐久を全回復
  window.restoreActorClothingFully = function(actorId) {
    const actor = $gameActors.actor(actorId);
    if (actor && typeof actor.restoreClothingFully === "function") {
      actor.restoreClothingFully();
      console.log(`[CDI] Clothing fully restored for actor ${actorId}`);
      return true;
    }
    return false;
  };
  
  // パーティ全員の衣装耐久を回復
  window.repairPartyClothing = function(amount) {
    $gameParty.members().forEach(actor => {
      if (actor && typeof actor.repairClothing === "function") {
        actor.repairClothing(amount);
      }
    });
    console.log(`[CDI] Clothing repaired for all party members: +${amount}`);
  };
  
  // パーティ全員の衣装耐久を全回復
  window.restorePartyClothingFully = function() {
    $gameParty.members().forEach(actor => {
      if (actor && typeof actor.restoreClothingFully === "function") {
        actor.restoreClothingFully();
      }
    });
    console.log(`[CDI] Clothing fully restored for all party members`);
  };
  
  // 指定したアクターの衣装耐久を取得
  window.getActorClothingDurability = function(actorId) {
    const actor = $gameActors.actor(actorId);
    if (actor && typeof actor.getClothingDurability === "function") {
      return actor.getClothingDurability();
    }
    return 0;
  };

})();

