(() => {
  // =========================
  // 衣装耐久ウィンドウ本体
  // =========================
  function Window_ClothingDurability() {
    this.initialize(...arguments);
  }

  Window_ClothingDurability.prototype = Object.create(Window_Base.prototype);
  Window_ClothingDurability.prototype.constructor = Window_ClothingDurability;

  Window_ClothingDurability.prototype.initialize = function(x, y) {
    const windowWidth = 205;
    this._lastWantVisible = false; 
    const windowHeight = this.fittingHeight(1);
    const rect = new Rectangle(x, y, windowWidth, windowHeight);
    Window_Base.prototype.initialize.call(this, rect);

    // 初期状態は隠す（次の自分ターンでフェードイン）
    this.opacity = 0;
    this.contentsOpacity = 0;
    this.visible = false;

    // フェード制御パラメータ
    this._fadeTargetOpacity = 0;      // 0 or 255
    this._fadeTargetContents = 0;     // 0 or 255
    this._fadeStepWindow = 20;        // 1フレームあたりのウィンドウ不透明度変化量
    this._fadeStepContents = 22;      // 同：内容（文字）不透明度

    this._actor = null;
    this.refresh();
  };

  Window_ClothingDurability.prototype.setActor = function(actor) {
    if (this._actor !== actor) {
      this._actor = actor;
      this.refresh();
    }
  };

  Window_ClothingDurability.prototype.refresh = function() {
    this.contents.clear();
    if (!this._actor) return;

    const labelText = "衣装耐久";
    const currentValue = this._actor.getClothingDurability?.() ?? 0;
    const maxValue = 100;

    this.changeTextColor(this.systemColor());
    this.drawText(labelText, 0, 0, 120);
    this.resetTextColor();
    this.drawText(`${currentValue}/${maxValue}`, 120, 0, 60, "right");
  };

// 表示条件判定（ここが肝）
//   追加仕様：スキル等の説明（Help）や選択ウィンドウ表示中は非表示
// =========================
function isWindowEffectivelyVisible(win) {
  // 「見えている」扱いの安全判定（undefinedガード付き）
  return !!(win && win.visible && typeof win.openness === "number" && win.openness > 0);
}

function isAnySelectionOrHelpVisible(scene) {
  // バトル中に開き得る選択系＆説明系ウィンドウを列挙
  const candidateWindows = [
    scene._helpWindow,
    scene._skillWindow,
    scene._itemWindow,
    scene._enemyWindow,
    scene._actorWindow,
    // （必要なら他の選択ウィンドウをここに足す）
  ];

  // どれか一つでも「実質見えている」なら true
  if (candidateWindows.some(isWindowEffectivelyVisible)) return true;

  // コマンドウィンドウの「選択中（active）」自体も隠したい場合はここで判定
  // ※「説明が見えている時だけ隠したい」運用なら下記はコメントのままでOK
  /*
  const isAnyCommandActive = !!(
    (scene._actorCommandWindow && scene._actorCommandWindow.active) ||
    (scene._partyCommandWindow && scene._partyCommandWindow.active)
  );
  if (isAnyCommandActive) return true;
  */

  return false;
}

function shouldShowClothingWindow(scene) {
  // プレイヤーの入力フェーズ（自分のコマンドを選べる状態）
  const isPlayerInputPhase = (BattleManager && BattleManager._phase === "input");

  // バトルログやメッセージが一切走っていないこと
  const isLogBusy = !!(scene?._logWindow && scene._logWindow.isBusy && scene._logWindow.isBusy());
  const isMessageBusy = !!($gameMessage && $gameMessage.isBusy && $gameMessage.isBusy());

  // 追加：スキル／アイテム選択やヘルプ説明が表示されていないこと
  const isSelectionOrHelpShown = isAnySelectionOrHelpVisible(scene);

  // 表示条件を統合
  return isPlayerInputPhase && !isLogBusy && !isMessageBusy && !isSelectionOrHelpShown;
}


  function approach(current, target, step) {
    if (current === target) return current;
    if (current < target) return Math.min(target, current + step);
    return Math.max(target, current - step);
  }

  // =========================
  // フェード制御（update）
  // =========================
  Window_ClothingDurability.prototype.update = function() {
  Window_Base.prototype.update.call(this);

  const scene = SceneManager._scene;
  if (!scene) return;

  const wantVisible = shouldShowClothingWindow(scene);

  // ★ ここがポイント：
  // 直前は表示したかった（=出ていた可能性が高い）→
  // 今フレームは非表示にしたい かつ 「選択 or ヘルプ出現中」なら
  // フェードを使わず即時で消す
  const selectionOrHelpShown = isAnySelectionOrHelpVisible(scene);
  const shouldInstantHide = (this._lastWantVisible && !wantVisible && selectionOrHelpShown);

  if (shouldInstantHide) {
    // 即時でパッと消す
    this.opacity = 0;
    this.contentsOpacity = 0;
    this.visible = false;

    // 状態更新して早期リターン（フェード処理はスキップ）
    this._fadeTargetOpacity = 0;
    this._fadeTargetContents = 0;
    this._lastWantVisible = wantVisible;
    return;
  }

  // 以降は従来どおりのフェード（スッ…）
  const targetWindow   = wantVisible ? 255 : 0;
  const targetContents = wantVisible ? 255 : 0;

  this._fadeTargetOpacity  = targetWindow;
  this._fadeTargetContents = targetContents;

  const newOpacity   = approach(this.opacity, this._fadeTargetOpacity,  this._fadeStepWindow);
  const newContents  = approach(this.contentsOpacity, this._fadeTargetContents, this._fadeStepContents);

  if (this.opacity !== newOpacity) this.opacity = newOpacity;
  if (this.contentsOpacity !== newContents) this.contentsOpacity = newContents;

  const reallyVisible = (this.opacity > 0 || this.contentsOpacity > 0);
  if (this.visible !== reallyVisible) this.visible = reallyVisible;

  // 直近状態を保存（次フレームの遷移検出に使う）
  this._lastWantVisible = wantVisible;
};

  // =========================
  // Scene_Battle への組み込み
  // =========================
  const _Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
  Scene_Battle.prototype.createAllWindows = function() {
    _Scene_Battle_createAllWindows.call(this);
    this.createClothingDurabilityWindow();
  };

  Scene_Battle.prototype.createClothingDurabilityWindow = function() {
    const posX = 0;   // ★必要に応じて座標調整
    const posY = 0;
    this._clothingDurabilityWindow = new Window_ClothingDurability(posX, posY);
    this._clothingDurabilityWindow.setActor($gameParty.leader());
    this.addWindow(this._clothingDurabilityWindow);
  };

  // グローバルからも触れるように輸出
  window.Window_ClothingDurability = Window_ClothingDurability;
})();
