(() => {
  console.log('[CustomBattleUILayout] Loaded');

  // バトルUIを左寄せにする関数（コマンド表示優先）
  function adjustBattleUIPosition() {
      const scene = SceneManager._scene;
      if (!(scene instanceof Scene_Battle)) return;

      // コマンドウィンドウとステータスウィンドウをデフォルト配置に戻す
      const defaultWindows = [
          scene._partyCommandWindow,
          scene._actorCommandWindow
      ];

      // 位置と透明度をデフォルト値に設定
      defaultWindows.forEach(window => {
          if (window) {
              window.opacity = 255;  // 不透明
          }
      });

      // 座標を手動で指定
      scene._actorCommandWindow.x = 156;
      scene._actorCommandWindow.y = 417;
      scene._partyCommandWindow.x = 156;
      scene._partyCommandWindow.y = 417;

      console.log(`[CustomBattleUILayout] ActorCommandWindow and PartyCommandWindow set to (156, 417)`);
  }

  // BattleBustManagerがロードされた後に実行されるようにする
  function modifyBattleBustManager() {
      if (window.BattleBustManager && typeof window.BattleBustManager.createSpriteGroup === "function") {
          const _createSpriteGroup = window.BattleBustManager.createSpriteGroup.bind(window.BattleBustManager);
          window.BattleBustManager.createSpriteGroup = function(actor) {
              const group = _createSpriteGroup(actor);
              group.x = Graphics.width * 0.75;
              group.y = Graphics.height;
              return group;
          };
          console.log("[CustomBattleUILayout] BattleBustManager modified");
      } else {
          console.warn("[CustomBattleUILayout] BattleBustManager not found or method missing, retrying...");
          setTimeout(modifyBattleBustManager, 100);  // 100ms 後に再試行
      }
  }

  // バトル開始時にUI位置を調整
  const _Scene_Battle_start = Scene_Battle.prototype.start;
  Scene_Battle.prototype.start = function() {
      _Scene_Battle_start.call(this);
      adjustBattleUIPosition();
      modifyBattleBustManager();
      console.log('[CustomBattleUILayout] Battle UI adjusted');
  };
})();
