/*:
 * @target MZ
 * @plugindesc 戦闘中、開発度上昇をバトルログに表示するプラグイン
 * @author Gizmo
 *
 * @help
 * このプラグインは、Game_Actor.prototype.gainDevelopment を上書きし、
 * 開発度上昇時に戦闘ログへ無機質なログを出力します。
 *
 * 出力例：
 * ヒロインの局部が敏感になった！（開発度＋3）
 */

(() => {
  const _gainDevelopment = Game_Actor.prototype.gainDevelopment;

  Game_Actor.prototype.gainDevelopment = function(targetPart, amount) {
    const key = `_develop${targetPart.charAt(0).toUpperCase() + targetPart.slice(1)}`;
    console.log(`[Debug] ${this.name()}の${targetPart}の現在の開発度: ${this[key]}`);

    if (this[key] === undefined) {
      console.warn(`[開発ログ] 無効な部位: ${targetPart}`);
      return;
    }

    // 加算処理
    this[key] = Math.min(100, this[key] + amount);
    console.log(`[開発ログ] ${targetPart} +${amount} → ${this[key]}`);

    // バトルログ出力
    if ($gameParty.inBattle() && window.BattleLogManager?.push) {
      const partLabel = targetPart === "pussy" ? "局部"
                      : targetPart === "breasts" ? "乳房"
                      : targetPart === "ass" ? "尻"
                      : targetPart === "mouth" ? "口"
                      : targetPart;
      const message = `${this.name()}の${partLabel}が敏感になった！（開発度＋${amount}）`;
      BattleLogManager.push(message);
    }
  };
})();
