/*:
 * @target MZ
 * @plugindesc 敵キャラの表示位置をメモ欄 <PositionOffset: x, y> で調整できるプラグイン
 * @author ChatGPT
 *
 * @help
 * ■使い方：
 * 敵キャラのメモ欄に以下のように記述すると、
 * 戦闘時の表示位置を調整できます。
 *
 * <PositionOffset: 50, -30>
 * → X方向に +50ピクセル、Y方向に -30ピクセルずらして表示されます。
 *
 * ■注意：
 * - 値は整数で指定してください。
 * - 値の前後に空白があっても構いません。
 * - 敵キャラごとに個別に調整できます。
 *
 * このプラグインにパラメータはありません。
 */

(() => {
  const _Sprite_Enemy_updatePosition = Sprite_Enemy.prototype.updatePosition;

  Sprite_Enemy.prototype.updatePosition = function () {
    _Sprite_Enemy_updatePosition.call(this);

    const battler = this._enemy;
    if (!battler) return;

    const meta = battler.enemy().meta;
    if (meta.PositionOffset) {
      const match = meta.PositionOffset.match(/(-?\d+)\s*,\s*(-?\d+)/);
      if (match) {
        const xOffset = parseInt(match[1]);
        const yOffset = parseInt(match[2]);
        this.x += xOffset;
        this.y += yOffset;
      }
    }
  };
})();
