/*:
 * @target MZ
 * @plugindesc EroSkill Adapter (defs load & unlock evaluation)
 */
(() => {
  const NS = (window.EroStatus ??= {});   // 既存名前空間を借りる
  const SK = (NS.Skill ??= {});           // エロスキル用のサブ名前空間

  // ---------- ユーティリティ ----------
  function deepGet(o, path){ return path.split(".").reduce((a,k)=>a?.[k], o); }
  function cmp(v, c){
    if (c.eq  !== undefined) return v === c.eq;
    if (c.gte !== undefined) return v >=  c.gte;
    if (c.lte !== undefined) return v <=  c.lte;
    if (c.gt  !== undefined) return v >   c.gt;
    if (c.lt  !== undefined) return v <   c.lt;
    return !!v;
  }
  function meets(cond, ctx){
    if (!cond || typeof cond !== "object") return true;
    if (cond.all) return cond.all.every(c => meets(c, ctx));
    if (cond.any) return cond.any.some(c => meets(c, ctx));
    if (cond.not) return !meets(cond.not, ctx);
    if (cond.stat)     return cmp(ctx[cond.stat] ?? deepGet(ctx, "stats."+cond.stat), cond);
    if (cond.counter)  return cmp(deepGet(ctx.counters, cond.counter), cond);
    if (cond["orgasm.part"]) return cmp(deepGet(ctx.byPart, cond["orgasm.part"]), cond);
    if (cond.enemy)    return cmp(deepGet(ctx.byEnemy, cond.enemy), cond);
    return true;
  }

  // ---------- 定義の読込＆tierマージ ----------
  let _defsCache = null;
  function loadDefs(){
    if (_defsCache) return _defsCache;
    // RPGツクールのデータロード規約に合わせる
    const xhr = new XMLHttpRequest();
    xhr.open("GET", "data/ero_skills.json");
    xhr.overrideMimeType("application/json");
    xhr.onload = () => { _defsCache = mergeTiers(JSON.parse(xhr.responseText || "[]")); };
    xhr.onerror = () => { _defsCache = []; console.warn("[EroSkill.Adapter] failed to load defs"); };
    xhr.send();
    // 初回は空を返す（次回refreshで埋まる）
    return _defsCache ?? [];
  }

  function mergeTiers(rows){
    const map = new Map();
    for (const r of rows){
      const key = r.id;
      const cur = map.get(key) ?? {};
      // tierごとの上書き運用：共通項目はベース、tier個別は配列pushか上書き
      if (!cur.base) cur.base = r.tier ? {} : r;
      if (r.tier) (cur.tiers ??= []).push(r);
      map.set(key, cur);
    }
    // 返却：idごとに「最大tier適用済みのflatten定義」を作る
    const out = [];
    for (const [id, pack] of map){
      const base = pack.base ?? {};
      const tiers = (pack.tiers ?? []).sort((a,b)=> (a.tier||1)-(b.tier||1));
      // 最大tierのみ適用して“一枚の定義”として扱う
      const maxTier = tiers.length ? tiers[tiers.length-1].tier : (base.tier || 1);
      let merged = {...base, id, maxTier};
      for (const t of tiers){
        merged = {
          ...merged,
          tier: t.tier,
          unlock: t.unlock ?? merged.unlock,
          effects: t.effects ?? merged.effects
        };
      }
      if (!merged.tier) merged.tier = base.tier || 1;
      out.push(merged);
    }
    return out;
  }

  // ---------- 収集：進行×定義で解放評価 ----------
  function collect(actorId){
    // 進行状況（セーブ側）
    const sys = $gameSystem || {};
    const S  = (sys._eroSkills ||= { unlocked:{}, equipped:[], prefs:{} });
    const C  = (sys._eroCounters ||= { orgasms_total:0, byEnemy:{}, byPart:{}, choice:{} });

    // 俳優のステ（堕落度など）
    const actor = $gameActors.actor(actorId);
    const PAS   = window.PleasureActorStatus;
    const corruption = PAS?.getCorruption?.(actor) ?? 0;
    const dev = PAS?.getDevelopments?.(actor) ?? {};

    const ctx = {
      corruption, stats:{corruption}, dev,
      counters: C,
      byEnemy: C.byEnemy || {},
      byPart:  C.byPart  || {},
      choice:  C.choice  || {},
    };

    const defs = loadDefs(); // キャッシュ or 読み込み途中なら空配列
    const list = defs.map(d => {
      const unlockedTier = S.unlocked?.[d.id] || 0;
      const isUnlocked = unlockedTier >= (d.tier || 1);
      // 次Tierヒント（人間語はSelectorsで美化、ここは生データ）
      const nextHint = isUnlocked && d.tier < (d.maxTier || d.tier) ? (d.unlock || null) : (!isUnlocked ? (d.unlock || null) : null);
      return {
        id: d.id,
        name: d.name,
        desc: d.desc,
        type: d.type || "passive",
        icon: d.icon || "skill",
        tags: d.tags || [],
        tier: Math.max(unlockedTier, d.tier || 1),
        maxTier: d.maxTier || d.tier || 1,
        locked: !isUnlocked,
        nextUnlockCond: nextHint,     // ← 生の条件式（Selectorsで文にする）
        effects: d.effects || []
      };
    });

    // スロット（アクティブ想定、今は固定値でOK）
    const slots = { activeMax: 3, activeUsed: (S.equipped || []).length };

    return { defs, list, equipped: S.equipped || [], slots };
  }

  SK.Adapter = { collect };
})();
