/*:
 * @target MZ
 * @plugindesc EroSkill Selectors (UI shaping)
 */
(() => {
  const NS = (window.EroStatus ??= {});
  const SK = (NS.Skill ??= {});

  function condToHint(cond){
    if (!cond) return "";
    // ざっくり人間語に（必要十分：詳細は後で強化）
    const p = [];
    const leaf = c => {
      if (c.stat === "corruption" && c.gte != null) return `堕落度 ${c.gte}+`;
      if (c.counter) return `${c.counter.replace(/\./g,"/")} ${c.gte ?? c.eq ?? c.lte ?? c.gt ?? c.lt ?? "達成"}`;
      if (c["orgasm.part"]) return `絶頂(${c["orgasm.part"]}) ${c.gte ?? 1}+`;
      if (c.enemy) return `対${c.enemy} ${c.gte ?? 1}+`;
      return "条件達成";
    };
    if (cond.all) return cond.all.map(leaf).join("・");
    if (cond.any) return cond.any.map(leaf).join(" / ");
    return leaf(cond);
  }

  function selectSkillList(){
    const s = NS.getState?.() || {};
    const sk = s.raw?.skills || { list:[], equipped:[], slots:{activeMax:3,activeUsed:0} };
    const eqSet = new Set(sk.equipped || []);
    return sk.list.map(x => ({
      id: x.id,
      name: x.locked ? "????" : x.name,
      locked: !!x.locked,
      tier: x.tier,
      maxTier: x.maxTier,
      equipped: eqSet.has(x.id),
      icon: x.locked ? "icon_lock" : x.icon,
      hint: x.locked ? "未解放" : condToHint(x.nextUnlockCond) || "",
      opacity: x.locked ? 160 : 255,
      type: x.type
    }));
  }

  function selectSkillDetail(id){
    const s = NS.getState?.() || {};
    const sk = s.raw?.skills || { list:[], equipped:[] };
    const x = sk.list.find(v => v.id === id);
    if (!x) return { title:"", desc:"", effects:[], locked:true };
    return {
      title: x.locked ? "????" : x.name,
      desc:  x.locked ? "未解放です。" : (x.desc || ""),
      tier:  x.tier, maxTier: x.maxTier,
      locked: !!x.locked,
      effects: x.locked ? [] : x.effects
    };
  }

  function selectSkillSlots(){
    const s = NS.getState?.() || {};
    const slots = s.raw?.skills?.slots || { activeMax:3, activeUsed:0 };
    return slots;
  }

  SK.Selectors = { selectSkillList, selectSkillDetail, selectSkillSlots };
})();
