/*:
 * @target MZ
 * @plugindesc EroStatus Adapter (External Bridge)
 */
(() => {
  const NS = (window.EroStatus ??= {});
  function collectRaw(actorId){
    const actor = $gameActors.actor(actorId);
    const PAS   = window.PleasureActorStatus;
    const bustName = $gameVariables?.value(13) || "soph_1";

    const corruption = PAS?.getCorruption?.(actor) ?? 0;
    const dev        = PAS?.getDevelopments?.(actor) ?? {};
    const clothes    = PAS?.getClothingDurability?.(actor) ?? 0;

    const states = actor?.states()?.map(s => s?.name ?? "") ?? [];
    const memory = $gameSystem?._eroMemories ?? [];
    const unlocked = true; // TODO: 条件ができたらここで判定

    // EroStatus.Adapter.js の collectRaw 内（該当 return 直前）を書き換え
const callOrGet = (obj, key, fallback = undefined) => {
  const v = obj?.[key];
  return (typeof v === "function") ? v.call(obj) : (v ?? fallback);
};

return {
  actor: {
    id: actorId,
    name: callOrGet(actor, "name", "???"),
    level: callOrGet(actor, "level", 1),
    corruption, dev, bustName,
  },
  basic: { 
    hp: callOrGet(actor, "hp", 0),   // hp/mp/tp は数値プロパティ想定
    mp: callOrGet(actor, "mp", 0),
    tp: callOrGet(actor, "tp", 0),
    clothes
  },
  bad:   { states },
  memory:{ unlocked, items: memory },
};

  }
  NS.Adapter = { collectRaw };
})();
