/*:
 * @target MZ
 * @plugindesc EroStatus Controller (Event Wiring)
 */
(() => {
  const NS = (window.EroStatus ??= {});
  const Events = NS.Events || {};
  const Store  = NS.Store  || {};
  const Adapter = NS.Adapter || {};
  const { setActor, setTab, setRaw, getState } = Store;

  function wire(){
    if (!NS.on || !setActor || !setTab || !setRaw) return; // 依存が未ロードなら諦める
    NS.on(Events.ACTOR_CHANGED, id => setActor(id));
    NS.on(Events.TAB_CHANGED,    tab => setTab(tab));
    NS.on(Events.REQUEST_REFRESH, () => {
      const id  = getState?.().actorId ?? 1;
      const raw = Adapter.collectRaw ? Adapter.collectRaw(id) : {};
      setRaw(raw);
    });

    // 追加：スキル用の再集計イベント（あれば）
    NS.on?.(Events.SKILL_REQUEST_REFRESH, () => {
      const id = getState?.().actorId ?? 1;
      const base   = Adapter.collectRaw?.(id) || {};
      const skills = NS.Skill?.Adapter?.collect?.(id) || {};
      setRaw({ ...base, skills });
    });
  }

  // --- プラグインコマンド（AddStoryGauge） ---
  const PLUGIN_NAME = "EroStatus";
  if (PluginManager?.registerCommand){
    PluginManager.registerCommand(PLUGIN_NAME, "AddStoryGauge", args => {
      const actor = $gameParty?.leader?.();          // ← ここを安全参照に
      if (!actor) return;
      const actorId = actor.actorId();
      const gauge   = String(args.type || "drift");  // "courage"|"bond"|"drift"|"arousal"
      const amount  = Number(args.amount || 1);

      const v = NS.Store?.addStoryGauge?.(actorId, gauge, amount);
      if (v != null){
        const label = NS.Store?._labels?.[gauge] || gauge;
        $gameMessage.add(`${label} +${amount}（${v}/3）`);
        AudioManager.playSe({name:"Coin", pan:0, pitch:120, volume:70});
        NS.emit?.(Events.STORY_GAUGE_CHANGED, { actorId, gauge, value: v });
      }
    });
  }

  // --- ブート完了後にワイヤリング ---
  const _Scene_Boot_start = Scene_Boot.prototype.start;
  Scene_Boot.prototype.start = function(){
    _Scene_Boot_start.call(this);
    try { NS.Controller?.wire?.(); } catch(e){ console.error("[EroStatus.Controller] wire failed", e); }
  };

  NS.Controller = { wire };
})();
