/*:
 * @target MZ
 * @plugindesc EroStatus Selectors (ViewModel)
 */
(() => {
  const NS = (window.EroStatus ??= {});
  const { getState } = NS.Store;

  function headerInfo(){
    const s = getState();
    const a = s.raw.actor || {};
    return {
      name: a.name ?? "???",
      level: a.level ?? 1,
      corruption: a.corruption ?? 0,
      devPussy: a.dev?.pussy ?? 0,
      bustName: a.bustName ?? "soph_1",
    };
  }

  function detailForCurrentTab(){
    const { tab, raw } = getState();
    if (tab === "basic") return raw.basic ?? {};
    if (tab === "bad")   return raw.bad   ?? {};
    if (tab === "memory"){
      const m = raw.memory ?? { unlocked:false, items:[] };
      if (!m.unlocked) return { unlocked:false, items:(m.items||[]).map(()=>({title:"??????"})) };
      return m;
    }
    return {};
  }


    // ★ 追加：UIで使うためのストーリーゲージ配列（label付き）
  function storyGaugesForCurrentActor(){
    const s = getState();
    const id = s.actorId ?? 1;
    const gauges = NS.Store.getStoryGauges?.(id) || { courage:0, bond:0, drift:0, arousal:0 };
    const order  = NS.Store._order  || ["courage","bond","drift","arousal"];
    const labels = NS.Store._labels || { courage:"🗡️勇気", bond:"🤝絆", drift:"💦流され度", arousal:"💗発情度" };
    return order.map(key => ({ key, label: labels[key] || key, value: (gauges[key] | 0) })); // 0..3
  }


  NS.Selectors = { headerInfo, detailForCurrentTab,storyGaugesForCurrentActor };
})();
