/*:
 * @target MZ
 * @plugindesc バトルステータスのウィンドウ幅とアクター表示幅を調整する（幅350、表示幅160固定）
 * @author ChatGPT
 *
 * @help
 * このプラグインは、バトルステータスウィンドウの横幅を350pxに変更し、
 * 各アクターの表示領域幅を160pxに固定します。
 */

(() => {
  const FIXED_ITEM_WIDTH = 160;
  const FIXED_WINDOW_WIDTH = 350;

  // アクターごとの表示幅を固定
  Window_BattleStatus.prototype.itemWidth = function() {
    return FIXED_ITEM_WIDTH;
  };

  Window_BattleStatus.prototype.itemRect = function(index) {
    const width = this.itemWidth();
    const height = this.itemHeight();
    const x = index * width;
    const y = 0;
    return new Rectangle(x, y, width, height);
  };

  // ステータスウィンドウ作成時に幅を調整
  const _Scene_Battle_createStatusWindow = Scene_Battle.prototype.createStatusWindow;
  Scene_Battle.prototype.createStatusWindow = function() {
    _Scene_Battle_createStatusWindow.call(this);

    const win = this._statusWindow;
    win.width = FIXED_WINDOW_WIDTH;
    win.createContents(); // 内容再作成（サイズ変更に対応）
    win.refresh();
    console.log("[Plugin] Status Window resized to", win.width);
  };
})();
