/* InsertEventHandler – 完成版（first + repeat / resist判定 / 安全な初期化と順序） */
(() => {

  const FILE_VERSION = "2024-11-15-v2-PINK-BG";
  console.log(`[InsertEventHandler] Enhanced version (first + repeat + resist/accept + safe wiring) - VERSION: ${FILE_VERSION}`);

  // 名前空間
  if (!window.InsertEventHandler) window.InsertEventHandler = {};
  const IEH = window.InsertEventHandler;

  /* ============================== 戦闘境界の初期化 ============================== */
  const _onBattleStart = Game_Actor.prototype.onBattleStart;
  Game_Actor.prototype.onBattleStart = function () {
    _onBattleStart.call(this);
    this._pleasure = this._pleasure || {};
    this._pleasure.insertedEventShown = false;          // 初回導入は毎戦解禁
    this._pleasure.insertRepeatShownThisTurn = false;   // 同ターン連打抑止もリセット
    this._pleasure.hasSeenInsertIntro = false; // 戦闘ごとに導入既視はリセット

  };

  // ターン頭で“同ターン再生済み”を解除（全アクター対応）
  const _BM_updateTurn = BattleManager.updateTurn;
  BattleManager.updateTurn = function () {
    try {
      const members = $gameParty?.members?.() || [];
      for (const a of members) {
        if (a?._pleasure) a._pleasure.insertRepeatShownThisTurn = false;
      }
    } catch (_) {}
    _BM_updateTurn.call(this);
  };

  /* ============================== 内部ユーティリティ ============================== */
  function isRestrained(actor) {
    try { return !!window.PleasureStateManager?.isActorRestrained?.(actor); }
    catch { return false; }
  }

  // --- 内訳行ビルド：Coreに説明APIがあれば優先、無ければ簡易表示 ---
function buildInsertResistDetailLines(actor, rate0to1) {
  // 1) Core側の説明APIがあればそれを使う（推奨）
  try {
    if (typeof ResistanceCore?.explainInsertResist === "function") {
      const exp = ResistanceCore.explainInsertResist(actor); // 例: {base:0.6, items:[{label,delta:+0.05},...]}
      if (Array.isArray(exp)) return exp;
      const lines = [];
      if (typeof exp?.base === "number") lines.push(`基礎 ${Math.round(exp.base * 100)}%`);
      if (Array.isArray(exp?.items)) {
        for (const it of exp.items) {
          if (typeof it?.delta === "number") {
            const sign = it.delta >= 0 ? "+" : "−";
            lines.push(`${it.label ?? "補正"} ${sign}${Math.abs(Math.round(it.delta * 100))}%`);
          } else if (typeof it === "string") {
            lines.push(it);
          }
        }
      }
      lines.push(`＝ 合計 ≈ ${Math.round(Math.max(0, Math.min(1, rate0to1)) * 100)}%`);
      return lines;
    }
  } catch (_) {}

  // 2) 簡易：雰囲気表示（値が取れたものだけ出す）
  const lines = [];
  const pct = Math.round(Math.max(0, Math.min(1, rate0to1)) * 100);
  lines.push("基礎・各種補正");
  const corr = actor?.getCorruption?.();
  if (typeof corr === "number") lines.push(`屈服 現在${Math.round(corr)}`);
  const duraRate = actor?.getOutfitDurabilityRate?.();
  if (typeof duraRate === "number") lines.push(`衣装耐久 ${Math.round(duraRate * 100)}%`);
  lines.push(`＝ 合計 ≈ ${pct}%`);
  return lines;
}


  // 選択肢（BM実装が無い環境でも動くフォールバック）
  async function showChoiceAsyncCompat(choices /* [{text, symbol}] */) {
    if (window.BattleManager?.showChoiceAsync) {
      return window.BattleManager.showChoiceAsync(choices);
    }
    const scene = SceneManager._scene;
    if (scene && typeof scene.showResolveChoiceWindow === "function") {
      return new Promise(resolve => {
        const labels = choices.map(c => c.text);
        scene.showResolveChoiceWindow(labels, idx => {
          const c = choices[Math.max(0, Math.min(idx, choices.length - 1))];
          resolve(c?.symbol || "resist");
        });
      });
    }
    // デバッグ時の最小フォールバック
    return "resist";
  }

  // メッセージ待機（グローバルが無ければローカル実装）
  async function waitMW() {
    if (typeof window.waitMessageWindow === "function") {
      return window.waitMessageWindow();
    }
    return new Promise(r => {
      const h = setInterval(() => {
        try { if (!$gameMessage.isBusy()) { clearInterval(h); r(); } }
        catch { clearInterval(h); r(); }
      }, 10);
    });
  }

  /* ============================== 共通：行ごと再生 ============================== */
  IEH.playSequence = async function (actor, steps, phase = "pre", insertedResult = false, options = {}) {
    // ★オプションから表情固定フラグを取得
    const { forceExpression = null } = options;
    
    // ★スキルからtargetPartを取得（媚薬スライムの口挿入などに対応）
    const skill = BattleManager._action?.item?.();
    const targetPart = skill?.meta?.TargetPart || "pussy";  // デフォルトはpussy
    console.log(`[IEH] playSequence targetPart: ${targetPart} (from skill meta)${forceExpression ? `, forceExpression: ${forceExpression}` : ''}`);
    
    for (const step of (steps || [])) {
      const usePre = (phase === "pre");
      const base = await PleasurePoseController.getDisplayInfo(
        actor, "insert", targetPart, usePre, { phase: usePre ? "pre" : "main" }
      );

      // 1行(dialogue/text)でも確実に dialogueSequence 化
      const lineText = step.dialogue ?? step.text ?? "";
      let seq = step.dialogueSequence ?? (lineText ? [{ text: lineText, fx: step.fx, se: step.se }] : null);

      // ★ VisualAutoFill で dialogueSequence を自動補完
      if (seq && window.VisualAutoFill) {
        const profile = window._poseProfileCache?.[base.profileName];
        const currentIsRestrained = window.PleasureStateManager?.isActorRestrained?.(actor) || false;
        
        const autoFillContext = {
          profileName: base.profileName,
          profile: profile || {},
          stage: window.PleasurePoseController.determinePleasureStage?.(actor.getOrgasmCount?.() || 0) || "stage2",
          eventType: "insert",
          phase: phase,
          targetPart: targetPart,  // ★スキルから取得した値を使用
          enemyKey: profile?.meta?.enemyKey || base.profileName?.split("_")[0] || "unknown",
          isInserted: insertedResult,  // ★insertedResultに基づいて動的に設定（抵抗成功時はfalse）
          isRestrained: currentIsRestrained,
          forceExpression: forceExpression,  // ★表情固定オプション（抵抗成功時など）
          suppressSfx: !currentIsRestrained && !insertedResult  // ★非拘束かつ非挿入時はSFX不要
        };
        seq = window.VisualAutoFill.autoFillDialogueSequence(seq, autoFillContext);
        console.log(`[IEH] Auto-filled dialogueSequence for insert event (targetPart=${targetPart}, phase=${phase}, isInserted=${insertedResult}, suppressSfx=${autoFillContext.suppressSfx})`);
      }

      const displayInfo = {
        ...base,                      // profileName / eventType などの基本情報を継承
        pose:       step.pose       ?? base.pose,
        expression: step.expression ?? base.expression,
        overlays:   Array.isArray(step.overlays) ? step.overlays : base.overlays,
        dialogue: "",
        dialogueSequence: seq,
        underOverlays: Array.isArray(step.underOverlays) ? step.underOverlays : base.underOverlays,
        eventType: "insert",
        log: step.log ?? ""
      };

      if (window.PleasureDisplayManager?.show) await window.PleasureDisplayManager.show(actor, displayInfo);
      if (displayInfo.log && window.BattleLogManager?.push) window.BattleLogManager.push(displayInfo.log);
      await waitMW();
    }
  };

  /* ============================== プロファイルアクセス ============================== */
  IEH.loadInsertDetailProfile = async function (profileName) {
    if (!window._insertDetailProfileCache) window._insertDetailProfileCache = {};
    if (window._insertDetailProfileCache[profileName]) return;

    try {
      const res = await fetch(`dataEx/introProfiles/insert/${profileName}.json`);
      if (!res.ok) throw new Error("HTTP " + res.status);
      window._insertDetailProfileCache[profileName] = await res.json();
      console.log(`[InsertProfile] Loaded: ${profileName}`);
    } catch (e) {
      console.warn(`[InsertProfile] Failed: ${profileName}`, e);
    }
  };

  // pre（掛け合い）
  IEH.getInsertPreSequence = function (profileName, stageKey, corruptionStage, isFirstTime) {
    const p = window._insertDetailProfileCache?.[profileName];
    if (!p) return [];
    const key = isFirstTime ? "pre_first" : "pre_repeat";
    let data = p?.[key]?.[stageKey]?.[corruptionStage];
    
    // データが存在しない場合は空配列
    if (!data) return [];
    
    // resist/fall分岐がある場合（オブジェクトで、resistとfallのキーがある）
    if (typeof data === 'object' && !Array.isArray(data) && (data.resist || data.fall)) {
      // ランダムにresistかfallを選択
      const branch = Math.random() < 0.5 ? 'resist' : 'fall';
      data = data[branch] || [];
      console.log(`[IEH] Selected random branch: ${branch} for ${key}`);
    }
    
    // 配列として扱う
    const allPatterns = Array.isArray(data) ? data : [];
    if (!allPatterns.length) return [];
    
    // ランダムに1つだけ選択して、それを配列に入れて返す
    const randomIndex = Math.floor(Math.random() * allPatterns.length);
    const selectedPattern = allPatterns[randomIndex];
    console.log(`[IEH] Selected random pattern ${randomIndex + 1}/${allPatterns.length} for ${key}`);
    return [selectedPattern];
  };

  // 本番（初回 or 繰り返し）
  IEH.getInsertSequence = function (profileName, stageKey, corruptionStage, isFirstTime, keyOverride) {
    const p = window._insertDetailProfileCache?.[profileName];
    if (!p) return [];
    const key = keyOverride || (isFirstTime ? "sequence_first" : "sequence_repeat");
    let data = p?.[key]?.[stageKey]?.[corruptionStage];
    
    // データが存在しない場合は空配列
    if (!data) return [];
    
    // resist/fall分岐がある場合（オブジェクトで、resistとfallのキーがある）
    if (typeof data === 'object' && !Array.isArray(data) && (data.resist || data.fall)) {
      // この場合はkeyOverrideがすでにresist/fallを含んでいるはずなので、
      // ここではランダム選択しない（意図的な選択を尊重）
      console.warn(`[IEH] Unexpected resist/fall branch in ${key} - data structure may be incorrect`);
      data = [];
    }
    
    // 配列として扱う
    const allPatterns = Array.isArray(data) ? data : [];
    if (!allPatterns.length) return [];
    
    // ランダムに1つだけ選択して、それを配列に入れて返す
    const randomIndex = Math.floor(Math.random() * allPatterns.length);
    const selectedPattern = allPatterns[randomIndex];
    console.log(`[IEH] Selected random pattern ${randomIndex + 1}/${allPatterns.length} for ${key}`);
    return [selectedPattern];
  };

  // 二回目以降（repeat）／再接続（reconnect）取得（ランダムに1つだけ選択）
  IEH.getInsertRepeatSequence = function (profileName, stageKey, corruptionStage) {
    const p = window._insertDetailProfileCache?.[profileName];
    const allPatterns = p?.sequence_repeat?.[stageKey]?.[corruptionStage] || [];
    
    if (!Array.isArray(allPatterns) || !allPatterns.length) return [];
    
    const randomIndex = Math.floor(Math.random() * allPatterns.length);
    const selectedPattern = allPatterns[randomIndex];
    console.log(`[IEH] Selected random pattern ${randomIndex + 1}/${allPatterns.length} for sequence_repeat`);
    return [selectedPattern];
  };
  IEH.getInsertReconnectSequence = function (profileName, stageKey, corruptionStage) {
    const p = window._insertDetailProfileCache?.[profileName];
    const allPatterns = p?.sequence_reconnect?.[stageKey]?.[corruptionStage] || [];
    
    if (!Array.isArray(allPatterns) || !allPatterns.length) return [];
    
    const randomIndex = Math.floor(Math.random() * allPatterns.length);
    const selectedPattern = allPatterns[randomIndex];
    console.log(`[IEH] Selected random pattern ${randomIndex + 1}/${allPatterns.length} for sequence_reconnect`);
    return [selectedPattern];
  };

  /* ============================== 二回目用（repeat） ============================== */
  IEH._playInsertRepeat = async function (actor) {
    console.log("[IEH] ========== REPEAT FUNCTION CALLED ==========");
    // 同ターン連打の抑止
    if (actor._pleasure.insertRepeatShownThisTurn) {
      console.log("[InsertEventHandler] Repeat already shown this turn.");
      return;
    }
    console.log("[IEH] ★★★ Insert repeat starting - activating pink background ★★★");
    console.log("[IEH] PleasureDisplayManager exists?", !!window.PleasureDisplayManager);
    console.log("[IEH] startPinkBackground exists?", !!window.PleasureDisplayManager?.startPinkBackground);
    // ピンク背景を開始（二回目以降も継続表示）
    if (window.PleasureDisplayManager?.startPinkBackground) {
      console.log("[IEH] Calling startPinkBackground NOW (repeat)");
      window.PleasureDisplayManager.startPinkBackground();
      console.log("[IEH] startPinkBackground called successfully (repeat)");
    } else {
      console.error("[IEH] PleasureDisplayManager.startPinkBackground not found!");
    }

    try {
      const oc = actor?.getOrgasmCount?.() || 0;
      const stageKey = window.PleasurePoseController?.determinePleasureStage?.(oc) || "stage2";
      const corruptionStage = (typeof determineStageByCorruption === "function")
        ? (determineStageByCorruption(actor.getCorruption()) || "low")
        : "low";

      const profileName = PleasurePoseController.getProfileNameFromEnemy(actor);
      await IEH.loadInsertDetailProfile(profileName);

      // ① repeat 最優先 → ② reconnect → 無ければスキップ
      const seqRepeat    = IEH.getInsertRepeatSequence(profileName, stageKey, corruptionStage);
      const seqReconnect = IEH.getInsertReconnectSequence(profileName, stageKey, corruptionStage);
      const sequence = (seqRepeat?.length ? seqRepeat : (seqReconnect?.length ? seqReconnect : null));


      if (!sequence) {
        console.log("[InsertEventHandler] No repeat/reconnect sequence. Skip.");
        return;
      }

      // ここはテンポ重視で短尺扱い（phase:"pre"）
      await IEH.playSequence(actor, sequence, "pre");
      actor._pleasure.insertRepeatShownThisTurn = true;
    } finally {
      // ピンク背景を終了（早期リターン時も確実に）
      if (window.PleasureDisplayManager?.stopPinkBackground) {
        window.PleasureDisplayManager.stopPinkBackground();
      }
    }
  };

  /* ============================== 本体：導入→判定→本番 ============================== */
  IEH.handleInsertEvent = async function (actor) {
    console.log("[IEH] ========== FUNCTION CALLED ==========");
    if (!actor || !actor._pleasure) {
      console.log("[IEH] Early return: no actor or pleasure");
      return;
    }
    if (window._insertEventRunning) {
      console.log("[IEH] Early return: already running");
      return;
    }

    // 拘束中のみ
    if (!isRestrained(actor)) {
      console.log("[InsertEventHandler] Not restrained. Abort.");
      return;
    }

    // stage制限チェック（特殊モンスターは除外）
    const oc = actor?.getOrgasmCount?.() || 0; // 戦闘内絶頂回数を想定
    const guardStage = window.PleasurePoseController?.determinePleasureStage?.(oc) || "stage1";
    
    // ★ モンスター特性を確認（$gameTroop から取得）
    const enemies = $gameTroop ? $gameTroop.members() : null;
    const enemy = enemies?.[0];
    let allowStage1 = false;
    if (enemy && window.MonsterTraitManager) {
      const enemyKey = window.MonsterTraitManager.getEnemyKey(enemy.enemyId());
      if (enemyKey) {
        allowStage1 = window.MonsterTraitManager.allowsStage1Insert(enemyKey);
      }
    }
    
    if (guardStage === "stage1" && !allowStage1) {
      console.log("[InsertEventHandler] Blocked at stage1 (default behavior).");
      return;
    }
    
    console.log(`[InsertEventHandler] Proceeding at ${guardStage}${allowStage1 ? ' (trait system)' : ''}`);


    // ★ 既に「導入を見せて」かつ「挿入成立中」 → 二回目用へ
    if (actor._pleasure.inserted && actor._pleasure.insertedEventShown) {
      console.log("[IEH] Calling repeat insert");
      await IEH._playInsertRepeat(actor);
      return;
    }

    // 以降：初回導入
    window._insertEventRunning = true;
    console.log("[IEH] ★★★ Insert event starting - activating pink background ★★★");
    console.log("[IEH] PleasureDisplayManager exists?", !!window.PleasureDisplayManager);
    console.log("[IEH] startPinkBackground exists?", !!window.PleasureDisplayManager?.startPinkBackground);
    // ピンク背景を開始
    if (window.PleasureDisplayManager?.startPinkBackground) {
      console.log("[IEH] Calling startPinkBackground NOW");
      window.PleasureDisplayManager.startPinkBackground();
      console.log("[IEH] startPinkBackground called successfully");
    } else {
      console.error("[IEH] PleasureDisplayManager.startPinkBackground not found!");
    }
    try {
      const profileName = PleasurePoseController.getProfileNameFromEnemy(actor);
      const stageKey    = PleasurePoseController.determinePleasureStage(oc) || "stage2";
      const corruptionStage = (typeof determineStageByCorruption === "function")
        ? (determineStageByCorruption(actor.getCorruption()) || "low")
        : "low";
      const hasSeenIntro = !!actor._pleasure.hasSeenInsertIntro;
      const isFirstIntro = !hasSeenIntro; // ← pre_first を出すかの判定はこっち

      await IEH.loadInsertDetailProfile(profileName);
      const profile = window._insertDetailProfileCache?.[profileName];
      if (!profile) {
        console.warn("[InsertEventHandler] insert profile missing:", profileName);
        return;
      }

// ★ 未挿入だが導入は既視（前回は抵抗成功など）の場合、pre_repeat を軽く挟む
      if (!actor._pleasure.inserted && hasSeenIntro && !actor._pleasure.insertRepeatShownThisTurn) {
        const preRepeat = IEH.getInsertPreSequence(profileName, stageKey, corruptionStage, /*isFirstTime=*/false);
        if (preRepeat?.length) {
          await IEH.playSequence(actor, preRepeat, "pre");
          actor._pleasure.insertRepeatShownThisTurn = true; // 同ターン抑止
        }
      }

      // ★ 完全に初見のときだけ pre_first を出す（導入既視なら出さない）
      if (isFirstIntro) {
        const preFirst = IEH.getInsertPreSequence(profileName, stageKey, corruptionStage, /*isFirstTime=*/true);
        if (preFirst?.length) {
          await IEH.playSequence(actor, preFirst, "pre");
          // 成否に関係なく「導入は見せた」記録を立てる（抵抗成功でもON）
          actor._pleasure.hasSeenInsertIntro = true;
        }
      }

      // ❷ 選択肢
      const choice = await showChoiceAsyncCompat([
        { text: "抵抗する",       symbol: "resist" },
        { text: "抗うのをやめる", symbol: "fall"   },
      ]);

      // ❸ 抵抗ロール
        let sequenceKey;
        let insertedResult = true; // 既定：成立
        let isResistSuccess = false; // ★抵抗成功フラグ（スコープを広げる）

        if (choice === "resist") {
            // --- 成功率（0..1）の元値 ---
            const successRateDecimal = ResistanceCore.calcInsertResistRate(actor);

            // --- 表示用に％化（整数） ---
            const adjustedBase = ResistanceCore.getAdjustedInsertBasePercent(actor);
            const penaltyPct   = ResistanceCore.getInsertResistPenaltyPercent(actor);
            const corruptionPct    = Math.max(0, Math.min(100, Number(actor.getCorruption?.() ?? 0)));
            const clothingPct      = Math.max(0, Math.min(100, Number(actor.getClothingDurability?.() ?? 0)));
            const corrPercent      = Math.round(corruptionPct * ResistanceCore._const.CORRUPTION_MAX_PEN);
            const duraPercent      = Math.round(clothingPct   * ResistanceCore._const.DURABILITY_MAX_BON);
            const successRatePercent = Math.round(successRateDecimal * 100);

            // --- 出目と成否 ---
            const rolledD100       = Math.floor(Math.random() * 100) + 1;
            isResistSuccess  = (rolledD100 <= successRatePercent);

            // --- UI表示 ---
            await ResistanceRollMiniUI.showAsync({
              successRate: successRatePercent,
              rolled: rolledD100,
              success: isResistSuccess,
              actorName: actor.name?.() || "",
              checkLabel: "抵抗判定（挿入）",
              detailLines: [
                `基礎${adjustedBase}% − 屈服${corrPercent}% ＋ 衣装${duraPercent}% ＝ 合計${successRatePercent}%`
              ],
              maskBackground: true,
              diceFontSize: 28,
              seStart: "Cursor2",
              seStop: "Decision3",
              logToBattleLog: true
            });

            // --- 分岐と結果反映 ---
            if (isResistSuccess) {
              ResistanceCore.noteInsertResistSuccess(actor);
              sequenceKey = "sequence_resist_success";
              insertedResult = false; // 成立しない（＝挿入防止）
              
              // ★拘束解除処理（抵抗成功時）
              const RESTRAINT_STATE_IDS = [10, 11, 12, 13];
              RESTRAINT_STATE_IDS.forEach(stateId => {
                if (actor.isStateAffected(stateId)) {
                  actor.removeState(stateId);
                  console.log(`[IEH] Removed restraint state ${stateId} for resist success`);
                }
              });
              
              // 挿入状態もクリア
              if (actor._pleasure) {
                actor._pleasure.inserted = false;
                console.log(`[IEH] Cleared inserted state for resist success`);
              }
              
              // 抵抗成功: 矜持悪化+3（内部値が増える = 表示%が下がる、10回で最大値30）
              actor.addStoryGauge?.("courage", 3);
              console.log(`[IEH] Resist success: restraint released, returning to normal pose`);
            } else {
              sequenceKey = "sequence_resist_fail";
              // 抵抗失敗: 被虐度+3（8回で最大値24）、矜持悪化+3（10回で最大値30）
              actor.addStoryGauge?.("drift", 3);
              actor.addStoryGauge?.("courage", 3);
              console.log(`[IEH] Drift +3, Courage +3 (resist fail)`);
            }
            actor._resolveHistory = actor._resolveHistory || {};
            actor._resolveHistory[stageKey] = "resist";
          } else {
            // 受け入れ
            sequenceKey = "sequence_accept";
            actor._resolveHistory = actor._resolveHistory || {};
            actor._resolveHistory[stageKey] = "fall";
            // 受け入れ: 被虐度+3（8回で最大値24）、矜持悪化+3（10回で最大値30）
            actor.addStoryGauge?.("drift", 3);
            actor.addStoryGauge?.("courage", 3);
            console.log(`[IEH] Drift +3, Courage +3 (accept)`);
          }


      // ❹ 本番
      const sequence = IEH.getInsertSequence(profileName, stageKey, corruptionStage, /*isFirstTime=*/isFirstIntro, sequenceKey);
      if (!sequence?.length) {
        console.warn("[InsertEventHandler] No valid sequence found.");
        return;
      }
      
      // ★抵抗成功時は表情をembarrassedに固定
      const playOptions = {
        forceExpression: isResistSuccess ? "embarrassed" : null
      };
      await IEH.playSequence(actor, sequence, "main", insertedResult, playOptions);

      // ❺ 結果反映（★ 成立時のみ導入既視フラグを立てる）
      const penetrated = !!insertedResult;          // 受け入れ or 抵抗失敗 → true
      actor._pleasure.inserted = penetrated;
      actor._pleasure.insertedEventShown = penetrated;
      // 挿入成立時に永続カウントを増やす
      if (penetrated && typeof actor.incrementInsertCount === "function") {
        const beforeCount = actor.getTotalInsertCount?.() || 0;
        actor.incrementInsertCount();
        const afterCount = actor.getTotalInsertCount?.() || 0;
        
        // エロメモリー解放: 2. 初回挿入
        if (beforeCount === 0 && afterCount === 1 && window.EroMemory) {
          window.EroMemory.unlock("first_insert");
          console.log("[IEH] Memory unlocked: first_insert");
        }
        
        // エロメモリー解放: 4. 受け入れ選択
        if (choice === "accept" && window.EroMemory) {
          const hasAcceptedBefore = actor._hasAcceptedInsert || false;
          if (!hasAcceptedBefore) {
            window.EroMemory.unlock("first_accept");
            actor._hasAcceptedInsert = true;
            console.log("[IEH] Memory unlocked: first_accept");
          }
          
          // 7. 完全屈服（堕落度80以上で受け入れ）
          if (actor.getCorruption?.() >= 80) {
            window.EroMemory.unlock("full_submission");
            console.log("[IEH] Memory unlocked: full_submission");
          }
        }
        
        // 堕落度チェック
        actor.checkMemoryUnlock?.();
      }
// hasSeenInsertIntro は pre 再生時に既に true 済み（抵抗成功でも保持）

    } finally {
      console.log("[IEH] ★★★ Insert event ending - deactivating pink background ★★★");
      // ピンク背景を終了
      if (window.PleasureDisplayManager?.stopPinkBackground) {
        window.PleasureDisplayManager.stopPinkBackground();
      } else {
        console.error("[IEH] PleasureDisplayManager.stopPinkBackground not found!");
      }
      window._insertEventRunning = false; // 何があっても解除
    }
  };
})();
