// MapBustStandalone.js
// マップ用の常時立ち絵表示プラグイン（TRP_SkitMZと併用可能）
(() => {
    console.log("[MapBustStandalone] Loaded");

    class MapBustStandalone {
        constructor() {
            this._sprite = null;
            this._isVisible = false;
        }

        show(actor) {
            if (!SceneManager._scene || !(SceneManager._scene instanceof Scene_Map)) return;
            if (window.TRP_Skit && TRP_Skit.isPlaying()) return; // Skit中は表示しない

            if (this._sprite) {
                SceneManager._scene.removeChild(this._sprite);
            }

            this._sprite = new Sprite();
            SceneManager._scene.addChild(this._sprite);

            const clothingStage = actor.getClothingStage?.() || "intact";
            const clothingType = actor.getClothingType?.() || "uniform";
            const pose = `${clothingType}_${clothingStage}`;
            const profileName = "map";

            const filename = `busts/${profileName}/${pose}_base`;
            const bitmap = ImageManager.loadPictureSafe(filename);

            const baseSprite = new Sprite(bitmap);
            // 基準点を「右下」に
            baseSprite.anchor.set(1, 1);
            // 画面の右下に配置
            baseSprite.x = Graphics.width;
            baseSprite.y = Graphics.height;
            this._sprite.addChild(baseSprite);

            this._isVisible = true;

            console.log(`[MapBustStandalone] Displayed: ${filename}`);
        }

        clear() {
            if (this._sprite) {
                SceneManager._scene.removeChild(this._sprite);
                this._sprite = null;
                this._isVisible = false;
                console.log("[MapBustStandalone] Cleared");
            }
        }

        refresh(actor) {
            if (this._isVisible) {
                this.show(actor);
            }
        }
    }

    window.MapBustStandalone = new MapBustStandalone();
})();
