/*:
 * @target MZ
 * @plugindesc One-shot horizontal sway for bust/actor on specific triggers.
 * @help 呼び出し: OneShotSway.play(actor, { amplitude: 10, duration: 18, cycles: 2 })
 */
(() => {
  console.log("[OneShotSway] loaded");

  function getBustGroup(actor) {
    return window.BattleBustManager?._sprites?.[actor.actorId()] || null;
  }

  function rafLoop(fn) {
    let id = 0;
    const tick = () => { fn() && (id = requestAnimationFrame(tick)); };
    id = requestAnimationFrame(tick);
    return () => cancelAnimationFrame(id);
  }

  function swaySprite(sprite, amplitude = 10, duration = 18, cycles = 2) {
    if (!sprite) return;
    const baseX = sprite.x;
    let frame = 0;
    const done = rafLoop(() => {
      frame++;
      const t = frame / duration;
      const rad = t * Math.PI * 2 * cycles;
      sprite.x = baseX + Math.sin(rad) * amplitude;
      if (frame >= duration) {
        sprite.x = baseX; // 後始末
        return false;     // stop
      }
      return true;        // continue
    });
  }

  function swayActorFallback(amplitude = 5, duration = 10) {
    // 立ち絵が見つからない場合の緊急退避（画面シェイクで軽く代用）
    const power = Math.max(1, Math.min(9, Math.round(amplitude / 2)));
    const speed = 4;
    $gameScreen.startShake(power, speed, duration);
  }

  window.OneShotSway = {
    /**
     * 横揺れを一度だけ再生
     * @param {Game_Actor} actor
     * @param {{amplitude?:number, duration?:number, cycles?:number}} opt
     */
    play(actor, opt = {}) {
      const { amplitude = 10, duration = 18, cycles = 2 } = opt;
      const group = actor && getBustGroup(actor);
      if (group) {
        swaySprite(group, amplitude, duration, cycles);
      } else {
        swayActorFallback(amplitude, duration);
      }
    }
  };
})();
