// OrgasmEventHandler.js（置き換え版・drop-in：underOverlays対応＋PDM一本化）
(() => {
  const FILE_VERSION = "2024-11-15-v2-PINK-BG";
  console.log(`[OrgasmEventHandler] Loaded - VERSION: ${FILE_VERSION}`);

  // 名前空間
  window.OrgasmEventHandler = window.OrgasmEventHandler || {};
  const OEH = window.OrgasmEventHandler;

  // ====================== ユーティリティ ======================
  function normalizeSteps(raw) {
    if (!raw) return [];
    if (Array.isArray(raw)) {
      return raw.map(s => {
        if (typeof s === "string") return { dialogue: s };
        if (s && typeof s === "object") {
          const dialogue = s.dialogue ?? s.text ?? "";
          return { ...s, dialogue };
        }
        return {};
      });
    }
    if (typeof raw === "object" && Array.isArray(raw.dialogueSequence)) {
      return normalizeSteps(raw.dialogueSequence);
    }
    if (typeof raw === "string") return [{ dialogue: raw }];
    return [];
  }

  const normalizeKey = k => (typeof k === "string" ? k.replace(/^p(\d+):/, "p$1_") : k);
  const resolveOverlayArray = (arr) => {
    const src = Array.isArray(arr) ? arr : [];
    const res = window.OverlayResolver?.resolveOverlays ? window.OverlayResolver.resolveOverlays(src) : src;
    return (res || []).map(normalizeKey);
  };

  // メッセージ閉じ待ちの安全版（既存があればそれを使う）
  async function waitMessageWindowSafe() {
    if (typeof window.waitMessageWindow === "function") {
      return window.waitMessageWindow();
    }
    // フォールバック：$gameMessageが閉じるまでポーリング
    await new Promise(res => {
      const h = setInterval(() => {
        try {
          if (!$gameMessage.isBusy()) { clearInterval(h); res(); }
        } catch (_) { clearInterval(h); res(); }
      }, 10);
    });
  }

  // ====================== JSON ロード/取得 ======================
  OEH.loadOrgasmDetailProfile = async function(profileName) {
    if (!window._orgasmDetailProfileCache) window._orgasmDetailProfileCache = {};
    if (window._orgasmDetailProfileCache[profileName]) return;

    try {
      const res = await fetch(`dataEx/orgasmDetailProfiles/${profileName}.json`);
      if (!res.ok) throw new Error("HTTP " + res.status);
      window._orgasmDetailProfileCache[profileName] = await res.json();
      console.log(`[OrgasmDetailProfile] Loaded for ${profileName}`);
    } catch (e) {
      console.warn(`[OrgasmDetailProfile] Failed to load for ${profileName}`, e);
      window._orgasmDetailProfileCache[profileName] = {}; // 空でも作る
    }
  };

  // 常に配列（or 空配列）を返す
  // resolveTone: "resist" | "fall" | null
  // ★拡張: resist/fall分岐をサポート（後方互換性あり）
  OEH.getOrgasmDetailSequence = function(profileName, sequenceKey, stageKey, corruptionStage, resolveTone = null) {
    const data = window._orgasmDetailProfileCache?.[profileName];
    let node = data?.[sequenceKey]?.[stageKey]?.[corruptionStage];
    
    // resist/fall分岐のサポート
    if (node && typeof node === 'object' && !Array.isArray(node)) {
      // 新形式: { resist: [...], fall: [...] }
      if (resolveTone && node[resolveTone]) {
        node = node[resolveTone];
        console.log(`[OEH] Using ${sequenceKey}.${stageKey}.${corruptionStage}.${resolveTone}`);
      } else {
        // resolveTone未指定、またはキーが存在しない場合のフォールバック
        // resist優先、なければfall、それもなければ空配列
        node = node.resist || node.fall || [];
        console.log(`[OEH] Fallback: Using ${sequenceKey}.${stageKey}.${corruptionStage}.${node === (node.resist || node.fall) ? 'resist or fall' : 'default'}`);
      }
    }
    // 旧形式: [...] の場合はそのまま返す
    
    return node ?? [];
  };

  // ====================== 結果反映 ======================
  OEH.applyOrgasmResult = function(actor) {
    const beforeCount = actor.getOrgasmCount?.() || 0;
    const beforeBattleCount = actor._pleasure?.battleOrgasmCount || 0;
    
    actor.incrementOrgasmCount?.();
    if (actor._pleasure) {
      actor._pleasure.recTurns = 2;
      actor._pleasure.orgasmed = true;
    }
    actor.gainCorruption?.(5);
    
    const afterCount = actor.getOrgasmCount?.() || 0;
    const afterBattleCount = actor._pleasure?.battleOrgasmCount || 0;
    
    // エロメモリー解放: 3. 初回絶頂
    if (beforeCount === 0 && afterCount === 1 && window.EroMemory) {
      window.EroMemory.unlock("first_orgasm");
      console.log("[OEH] Memory unlocked: first_orgasm");
    }
    
    // エロメモリー解放: 5. 挿入中の絶頂
    if (actor._pleasure?.inserted && window.EroMemory) {
      window.EroMemory.unlock("insert_orgasm");
      console.log("[OEH] Memory unlocked: insert_orgasm");
    }
    
    // 堕落度チェック
    actor.checkMemoryUnlock?.();
    
    console.log(`[OrgasmEventHandler] Orgasm result applied to ${actor.name?.() || "actor"}`);
  };

  // ====================== メイン：絶頂選択＆演出 ======================
  OEH.handleOrgasmResolveEvent = async function(actor) {
    console.log("[OEH] ========== FUNCTION CALLED ==========");
    if (!actor || !actor._pleasure) {
      console.log("[OEH] Early return: no actor or pleasure");
      return;
    }
    console.log(`[OEH] handleOrgasmResolveEvent called for ${actor.name?.() || "actor"}`);

    window._orgasmEventRunning = true; // 抑止ON
    console.log("[OEH] ★★★ Orgasm event starting - activating pink background ★★★");
    console.log("[OEH] PleasureDisplayManager exists?", !!window.PleasureDisplayManager);
    console.log("[OEH] startPinkBackground exists?", !!window.PleasureDisplayManager?.startPinkBackground);
    // ピンク背景を開始
    if (window.PleasureDisplayManager?.startPinkBackground) {
      console.log("[OEH] Calling startPinkBackground NOW");
      window.PleasureDisplayManager.startPinkBackground();
      console.log("[OEH] startPinkBackground called successfully");
    } else {
      console.error("[OEH] PleasureDisplayManager.startPinkBackground not found!");
    }
    try {
      const profileName = window.PleasurePoseController?.getProfileNameFromEnemy?.(actor) || "default";
      const stageKey = window.PleasurePoseController?.determinePleasureStage?.(actor.getOrgasmCount?.() || 0) || "stage2";
      const corruptionStage = (typeof window.determineStageByCorruption === "function")
        ? window.determineStageByCorruption(actor.getCorruption?.() || 0) : "low";
      console.log(`[OEH] stageKey: ${stageKey}, corruptionStage: ${corruptionStage}`);

      const skill = BattleManager._action?.item?.();
      const targetPart = skill?.meta?.TargetPart || "pussy";

      await OEH.loadOrgasmDetailProfile(profileName);
      const detailProfile = window._orgasmDetailProfileCache?.[profileName];
      if (!detailProfile) {
        console.warn(`[OEH] Detail profile missing for ${profileName}`);
        window._orgasmEventRunning = false;
        return;
      }

      // ---- 事前シーケンス（sequence） ----
      // ★sequenceの段階では選択前なので、前回の履歴または現在のresolveToneを参照
      const currentResolveTone = actor._pleasure?.resolveTone || null;
      const rawSeq = OEH.getOrgasmDetailSequence(profileName, "sequence", stageKey, corruptionStage, currentResolveTone);
      let sequence = normalizeSteps(rawSeq);
      console.log(`[OEH] Loaded sequence:`, sequence);

      // ★ VisualAutoFill で sequence 全体を自動補完
      if (sequence && sequence.length > 0 && window.VisualAutoFill) {
        const profile = window._poseProfileCache?.[profileName];
        const autoFillContext = {
          profileName: profileName,
          profile: profile || {},
          stage: stageKey,
          eventType: "orgasm",
          phase: "main",
          targetPart: targetPart,
          enemyKey: profile?.meta?.enemyKey || profileName.split("_")[0],
          isInserted: profile?.meta?.state?.includes("inserted") || /insert/i.test(profileName),
          isRestrained: window.PleasureStateManager?.isActorRestrained?.(actor) || false
        };
        sequence = window.VisualAutoFill.autoFillDialogueSequence(sequence, autoFillContext);
        console.log(`[OEH] Auto-filled orgasm sequence with ${sequence.length} steps`);
      }

      // 行間継続ロジック（over/under を指定がない限り継続）
      let currentOver = null;
      let currentUnder = null;

      for (const step of sequence) {
        const displayInfo = await window.PleasurePoseController.getDisplayInfo(actor, "orgasm", targetPart, true);

        // 表情・ポーズ・台詞
        displayInfo.expression = step.expression ?? displayInfo.expression;
        displayInfo.pose = step.pose ?? "auto";
        displayInfo.dialogue   = step.dialogue   ?? "";

        // overlays
        if (step.overlays !== undefined) {
          currentOver = resolveOverlayArray(step.overlays);
        } else if (currentOver === null) {
          currentOver = resolveOverlayArray(displayInfo.overlays);
        }
        displayInfo.overlays = currentOver ?? [];

        // underOverlays
        if ("underOverlays" in step) {
          currentUnder = resolveOverlayArray(step.underOverlays);
        } else if (currentUnder === null) {
          currentUnder = resolveOverlayArray(displayInfo.underOverlays);
        }
        displayInfo.underOverlays = currentUnder ?? [];

        // SEの継承（dialogueSequence未使用なので dialogueFx 経由）
        if (displayInfo.se && !displayInfo.dialogueSequence) {
          displayInfo.dialogueFx = { ...(displayInfo.dialogueFx || {}), se: displayInfo.dialogueFx?.se ?? displayInfo.se };
        }

        // ★FXの設定（step.fx があれば dialogueFx に設定）
        if (step.fx) {
          displayInfo.dialogueFx = { ...(displayInfo.dialogueFx || {}), ...step.fx };
          console.log(`[OEH] Applied FX from step:`, step.fx);
        }

        // 描画はPDM一本化
        if (window.PleasureDisplayManager?.show) await window.PleasureDisplayManager.show(actor, displayInfo);

        if (step.log && window.BattleLogManager?.push) window.BattleLogManager.push(step.log);
        await waitMessageWindowSafe();
      }

      // ---- 選択肢 ----
      const choices = detailProfile?.choices?.[stageKey]?.[corruptionStage] || ["まだ…負けない…！", "もう…だめ…"];
      SceneManager._scene.showResolveChoiceWindow(choices, async (index) => {
        try {
          const resolveTone = index === 0 ? "resist" : "fall";
          actor._resolveHistory = actor._resolveHistory || {};
          actor._resolveHistory[stageKey] = resolveTone;
          
          // ★次回のsequence用にactor._pleasureにも保存
          if (actor._pleasure) {
            actor._pleasure.resolveTone = resolveTone;
          }

          // 被虐度・矜持ゲージの増減
          if (resolveTone === "resist") {
            // 抵抗選択: 矜持悪化+3（内部値が増える = 表示%が下がる、10回で最大値30）
            actor.addStoryGauge?.("courage", 3);
            console.log(`[OEH] Courage +3 (resist choice)`);
            
            // ★stage3では抵抗してもハイライト消失
            if (stageKey === "stage3" && !actor.hasLostHighlight?.()) {
              actor.loseHighlight?.();
            }
          } else if (resolveTone === "fall") {
            // 受け入れ選択: 被虐度+3（8回で最大値24）、矜持悪化+3（10回で最大値30）
            actor.addStoryGauge?.("drift", 3);
            actor.addStoryGauge?.("courage", 3);
            console.log(`[OEH] Drift +3, Courage +3 (fall choice)`);
            
            // ★fall選択時は常にハイライト消失
            if (!actor.hasLostHighlight?.()) {
              actor.loseHighlight?.();
            }
          }

          const afterSequenceKey = resolveTone === "resist" ? "after_resist" : "after_fall";
          // ★resolveToneを渡す（将来的なさらなる分岐に備えて）
          const afterRaw = OEH.getOrgasmDetailSequence(profileName, afterSequenceKey, stageKey, corruptionStage, resolveTone);
          let afterSequence = normalizeSteps(afterRaw);

          // ★ VisualAutoFill で after_resist/after_fall も自動補完
          if (afterSequence && afterSequence.length > 0 && window.VisualAutoFill) {
            const profile = window._poseProfileCache?.[profileName];
            const autoFillContext = {
              profileName: profileName,
              profile: profile || {},
              stage: stageKey,
              eventType: "orgasm",
              phase: afterSequenceKey,
              targetPart: targetPart,
              enemyKey: profile?.meta?.enemyKey || profileName.split("_")[0],
              isInserted: profile?.meta?.state?.includes("inserted") || /insert/i.test(profileName),
              isRestrained: window.PleasureStateManager?.isActorRestrained?.(actor) || false
            };
            afterSequence = window.VisualAutoFill.autoFillDialogueSequence(afterSequence, autoFillContext);
            console.log(`[OEH] Auto-filled ${afterSequenceKey} sequence with ${afterSequence.length} steps`);
          }

          // 行間継続（after側は独立に初期化）
          let currentOverA = null;
          let currentUnderA = null;

          for (const step of afterSequence) {
            const displayInfo = await window.PleasurePoseController.getDisplayInfo(actor, "orgasm", targetPart, true);

            displayInfo.expression = step.expression ?? displayInfo.expression;
            displayInfo.pose       = step.pose       ?? displayInfo.pose;
            displayInfo.dialogue   = step.dialogue   ?? "";

            // overlays
            if (step.overlays !== undefined) {
              currentOverA = resolveOverlayArray(step.overlays);
            } else if (currentOverA === null) {
              currentOverA = resolveOverlayArray(displayInfo.overlays);
            }
            displayInfo.overlays = currentOverA ?? [];

            // underOverlays
            if ("underOverlays" in step) {
              currentUnderA = resolveOverlayArray(step.underOverlays);
            } else if (currentUnderA === null) {
              currentUnderA = resolveOverlayArray(displayInfo.underOverlays);
            }
            displayInfo.underOverlays = currentUnderA ?? [];

            // SEの継承
            if (displayInfo.se && !displayInfo.dialogueSequence) {
              displayInfo.dialogueFx = { ...(displayInfo.dialogueFx || {}), se: displayInfo.dialogueFx?.se ?? displayInfo.se };
            }

            // ★FXの設定（step.fx があれば dialogueFx に設定）
            if (step.fx) {
              displayInfo.dialogueFx = { ...(displayInfo.dialogueFx || {}), ...step.fx };
              console.log(`[OEH] Applied FX from step (${afterSequenceKey}):`, step.fx);
            }

            if (window.PleasureDisplayManager?.show) await window.PleasureDisplayManager.show(actor, displayInfo);
            if (step.log && window.BattleLogManager?.push) window.BattleLogManager.push(step.log);

            await waitMessageWindowSafe();
          }

          // 結果反映＋行動不能ステ
          OEH.applyOrgasmResult(actor);
          const DOWN_STATE_ID = 15;
          actor.addState?.(DOWN_STATE_ID);
          console.log(`[OEH] DOWN state added to ${actor.name?.() || "actor"}`);
        } finally {
          console.log("[OEH] ★★★ Orgasm event ending - deactivating pink background ★★★");
          // ピンク背景を終了
          if (window.PleasureDisplayManager?.stopPinkBackground) {
            window.PleasureDisplayManager.stopPinkBackground();
          } else {
            console.error("[OEH] PleasureDisplayManager.stopPinkBackground not found!");
          }
          // 演出完了後に解除
          window._orgasmEventRunning = false;
        }
      });

    } catch (e) {
      console.warn("[OEH] error:", e);
      console.log("[OEH] ★★★ Orgasm event error - deactivating pink background ★★★");
      // ピンク背景を終了（例外時も確実に）
      if (window.PleasureDisplayManager?.stopPinkBackground) {
        window.PleasureDisplayManager.stopPinkBackground();
      } else {
        console.error("[OEH] PleasureDisplayManager.stopPinkBackground not found!");
      }
      window._orgasmEventRunning = false; // 例外時も確実に解除
      throw e;
    }
  };

})();
