(() => {
  console.log("[OverlayResolver] Loaded");

  function expandPresetPath(path, sets) {
    // "insert.strong" → sets.insert.strong を返す（配列のみサポート）
    const parts = String(path).split(".");
    let node = sets;
    for (const p of parts) {
      if (!node || typeof node !== "object" || !(p in node)) return null;
      node = node[p];
    }
    return Array.isArray(node) ? node : null;
  }

  function resolveOverlays(keyOrArray) {
    const sets = window.OverlaySets || {};
    const result = [];

    // 重複排除（後勝ち：既にあるものを一度抜いて末尾に入れ直す）
    const pushUnique = (overlayId) => {
      if (typeof overlayId !== "string" || !overlayId) return;
      const idx = result.indexOf(overlayId);
      if (idx >= 0) result.splice(idx, 1);
      result.push(overlayId);
    };

    const mergeOne = (item) => {
      if (Array.isArray(item)) {
        item.forEach(mergeOne);
        return;
      }
      if (typeof item !== "string") return;

      // "react.basic + insert.strong" のような合成表記に対応
      const parts = item.split(/\s*\+\s*/);
      if (parts.length > 1) {
        parts.forEach(mergeOne);
        return;
      }

      // プリセット（dot-path）か、生IDかを判定
      const expanded = expandPresetPath(item, sets);
      if (expanded) {
        expanded.forEach(pushUnique);
      } else {
        // 生オーバーレイIDとして扱う
        pushUnique(item);
      }
    };

    if (Array.isArray(keyOrArray)) {
      keyOrArray.forEach(mergeOne);
    } else if (keyOrArray) {
      mergeOne(keyOrArray);
    }

    return result;
  }

  window.OverlayResolver = { resolveOverlays };

  // 敵ごとの overlaySets をロード（廃止: VisualOverlayData.js で静的定義に変更）
  window.loadOverlaySetsForEnemy = async function(enemyKey) {
    console.log("[OverlayResolver] Skipping dynamic load. Using VisualOverlayData.js.");
    // 何もしない（既存の window.OverlaySets を維持）
  };

  // 戦闘開始時にロード
  const _BattleManager_setup = BattleManager.setup;
  BattleManager.setup = function(troopId, canEscape, canLose) {
    _BattleManager_setup.call(this, troopId, canEscape, canLose);
    const enemy = $gameTroop.members().find(e => e && e.isAlive());
    if (enemy) {
      const enemyKey = window.PleasurePoseController?.getProfileNameFromEnemy?.(enemy) || "default";
      window.loadOverlaySetsForEnemy(enemyKey);
    }
  };
})();
