// PleasureActorStatus.js (battle-orgasm + total-orgasm, safe init, no dup)
(() => {
  console.log("[PleasureActorStatus] Enhanced version loaded");

  /* ========== 初期化 ========== */
  Game_Actor.prototype.initPleasureStatus = function() {
    // 永続系
    if (this._developPussy    == null) this._developPussy    = 0;
    if (this._developBreasts  == null) this._developBreasts  = 0;
    if (this._developAss      == null) this._developAss      = 0;
    if (this._developMouth    == null) this._developMouth    = 0;   // ← 追加
    if (this._aroused         == null) this._aroused         = false;
    if (this._corruption      == null) this._corruption      = 0;
    if (this._clothingDurability == null) this._clothingDurability = 100;

    // 作業用ハブ（互換）
    this._pleasure = this._pleasure || {
      battleOrgasmCount: 0,
      inserted: false,
      recTurns: 0,
      orgasmed: false,
      corruption: this._corruption,
      highlightLost: false  // ★ハイライト消失フラグ（戦闘中のみ有効）
    };

    // 永続バッドステータス
    this.initPersistentBadStatus();

    // 永続統計
    this._stats = this._stats || { totalOrgasmCount: 0, totalInsertCount: 0 };

    // StoryGauges の器だけ保証（値は別APIで更新）
    if (!this._storyGauges) this._storyGauges = { courage:0, bond:0, drift:0, arousal:0 };

    console.log("[PAS] Pleasure status initialized for actor:", this.name());
  };

  /* ========== 俳優生成時にも初期化（堅牢化） ========== */
  const _Game_Actor_setup = Game_Actor.prototype.setup;
  Game_Actor.prototype.setup = function(actorId) {
    _Game_Actor_setup.call(this, actorId);
    try { this.initPleasureStatus(); } catch(e){ console.warn(e); }
  };

  /* ========== 永続バッドステータス ========== */
  Game_Actor.prototype.initPersistentBadStatus = function() {
    if (!this._persistentBadStatus) {
      this._persistentBadStatus = {
        slimeAdhesion: false,
        masochism: false,
        drugAddiction: false
      };
    }
  };
  Game_Actor.prototype.hasPersistentBadStatus   = function(key){ return !!this._persistentBadStatus?.[key]; };
  Game_Actor.prototype.setPersistentBadStatus   = function(key, v=true){ this.initPersistentBadStatus(); this._persistentBadStatus[key]=!!v; console.log(`[PAS] Persistent bad status set: ${key}=${!!v}`); };
  Game_Actor.prototype.clearPersistentBadStatus = function(key){ if (!this._persistentBadStatus) return; this._persistentBadStatus[key]=false; console.log(`[PAS] Persistent bad status cleared: ${key}`); };

  /* ========== 開発度（唯一の更新口） ========== */
  Game_Actor.prototype.gainDevelopment = function(part, amount) {
    const norm = String(part||"").toLowerCase();
    const key  = norm === "pussy"   ? "_developPussy"
               : norm === "breasts" ? "_developBreasts"
               : norm === "ass"     ? "_developAss"
               : norm === "mouth"   ? "_developMouth"
               : null;
    if (!key) return console.warn(`[PAS] Unknown part "${part}" for gainDevelopment`);

    if (this[key] == null) this[key] = 0;
    const delta = Number(amount|0);
    this[key] = Math.min(100, Math.max(0, this[key] + delta));
    console.log(`[PAS] Development gained: ${norm} +${delta}, Total: ${this[key]}`);

    // 任意: 戦闘ログ
    if ($gameParty.inBattle() && window.BattleLogManager?.push) {
      const label = norm === "pussy" ? "局部" : norm === "breasts" ? "乳房" : norm === "ass" ? "尻" : "口";
      BattleLogManager.push(`${this.name()}の${label}が敏感になった！（開発度＋${delta}）`);
    }

    // ←←← ここで通知（関数外に出さないこと！）
    try {
      window.EroStatus?.Store?.publishDevelopmentChanged?.({
        actorId: this.actorId(),
        bodyPart: norm,
        value: this.getDevelopment(norm),
        delta,
        source: "Game_Actor.gainDevelopment"
      });
    } catch(e){ console.warn(e); }
  };

  // 安全な getter（UI・Store 参照用）
  Game_Actor.prototype.getDevelopment = function(part){
    const norm = String(part||"").toLowerCase();
    return norm === "pussy"   ? (this._developPussy   || 0)
         : norm === "breasts" ? (this._developBreasts || 0)
         : norm === "ass"     ? (this._developAss     || 0)
         : norm === "mouth"   ? (this._developMouth   || 0)
         : 0;
  };

  Game_Actor.prototype.getDevelopmentStage = function(part){
    const val = this.getDevelopment(part);
    if (val >= 80) return "high";
    if (val >= 40) return "mid";
    return "low";
  };

  /* ========== 屈服（Corruption） ========== */
  Game_Actor.prototype.getCorruption = function(){ return this._corruption|0; };
  Game_Actor.prototype.setCorruption = function(v){
    const oldCorruption = this._corruption|0;
    this._corruption = Math.max(0, Math.min(100, v|0));
    if (this._pleasure) this._pleasure.corruption = this._corruption; // 互換
    
    // 堕落度の増加に応じて矜持も自動的に悪化（内部値が増える = 悪化）
    const corruptionIncrease = this._corruption - oldCorruption;
    if (corruptionIncrease > 0) {
      // 堕落度が10増加するごとに矜持が3増加（内部値が3増える = 表示パーセンテージが10%下がる）
      const courageIncrease = Math.floor(corruptionIncrease / 10) * 3;
      if (courageIncrease > 0 && typeof this.addStoryGauge === "function") {
        this.addStoryGauge("courage", courageIncrease);
        console.log(`[PAS] Courage auto-decreased by corruption: +${courageIncrease} (corruption +${corruptionIncrease})`);
      }
    }
    
    console.log(`[PAS] Corruption set: ${this._corruption}`);
    try { window.EroStatus?.Store?.publishCorruptionChanged?.({ actorId: this.actorId(), value: this._corruption, source: "Game_Actor.setCorruption" }); } catch(e){ console.warn(e); }
  };
  Game_Actor.prototype.gainCorruption = function(a){
    this.setCorruption(this.getCorruption() + (a|0));
    console.log(`[PAS] Corruption gained: +${a}, Total: ${this._corruption}`);
  };

  /* ========== 衣装耐久 ========== */
  Game_Actor.prototype.getClothingDurability = function(){
    if (this._clothingDurability == null) this._clothingDurability = 100;
    return this._clothingDurability;
  };
  Game_Actor.prototype.setClothingDurability = function(v){
    this._clothingDurability = Math.max(0, Math.min(100, v|0));
    console.log(`[PAS] Clothing durability set: ${this._clothingDurability}`);
  };
  Game_Actor.prototype.damageClothing = function(a){
    this.setClothingDurability(this.getClothingDurability() - (a|0));
    console.log(`[PAS] Clothing damaged: -${a}, Remaining: ${this._clothingDurability}`);
  };
  Game_Actor.prototype.getClothingStage = function(){
    const d = this.getClothingDurability();
    if (d >= 50) return "intact";
    if (d >  0)  return "damaged";
    return "destroyed";
  };
  Game_Actor.prototype.repairClothing = function(amount){
    this.setClothingDurability(this.getClothingDurability() + (amount|0));
    console.log(`[PAS] Clothing repaired: +${amount}, Current: ${this._clothingDurability}`);
  };
  Game_Actor.prototype.restoreClothingFully = function(){
    this.setClothingDurability(100);
    console.log(`[PAS] Clothing fully restored to 100`);
  };

  /* ========== 絶頂カウント（戦闘内＋永続） ========== */
  Game_Actor.prototype.getBattleOrgasmCount = function(){ return (this._pleasure?.battleOrgasmCount | 0); };
  Game_Actor.prototype.getTotalOrgasmCount  = function(){ return (this._stats?.totalOrgasmCount | 0); };
  Game_Actor.prototype.getOrgasmCount       = function(){ return this.getBattleOrgasmCount(); }; // 互換

  Game_Actor.prototype.incrementOrgasmCount = function(){
    this._pleasure = this._pleasure || {};
    this._pleasure.battleOrgasmCount = (this._pleasure.battleOrgasmCount|0) + 1;
    this._stats = this._stats || {};
    this._stats.totalOrgasmCount = (this._stats.totalOrgasmCount|0) + 1;
  };

  Game_Actor.prototype.resetBattleOrgasmCount = function(){
    this._pleasure = this._pleasure || {};
    this._pleasure.battleOrgasmCount = 0;
  };

  /* ========== 挿入カウント（永続） ========== */
  Game_Actor.prototype.getTotalInsertCount = function(){ return (this._stats?.totalInsertCount | 0); };

  Game_Actor.prototype.incrementInsertCount = function(){
    this._stats = this._stats || {};
    this._stats.totalInsertCount = (this._stats.totalInsertCount|0) + 1;
    console.log(`[PAS] Insert count incremented: ${this._stats.totalInsertCount}`);
  };

  /* ========== StoryGauges（0..3、矜持0..30、被虐度0..24） ========== */
  function clampStage03(v){ return Math.max(0, Math.min(3, (v|0))); }
  function clampStage24(v){ return Math.max(0, Math.min(24, (v|0))); } // 被虐度用：8回で最大値
  function clampStage30(v){ return Math.max(0, Math.min(30, (v|0))); } // 矜持用：10回で最大値

  Game_Actor.prototype._ensureStoryGauges = function(){
    if (!this._storyGauges) this._storyGauges = { courage:0, bond:0, drift:0, arousal:0 };
    return this._storyGauges;
  };
  Game_Actor.prototype.getStoryGauges = function(){
    const g = this._ensureStoryGauges();
    return { courage:g.courage, bond:g.bond, drift:g.drift, arousal:g.arousal };
  };
  Game_Actor.prototype.setStoryGauges = function(values){
    const g = this._ensureStoryGauges();
    g.courage = clampStage30(values?.courage ?? g.courage); // 矜持は0〜30
    g.bond    = clampStage03(values?.bond    ?? g.bond);
    g.drift   = clampStage24(values?.drift   ?? g.drift); // 被虐度は0〜24
    g.arousal = clampStage03(values?.arousal ?? g.arousal);
    try {
      window.EroStatus?.Store?.publishStoryGaugesChanged?.({
        actorId: this.actorId(),
        values: this.getStoryGauges(),
        source: "Game_Actor.setStoryGauges"
      });
    } catch(e){ console.warn(e); }
    return this.getStoryGauges();
  };
  Game_Actor.prototype.addStoryGauge = function(gaugeKey, amount = 1){
    const g = this._ensureStoryGauges();
    const key = String(gaugeKey);
    if (!["courage","bond","drift","arousal"].includes(key)) return g;
    // 矜持は0〜30、被虐度は0〜24の範囲、それ以外は0〜3
    if (key === "courage") {
      g[key] = clampStage30((g[key] ?? 0) + (amount|0));
    } else if (key === "drift") {
      g[key] = clampStage24((g[key] ?? 0) + (amount|0));
    } else {
      g[key] = clampStage03((g[key] ?? 0) + (amount|0));
    }
    try {
      window.EroStatus?.Store?.publishStoryGaugesChanged?.({
        actorId: this.actorId(),
        values: this.getStoryGauges(),
        source: "Game_Actor.addStoryGauge"
      });
    } catch(e){ console.warn(e); }
    return this.getStoryGauges();
  };
  Game_Actor.prototype.getTopStoryGaugeKey = function(){
    const order = ["courage","bond","drift","arousal"];
    const g = this._ensureStoryGauges();
    return order.slice().sort((a,b)=> (g[b]-g[a]) || (order.indexOf(a)-order.indexOf(b)))[0];
  };

  /* ========== 戦闘境界での初期化 ========== */
  const _Game_Actor_onBattleStart = Game_Actor.prototype.onBattleStart;
  Game_Actor.prototype.onBattleStart = function() {
    _Game_Actor_onBattleStart.call(this);
    this.initPleasureStatus();
    this.resetBattleOrgasmCount();
    
    // ★戦闘開始時に戦闘限定フラグを強制リセット
    if (this._pleasure) {
      this._pleasure.highlightLost = false;
      this._pleasure.restraintCount = 0;  // 拘束回数をリセット
      this._pleasure.inserted = false;
      this._pleasure.insertedEventShown = false;
    }
    
    for (const [k,v] of Object.entries(this._persistentBadStatus||{})) {
      if (v) console.log(`[PAS] ${k} is active at battle start for actor:`, this.name());
    }
    console.log(`[PAS] Corruption at battle start: ${this.getCorruption()}`);
    console.log(`[PAS] Development at battle start: P=${this._developPussy}, B=${this._developBreasts}, A=${this._developAss}, M=${this._developMouth}`);
  };

  const _BattleManager_endBattle = BattleManager.endBattle;
  BattleManager.endBattle = function(result){
    try { 
      $gameParty?.members().forEach(a => {
        // 戦闘内絶頂回数のリセット
        a?.resetBattleOrgasmCount();
        
        // 戦闘限定フラグのクリア
        if (a && a._pleasure) {
          a._pleasure.inserted = false;
          a._pleasure.insertedEventShown = false;
          a._pleasure.highlightLost = false;
          a._pleasure.restraintCount = 0;  // ★追加：拘束回数のリセット
          console.log(`[PAS] Cleared battle-only states for ${a.name()} at battle end`);
        }
      });
    } catch(_) {}
    _BattleManager_endBattle.call(this, result);
  };

  /* ========== 拘束履歴の記録（エロメモリー用） ========== */
  Game_Actor.prototype.recordRestraint = function(enemyType) {
    this._restraintHistory = this._restraintHistory || {};
    if (!this._restraintHistory[enemyType]) {
      this._restraintHistory[enemyType] = true;
      console.log(`[PAS] First restraint by ${enemyType} recorded`);
      
      // エロメモリー解放チェック
      this.checkMemoryUnlock();
    }
  };

  Game_Actor.prototype.hasBeenRestrainedBy = function(enemyType) {
    return !!(this._restraintHistory && this._restraintHistory[enemyType]);
  };

  Game_Actor.prototype.hasBeenRestrainedAtAll = function() {
    return !!(this._restraintHistory && Object.keys(this._restraintHistory).length > 0);
  };

  /* ========== 目のハイライト消失（戦闘中のみ有効） ========== */
  Game_Actor.prototype.loseHighlight = function() {
    if (this._pleasure?.highlightLost) return; // 既に消えている
    
    this._pleasure = this._pleasure || {};
    this._pleasure.highlightLost = true;
    console.log(`[PAS] ${this.name()} lost eye highlight (this battle only)`);
    
    // バトルログに通知
    if ($gameParty.inBattle() && window.BattleLogManager?.push) {
      BattleLogManager.push(`${this.name()}の目の光が失われた…`);
    }
  };

  Game_Actor.prototype.hasLostHighlight = function() {
    return !!this._pleasure?.highlightLost;
  };

  /* ========== エロメモリー解放チェック（7つに厳選） ========== */
  Game_Actor.prototype.checkMemoryUnlock = function() {
    if (!window.EroMemory) return;

    const corruption = this.getCorruption();

    // 1. 初回拘束
    if (this.hasBeenRestrainedAtAll()) {
      EroMemory.unlock("first_restraint");
    }
  };
})();
