// Improved PleasureAttackManager.js
(() => {
  console.log('[PleasureAttackManager] Enhanced version loaded + Floor Logic');

  function isPleasureAttack(skill) {
    return !!(skill?.meta?.PleasureSkill);
  }
  function isInsertSkill(skill) {
    return !!(skill?.meta?.InsertSkill);
  }

  const WEAK_PARTS = ['pussy', 'breasts'];
  function isWeakPart(skill) {
    return WEAK_PARTS.some(part => skill.meta?.TargetPart === part && skill.meta?.WeakPoint);
  }

  // ==== 追加：イベント順序と最低開始ライン ====
  const EVENT_ORDER = { react: 0, danger: 1, climax: 2, orgasm: 3 };
  const FLOOR_BY_STAGE = { 1: "react", 2: "danger", 3: "climax" };

  async function applyPleasureEffect(actor, skill) {
    if (skill.meta?.OnlyIfNotRestrained && PleasureStateManager.isActorRestrained(actor)) {
      console.log(`[PAM] Skip pleasure attack: ${actor.name()} is restrained`);
      return;
    }

    // ダウン状態専用演出
    if (actor.isStateAffected(15)) {
      const targetPart = skill.meta?.TargetPart || 'pussy';
      if (window.PleasureDisplayManager?.show) {
        // eventTypeは "down_attack" に統一し、phaseでpre/mainを切り替える
        console.log(`[PAM] Down attack: phase pre`);
        const pre = await PleasurePoseController.getDisplayInfo(
          actor, "down_attack", targetPart, true, { phase: "pre" }
        );
        await window.PleasureDisplayManager.show(actor, pre);
        
        if (typeof window.waitMessageWindow === "function") {
          await window.waitMessageWindow();
        }
        
        console.log(`[PAM] Down attack: phase main`);
        const main = await PleasurePoseController.getDisplayInfo(
          actor, "down_attack", targetPart, false, { phase: "main" }
        );
        await window.PleasureDisplayManager.show(actor, main);
        
        if (typeof window.waitMessageWindow === "function") {
          await window.waitMessageWindow();
        }
      }
      return;
    }

    const corruptionGain = Number(skill.meta?.CorruptionGain || 0);
    if (corruptionGain > 0) actor.gainCorruption(corruptionGain);

    const targetPart = skill.meta?.TargetPart || 'pussy';
    let eventType = PleasureDataManager.determineEventType(actor);

    // ==== フロア適用処理 ====
    const stage = (actor._pleasure?.orgasmCount || 0) + 1; // stage1〜3
    const floor = FLOOR_BY_STAGE[stage] || "react";
    if (EVENT_ORDER[eventType] < EVENT_ORDER[floor]) {
      console.log(`[PAM] Floor applied: ${eventType} → ${floor} (stage${stage})`);
      eventType = floor;
    }

    const pleasureGain = Number(skill.meta?.PleasureGain || 40);
    const developmentGain = Number(skill.meta?.DevelopmentGain || 0);
    if (developmentGain > 0) actor.gainDevelopment(targetPart, developmentGain);

    actor.gainMp(-pleasureGain);

    const clothingDamage = Number(skill.meta?.ClothingDamage || 40);
    if (typeof actor.damageClothing === "function") {
      actor.damageClothing(clothingDamage);
      if (SceneManager._scene?._clothingDurabilityWindow) {
        SceneManager._scene._clothingDurabilityWindow.refresh();
      }
    }

    // ★ エロ攻撃のSEを再生（挿入状態・部位によって変える）
    if (AudioManager && AudioManager.playSe) {
      const isInserted = PleasureStateManager.isActorInserted(actor);
      let seName = "Damage2";
      let pitch = 100;
      let volume = 150;
      
      // 胸攻撃は専用SE
      if (targetPart === 'breast') {
        seName = "ero_breast";
        pitch = 100;
        volume = 150;
      } 
      // 挿入時（膣・口共通）
      else if (isInserted) {
        seName = "ero_insert_se";
        pitch = targetPart === 'pussy' ? 90 : 95;  // 膣は少し低め、口は標準
        volume = 300;
      } 
      // 非挿入時（膣・口共通）
      else {
        seName = "ero_non_insert_se";
        pitch = targetPart === 'pussy' ? 95 : 100;  // 膣は少し低め、口は標準
        volume = 300;
      }
      
      console.log(`[PAM] Playing SE: ${seName} (pitch: ${pitch}, part: ${targetPart}, inserted: ${isInserted})`);
      AudioManager.playSe({
        name: seName,
        volume: volume,
        pitch: pitch,
        pan: 0
      });
    }

    // 演出
    console.log(`[PAM] Triggering event: ${eventType} (phase: pre) for ${actor.name()}`);
    await PleasureTriggerManager.triggerEvent(actor, eventType, targetPart, { phase: "pre" });
    
    console.log(`[PAM] Waiting for message window...`);
    if (typeof window.waitMessageWindow === "function") {
      await window.waitMessageWindow();
    } else {
      console.warn(`[PAM] waitMessageWindow not available, waiting 500ms`);
      await new Promise(resolve => setTimeout(resolve, 500));
    }
    
    if (eventType !== "orgasm") {
      console.log(`[PAM] Triggering event: ${eventType} (phase: main) for ${actor.name()}`);
      await PleasureTriggerManager.triggerEvent(actor, eventType, targetPart, { phase: "main" });
    }
  }

  const _Game_Action_apply = Game_Action.prototype.apply;
  Game_Action.prototype.apply = function(target) {
    _Game_Action_apply.call(this, target);
    const skill = this.item();
    if (!(target instanceof Game_Actor)) return;

    if (isInsertSkill(skill)) {
      if (window.InsertEventHandler?.handleInsertEvent) {
        InsertEventHandler.handleInsertEvent(target);
      }
      return;
    }
    if (isPleasureAttack(skill)) {
      applyPleasureEffect(target, skill);
    }
  };
})();
