(() => {
  console.log("[PleasureDataManager] Loaded");

  window.PleasureDataManager = {
    /**
     * 堕落度からステージを判定
     * @param {number} corruption - 堕落度
     * @returns {string} - ステージ ('low', 'high')
     */
    determineStageByCorruption(corruption) {
      if (corruption >= 50) return "high";
      return "low";
    },

    /**
     * 快感度（MP割合）からステージを判定
     * @param {Game_Actor} actor - アクター
     * @returns {number} - ステージ (0:通常, 1:軽度, 2:中度, 3:重度, 4:絶頂)
     */
    determineStageByPleasure(actor) {
      const rate = actor.mp / actor.mmp;
      if (rate <= 0) return 4;       // 絶頂 (orgasm)
      if (rate <= 0.3) return 3;     // クライマックス (climax)
      if (rate <= 0.6) return 2;     // デンジャー (danger)
      if (rate <= 1.0) return 1;     // リアクト (react)
      return 0;                      // スタンバイ (standby)
    },

    /**
     * eventTypeを決定
     * @param {Game_Actor} actor - アクター
     * @returns {string} - eventType ('react', 'danger', 'climax', 'orgasm', etc.)
     */
    determineEventType(actor) {
      const pleasureStage = this.determineStageByPleasure(actor);
      const mpRate = actor.mp / actor.mmp;

      let eventType;
      switch (pleasureStage) {
        case 4: eventType = "orgasm"; break;
        case 3: eventType = "climax"; break;
        case 2: eventType = "danger"; break;
        case 1: eventType = "react"; break;
        default: eventType = "standby"; break;
      }
      
      console.log(`[PDM] determineEventType: MP=${actor.mp}/${actor.mmp} (${Math.round(mpRate*100)}%), stage=${pleasureStage} → "${eventType}"`);
      return eventType;
    }
  };
})();
