(() => {
  console.log("[PleasurePoseController] Enhanced version loaded");

  // PleasurePoseController が未定義なら初期化
  if (!window.PleasurePoseController) {
      window.PleasurePoseController = {};
  }

  // グローバル化: 堕落値からステージを判定（汎用関数）
  window.determineStageByCorruption = function(corruption) {
    if (corruption >= 50) return "high";
    return "low";
  };

  // MPから快感ステージを判定
  window.PleasurePoseController.determineStageByMp = function(actor) {
      const rate = actor.mp / actor.mmp;
      if (rate <= 0) return 4;
      if (rate <= 0.3) return 3;
      if (rate <= 0.6) return 2;
      if (rate <= 0.8) return 1;
      return 0;
  };
  if (typeof logExecutionPoint !== "function") {
    window.logExecutionPoint = function(point) {
        console.log(`[Debug] Execution Point: ${point} - Timestamp: ${Date.now()}`);
    };
}



// getProfileNameFromEnemy をグローバルスコープに登録
window.PleasurePoseController.getProfileNameFromEnemy = function (actor) {
    const enemy = $gameTroop.members().find(e => e && e.isAlive());
    if (!enemy) {
        console.warn("[PPC] No enemy found. Returning default profile 'slime'.");
        return "slime";
    }

    const fallbackMap = {
      // DB表示名 : 内部ベース名（英字）
      "スライム": "slime",
      "電撃スライム": "electSlime",
      "毒スライム": "poisonSlime",
      "媚薬スライム": "aphrodisiacSlime",
      "ゴブリン": "goblin",
      "触手":"tentacle",
      "ルストテンタケル": "breastTentacle",
      "レイダー": "reider",
      "レイダーの首領": "reiderBoss",
      "掌打師": "slapper",
      "孕ませ狂い": "insaneMan",
      "催眠ゴースト": "hypnoticGhost",
      "ヘーベテンタクル": "tentacle_hebe"
    };

    const baseName = enemy.originalName?.() || enemy.name();
    if (!baseName) {
        console.warn("[PPC] No valid enemy name found. Returning default profile 'slime'.");
        return "slime";
    }

    const sanitized = fallbackMap[baseName] || baseName.toLowerCase().replace(/[^a-z0-9]/gi, "");

    // モンスター側から呼ばれた場合のチェック
    if (!actor || !actor.isActor || !actor.isActor()) {
        console.warn(`[PPC] Invalid actor context. Returning sanitized profile name: ${sanitized}`);
        return sanitized;
    }

    let isRestrained = false;
    let isInserted = false;
    const corruption = actor.getCorruption?.() ?? 0;
    const corruptionStage = determineStageByCorruption(corruption); // ← ここ追加！
    if (actor && actor.isActor && actor.isActor()) {
        isRestrained = PleasureStateManager?.isActorRestrained?.(actor) || false;
        isInserted = actor._pleasure?.inserted || false;
    }

    let profileName;
    
    // 非拘束時は汎用の standpose を使用
    if (!isRestrained && !isInserted) {
        profileName = `standpose_${corruptionStage}`;
        console.log(`[PPC] Profile Name Determined: ${profileName} (generic stand pose)`);
        console.log(`[PPC] isRestrained=${isRestrained}, isInserted=${isInserted}, actor=${actor?.name?.()}`);
        return profileName;
    }
    
    // 拘束時/挿入時はモンスター固有のプロファイルを使用
    profileName = sanitized;
    if (isRestrained) {
        profileName += "_restrained";
        if (isInserted) {
            profileName += "_insert";
        }
    }
    profileName += `_${corruptionStage}`;

    console.log(`[PPC] Profile Name Determined: ${profileName}`);
    console.log(`[PPC] isRestrained=${isRestrained}, isInserted=${isInserted}, actor=${actor?.name?.()}`);

    return profileName;
};



  window.loadPoseProfile = async function (profileName) {
  if (!window.PoseProfiles) window.PoseProfiles = {};
  if (window.PoseProfiles[profileName]) return;

  try {
     const url = `dataEx/poseProfiles/${profileName}.json?t=${Date.now()}`; // dev用キャッシュ無効化
    console.log("[PPC] loading profile json from:", url); // ← 追加
    const res = await fetch(url);
    if (!res.ok) throw new Error("HTTP error " + res.status);
    const json = await res.json();
    window.PoseProfiles[profileName] = json;
    console.log(`[BBM] Loaded pose profile: ${profileName}`);
  } catch (e) {
    console.error(`[BBM] Failed to load profile for ${profileName}`, e);
  }
};


    window.PleasurePoseController.determinePleasureStage = function(orgasmCount) {
    if (orgasmCount >= 2) return "stage3";
    if (orgasmCount === 1) return "stage2";
    return "stage1"; // 0〜1回目は stage1 とみなす
    };

window.PleasurePoseController.selectDialogueWithLog = function(profile, eventType, targetPart, corruptionStage, developmentStage, orgasmCount = 0, actor = null) {
  const stageKey = window.PleasurePoseController.determinePleasureStage(orgasmCount) || "stage1";

  let dialogueList;
  let resolve = null;
  
  // ★ targetPartの正規化: breasts -> breast（JSONファイルではbreastが使用されている）
  let actualTargetPart = targetPart;
  if (targetPart === "breasts") {
    actualTargetPart = "breast";
  }
  
  // ★ フォールバック: targetPartがbreastでセリフが見つからない場合、pussyを試す
  const availableTargetParts = profile?.lines?.[eventType] ? Object.keys(profile.lines[eventType]) : [];
  if (actualTargetPart === "breast" && !availableTargetParts.includes("breast") && availableTargetParts.includes("pussy")) {
    actualTargetPart = "pussy";
  }

  if ((stageKey === "stage2" || stageKey === "stage3") && actor) {
    resolve = actor._resolveHistory?.[stageKey] || "resist";
    dialogueList = profile?.lines?.[eventType]?.[actualTargetPart]?.[stageKey]?.[corruptionStage]?.[resolve];
  } else {
    dialogueList = profile?.lines?.[eventType]?.[actualTargetPart]?.[stageKey]?.[corruptionStage];
  }

  console.log("[DEBUG] target keys セリフ選択要素:", {
    eventType,
    targetPart,
    stageKey,
    corruptionStage,
    orgasmCount,
    resolve
  });
  console.log("[DEBUG] dialogueList BEFORE filter =", dialogueList); 

  if (!dialogueList) {
    console.warn(`[PPC] [WithLog] No dialogue list for ${stageKey}. Trying fallback to stage1.`);
    dialogueList = profile?.lines?.[eventType]?.[targetPart]?.["stage1"]?.[corruptionStage];
  }

  if (!Array.isArray(dialogueList)) {
  console.warn(`[PPC] [WithLog] dialogueList is not array. Trying to wrap if possible.`);
  if (typeof dialogueList === "object" && dialogueList.dialogueSequence) {
    dialogueList = [dialogueList]; // 配列にラップ
    console.log("##########################配列にラップしたよ###################################")
  } else {
    console.warn(`[PPC] [WithLog] Cannot wrap invalid dialogueList.`);
    return { text: "...", log: "" };
  }
}

  // ✅ require 条件付きセリフフィルタリング
  const filteredList = dialogueList.filter(entry => {
    if (typeof entry === "string") return true;
    if (!entry.require) return true;

    // ステータス条件をすべて満たしていればOK
    return entry.require.every(key => {
      return $gameActors.actor(1)?.hasPersistentBadStatus?.(key);
    });
  });

  const finalList = filteredList.length > 0 ? filteredList : dialogueList;
  const selected = finalList[Math.floor(Math.random() * finalList.length)];
  if (!selected) {
  return { text: "...", log: "" };
}

  if (typeof selected === "string") {
    return { text: selected, log: "" };
  }

  // 🔹 dialogueSequence対応（単体構造）
  if (selected?.dialogueSequence) {
  return {
    dialogueSequence: selected.dialogueSequence,
    log: selected.log ?? "",
    pose: selected.pose ?? "auto",
    expression: selected.expression ?? "normal",
    overlays: selected.overlays ?? []
  };
}


  if (selected?.text) {
  return {
    text: selected.text,
    log: selected.log ?? "",
    pose: selected.pose ?? "auto",
    expression: selected.expression ?? "normal",
    overlays: selected.overlays ?? []
  };
}

  return { text: "...", log: "" };
};


// === Safe replacement ===
// PleasurePoseController.js 内の getDisplayInfo をこの実装で置き換え

window.PleasurePoseController.getDisplayInfo = async function (
  actor,
  eventType = "react",
  targetPart = "pussy",
  withDialogue = true,
  options = {}
  ) {
  logExecutionPoint("PleasurePoseController.getDisplayInfo");
  
  // ★デバッグ: 呼び出し時の情報を記録
  console.log(`[PPC-CALL] getDisplayInfo called:`);
  console.log(`[PPC-CALL]   eventType="${eventType}"`);
  console.log(`[PPC-CALL]   targetPart="${targetPart}"`);
  console.log(`[PPC-CALL]   withDialogue=${withDialogue}`);
  console.log(`[PPC-CALL]   options=`, options);
  console.log(`[PPC-CALL]   actor MP: ${actor.mp}/${actor.mmp} (${Math.round(actor.mp/actor.mmp*100)}%)`);

  // ---- 状態の収集 ----
  const corruptionValue = actor.getCorruption?.() ?? 0;
  const corruptionStage = determineStageByCorruption(corruptionValue);
  const developmentStageForTargetPart = actor.getDevelopmentStage?.(targetPart) ?? "low";
  const orgasmCount = actor.getOrgasmCount?.() ?? 0;
  

  // ---- プロファイル読込 ----
  const profileName = this.getProfileNameFromEnemy(actor);
  await loadPoseProfile(profileName);

  if (!window.PoseProfiles?.[profileName]) {
    console.error(`[PPC] Profile not loaded after fetch: ${profileName}`);
    
    // ★ 拘束状態なら基本オーバーレイを維持（エラー時もチラつき防止）
    const isRestrained = window.PleasureStateManager?.isActorRestrained?.(actor) || false;
    let baseOverlays = [];
    if (isRestrained) {
      const enemyKey = profileName.split("_")[0];
      const restraintKey = window.OverlaySets?.[enemyKey]?.mapping?.restrain || "restrain";
      const orgasmCount = actor.getOrgasmCount?.() || 0;
      const stageKey = this.determinePleasureStage(orgasmCount);
      const blushKey = window.OverlayBuilder?.BLUSH_BY_STAGE?.[stageKey] || "blush_mid";
      baseOverlays = [restraintKey, blushKey];
      console.log(`[PPC] Error fallback: Maintaining base overlays for restrained state: [${baseOverlays.join(", ")}]`);
    }
    
    return {
      profileName,
      pose: "uniform_intact",
      expression: "normal",
      underOverlays: [],
      overlays: baseOverlays,
      dialogue: "...",
      log: ""
    };
  }
  const profile = window.PoseProfiles[profileName];

  // ---- セリフ決定 ----
  let selectedDialogue = "";
  let selectedLogMessage = "";
  let selectedDialogueSequence = null;

  console.log(`[PPC-DIALOGUE] Checking dialogue: eventType="${eventType}", withDialogue=${withDialogue}`);
  if (["standby", "orgasm", "orgasm_resist", "orgasm_fall"].includes(eventType)) {
    console.log(`[PPC-DIALOGUE] ${eventType} trigger: Suppressing dialogue`);
  } else if (withDialogue) {
    console.log(`[PPC-DIALOGUE] Calling selectDialogueWithLog...`);
    const result = this.selectDialogueWithLog(
      profile,
      eventType,
      targetPart,
      corruptionStage,
      developmentStageForTargetPart,
      orgasmCount,
      actor
    );
    if (result?.dialogueSequence) selectedDialogueSequence = result.dialogueSequence;
    else if (result?.text) selectedDialogue = result.text;
    selectedLogMessage = result?.log || "";
  } else {
    console.log(`[PPC-DIALOGUE] No dialogue (withDialogue=false)`);
  }

  // 絶頂系は視覚定義スキップ
  if (["orgasm", "orgasm_resist", "orgasm_fall"].includes(eventType)) {
    console.log("[PPC] Orgasm eventType detected, skipping poseProfiles visuals.");
    
    // 現在の服装状態に基づいたposeを決定
    const clothingStage = actor.getClothingStage?.() || "intact";
    const currentPose = `uniform_${clothingStage}`;
    console.log(`[PPC] Orgasm pose determined from clothing: ${currentPose} (stage: ${clothingStage})`);
    
    // ★ 拘束状態なら基本オーバーレイを維持（チラつき防止）
    const isRestrained = window.PleasureStateManager?.isActorRestrained?.(actor) || false;
    let baseOverlays = [];
    if (isRestrained) {
      const enemyKey = profile.meta?.enemyKey || profileName.split("_")[0];
      const restraintKey = window.OverlaySets?.[enemyKey]?.mapping?.restrain || "restrain";
      const stageKey = this.determinePleasureStage(orgasmCount);
      const blushKey = window.OverlayBuilder?.BLUSH_BY_STAGE?.[stageKey] || "blush_mid";
      baseOverlays = [restraintKey, blushKey];
      console.log(`[PPC] Maintaining base overlays for restrained state: [${baseOverlays.join(", ")}]`);
    }
    
    return {
      profileName,
      pose: currentPose,
      expression: "normal",
      overlays: baseOverlays,
      underOverlays: [],
      dialogue: selectedDialogue,
      dialogueSequence: selectedDialogueSequence,
      log: selectedLogMessage,
      eventType
    };
  }

  // ---- visuals の探索（JSON）----
// ---- visuals の探索（JSON）----
// 旧: visualEventType / corruptionStage / orgasmStageKey / resolveTone … は廃止
const phaseKey = (options?.phase === "pre") ? "pre" : "main";

// ここで「絶頂回数 → stageKey（stage1/2/3）」を決定
const stageKey = window.PleasurePoseController.determinePleasureStage(actor.getOrgasmCount?.() || 0) || "stage1";

// プロファイルのノードを段階的に解決：stage → eventType → phase
const visualsRoot      = profile.visuals || {};
const stageNode        = visualsRoot[stageKey] || {};
const eventNode        = stageNode[eventType] || {};

// 最終候補（優先度：stage内の phase → stage内の main → defaults の phase → defaults の main）
const visualNode =
  eventNode[phaseKey] ??
  eventNode.main ??
  null;

// SE（任意）
const selectedSe = visualNode?.se || null;

// ---- JSONベース値の抽出 ----
// undefined → null（未指定扱い）、[] は「指定済み空」として尊重
const basePose       = (visualNode && "pose"       in visualNode) ? visualNode.pose       : null;
const baseExpression = (visualNode && "expression" in visualNode) ? visualNode.expression : null;
const rawOverlays    = visualNode?.overlays;
const baseOverlays   = (rawOverlays === undefined) ? null : rawOverlays;
const rawUnder       = visualNode?.underOverlays;
const baseUnder      = (rawUnder === undefined) ? null : rawUnder;

// デバッグ用：overlays の型と内容を確認
if (baseOverlays === null || (Array.isArray(baseOverlays) && baseOverlays.length === 0)) {
  console.log(`[PPC] baseOverlays is ${baseOverlays === null ? 'null' : 'empty array'}, will auto-fill`);
}

// （任意）defaults節が残っていた場合の検知ログ
if (profile.visuals?.defaults) {
  console.warn("[PPC] visuals.defaults は無視されます。プロファイルから削除推奨:", profileName);
}

// ---- 最終確定：JSON優先、未指定は自動補完 ----

// ★ stand_pose使用判定（BattleBustManagerと同じロジック）
// standpose_xxx プロファイルまたは uniform系のポーズで、_lowプロファイルで、restrained/insertでない場合は汎用stand_poseを使用
const determinedPose = basePose ?? "auto";
const willUseStandPose = (
  profileName.startsWith("standpose_") ||
  (profileName.endsWith("_low") && 
   !profileName.includes("restrained") && 
   !profileName.includes("insert") &&
   (determinedPose === "auto" || determinedPose.startsWith("uniform_")))
);

if (willUseStandPose) {
  console.log(`[PPC] Detected stand_pose usage for: ${profileName}, using generic overlays only`);
}

// コンテキスト情報の構築（自動補完用）
const autoFillContext = {
  profileName,
  profile,
  stage: stageKey,
  eventType,
  phase: phaseKey,
  targetPart: targetPart || "pussy",
  enemyKey: willUseStandPose ? null : (profile.meta?.enemyKey || profileName.split("_")[0]),
  isInserted: profile.meta?.state?.includes("inserted") || /insert/i.test(profileName),
  isRestrained: profile.meta?.state?.includes("restrained") || /restrained/i.test(profileName),
  willUseStandPose: willUseStandPose  // ★stand_pose使用時はblushをスキップ
};

let selectedExpression = baseExpression ?? "normal";
let selectedOverlays = [];
if (baseOverlays !== null) {
  selectedOverlays = window.OverlayResolver.resolveOverlays(baseOverlays);
}

let selectedUnderOverlays = [];
if (baseUnder !== null) {
  selectedUnderOverlays = window.OverlayResolver.resolveOverlays(baseUnder);
}
let selectedPose = basePose ?? "auto";

// ★ 自動補完システムの適用
if (window.VisualAutoFill) {
  // 表情が未指定の場合、自動決定
  if (baseExpression === null) {
    selectedExpression = window.VisualAutoFill.weightedRandomExpression(
      stageKey,
      eventType,
      null, // dialogueText (単発の表情決定時はnullでよい、あるいは別途渡す)
      autoFillContext.isRestrained // ← これが最重要
    );
    console.log(`[PPC] Auto-filled expression: ${selectedExpression}`);
  }
  
  // オーバーレイが未指定の場合、自動構築
  if (baseOverlays === null) {
    if (willUseStandPose) {
      // ★ stand_pose時はオーバーレイなし（汎用立ち絵には赤面差分がないため）
      selectedOverlays = [];
      console.log(`[PPC] Using generic stand_pose: no overlays (no blush variants available)`);
    } else {
      // 通常通りモンスター固有のオーバーレイを自動生成
      const autoResult = window.VisualAutoFill.buildOverlaysForLine(
        autoFillContext,
        0.5 // main/preは中間値
      );
      selectedOverlays = window.OverlayResolver.resolveOverlays(autoResult.overlays || []);
      console.log(`[PPC] Auto-filled overlays: ${(autoResult.overlays || []).join(", ")}`);
      
      // underOverlaysも自動補完
      if (baseUnder === null && autoResult.underOverlays && autoResult.underOverlays.length > 0) {
        selectedUnderOverlays = window.OverlayResolver.resolveOverlays(autoResult.underOverlays);
        console.log(`[PPC] Auto-filled underOverlays: ${autoResult.underOverlays.join(", ")}`);
      }

      // 擬音の追加（dialogueSequenceがない場合のみ、かつエロ攻撃イベント時のみ）
      // ※dialogueSequenceがある場合は、autoFillDialogueSequence内で自動追加されるため不要
      // ★すべてのエロ攻撃イベントでSFXを表示（withDialogue不問）
      // ★stand_pose使用時はSFXをスキップ（画像が存在しないため）
      const isEroAttackEvent = ["react", "danger", "climax", "orgasm", "orgasm_resist", "orgasm_fall", "insert", "down_attack"].includes(eventType);
      if (!selectedDialogueSequence || selectedDialogueSequence.length === 0) {
        if (isEroAttackEvent && !willUseStandPose && window.VisualAutoFill.getBubbleOverlaysFromContext) {
           const bubbles = window.VisualAutoFill.getBubbleOverlaysFromContext(autoFillContext, 0.5);
           if (bubbles) {
             if (Array.isArray(bubbles)) selectedOverlays.push(...bubbles);
             else selectedOverlays.push(bubbles);
             console.log(`[PPC] Auto-filled SFX bubbles (single line):`, bubbles);
           }
        } else if (willUseStandPose && isEroAttackEvent) {
          console.log(`[PPC] Skipped SFX for stand_pose (no SFX images available in generic folder)`);
        }
      }
    }
  }
} else {
  console.warn("[PPC] VisualAutoFill not loaded, using fallback values");
}



const normalizeOverlayKey = (k) => (typeof k === "string" ? k.replace(/^p(\d+):/, "p$1_") : k);
selectedOverlays = selectedOverlays.map(normalizeOverlayKey);

// pose:auto → 衣装で確定
if (selectedPose === "auto") {
  const clothingStage = actor.getClothingStage?.() || "intact";
  const clothingType  = actor.getClothingType?.() ?? "uniform";
  selectedPose = `${clothingType}_${clothingStage}`;
}
if (!selectedPose) selectedPose = "uniform_intact";

console.log(`[PPC] Selected pose: ${selectedPose}, expression: ${selectedExpression}, overlays: ${selectedOverlays.join(", ")}`);

// ★ dialogueSequence の自動補完
if (window.VisualAutoFill && Array.isArray(selectedDialogueSequence) && selectedDialogueSequence.length > 0) {
  console.log("[PPC] Auto-filling dialogueSequence...");
  selectedDialogueSequence = window.VisualAutoFill.autoFillDialogueSequence(
    selectedDialogueSequence,
    autoFillContext
  );
}

// getDisplayInfo の "return displayInfo;" を作る直前あたりで
if (selectedSe && Array.isArray(selectedDialogueSequence) && selectedDialogueSequence.length > 0) {
  const first = selectedDialogueSequence[0];
  first.fx = first.fx || {};
  if (!first.fx.se) first.fx.se = selectedSe; // 既に se があるなら上書きしない
}
const overlaysSource =
  (eventNode?.[phaseKey] && ("overlays" in eventNode[phaseKey])) ? "event.phase" :
  (eventNode?.main      && ("overlays" in eventNode.main))       ? "event.main"  :
  "none";
console.log("[PPC-TRACE] overlays source =", overlaysSource, "selectedOverlays =", selectedOverlays);

  // いったんオブジェクトにまとめる
  const displayInfo = {
    profileName,
    pose: selectedPose,
    expression: selectedExpression,
    overlays: selectedOverlays,
    underOverlays: selectedUnderOverlays,
    dialogue: selectedDialogue,
    dialogueSequence: selectedDialogueSequence,
    log: selectedLogMessage,
    eventType,
    targetPart,
    se: selectedSe
  };

  // ★ 橋渡し：単発セリフ時に PDM 側が拾えるよう dialogueFx.se を付与
  if (selectedSe && !displayInfo.dialogueSequence) {
    displayInfo.dialogueFx = { se: selectedSe };
  }
  console.log(displayInfo)
  return displayInfo;
  
};


})();
