(() => {
  console.log('[PleasureStateManager] loaded (リファクタ＋描画対応版)');

  const RESTRAINT_STATE_IDS = [10, 11]; // ← 拘束ステートIDをここに定義
  const DOWN_STATE_ID = 15; // 行動不能ステートをここに定義


  // ✅ メイン関数：ステート付与＋演出
  function applyState(actor, stateId) {
    if (!actor || !stateId) return;
    actor.addState(stateId);
    console.log(`[PleasureStateManager] applyState: actor=${actor.name()}, stateId=${stateId}`);

    if (RESTRAINT_STATE_IDS.includes(stateId)) {
        const eventType = PleasureDataManager.determineEventType(actor);
        triggerBustRedraw(actor, eventType);
        
        // 拘束時に敵タイプを記録（エロメモリー用）
        const enemyType = determineEnemyType();
        if (enemyType && actor.recordRestraint) {
          actor.recordRestraint(enemyType);
        }
    }
    try { OneShotSway?.play(actor, { amplitude: 14, duration: 20, cycles: 2 }); } catch(e) { console.warn(e); }
  }

  // ✅ 敵タイプ判定（現在のアクションから）
  function determineEnemyType() {
    try {
      const action = BattleManager._action;
      if (!action) return null;
      
      const subject = action.subject();
      if (!subject || !subject.isEnemy()) return null;
      
      const enemy = subject.enemy();
      if (!enemy) return null;
      
      const name = enemy.name.toLowerCase();
      
      // 敵名から判定
      if (name.includes("slime") || name.includes("スライム")) {
        return "slime";
      } else if (name.includes("breasttentacle") || name.includes("ルストテンタケル")) {
        return "breastTentacle";
      } else if (name.includes("tentacle") || name.includes("触手")) {
        return "tentacle";
      } else if (name.includes("goblin") || name.includes("ゴブリン")) {
        return "goblin";
      }
      
      // その他の敵タイプを追加可能
      return "other";
    } catch (e) {
      console.warn("[PleasureStateManager] Failed to determine enemy type:", e);
      return null;
    }
  }

  // ✅ 演出描画処理（共通化）
  async function triggerBustRedraw(actor, eventType = null, targetPart = "pussy") {
    if (!actor) return;

    console.log(`[PSM-REDRAW] triggerBustRedraw called: eventType=${eventType ? '"'+eventType+'"' : 'null (will determine)'}`);
    const effectiveEventType = eventType || PleasureDataManager.determineEventType(actor);
    console.log(`[PSM-REDRAW] effectiveEventType="${effectiveEventType}"`);
    const info = await window.PleasurePoseController.getDisplayInfo(actor, effectiveEventType, targetPart);

    console.log("[PleasureStateManager] triggering redraw:", info);
    await window.BattleBustManager.show(actor, info);
  }


  // ✅ 拘束判定（再利用用）
  function isActorRestrained(actor) {
    if (!actor || typeof actor.isStateAffected !== 'function') {
      console.warn("[PleasureStateManager] isActorRestrained: Invalid actor or method not found");
      return false;
    }
    const restrained = RESTRAINT_STATE_IDS.some(id => actor.isStateAffected(id));
    console.log(`[PleasureStateManager] isActorRestrained: actor=${actor.name()}, result=${restrained}`);
    return restrained;
  }

  function isActorInserted(actor) {
  if (!actor) return false;
  return !!actor._pleasure?.inserted;
}


  // ✅ 拘束解除時に再描画（任意）
  function applyStateReleaseResult(actor, isSuccess) {
    if (!actor) return;
    if (isSuccess) {
      console.log(`[PleasureStateManager] applyStateReleaseResult: success=true for ${actor.name()}`);
      RESTRAINT_STATE_IDS.forEach(stateId => {
        if (actor.isStateAffected(stateId)) {
          actor.removeState(stateId);
          console.log(`[PleasureStateManager] Removed restraint state ${stateId} from ${actor.name()}`);
        }
      });
      clearInsertState(actor);
      // 🔄 通常立ち絵に戻す
      setTimeout(() => triggerBustRedraw(actor), 0);
    } else {
      console.log(`[PleasureStateManager] applyStateReleaseResult: success=false for ${actor.name()}`);
      applyFailurePenalty(actor);
    }
  }

  function clearInsertState(actor) {
    if (!actor) return;
    if (actor._pleasure?.inserted) {
      console.log("[PSM] 挿入状態を解除");
      actor._pleasure.inserted = false;
      actor._pleasure.insertedEventShown = false;
    }
  }

  function applyFailurePenalty(actor) {
    if (!actor) return;
    const penaltyAmount = 50;
    console.log(`[PleasureStateManager] applyFailurePenalty: actor=${actor.name()}, penalty=${penaltyAmount}`);
    actor.gainMp(-penaltyAmount);
  }

  function checkStateRelease(actor) {
    if (!actor) return;
    console.log(`[PleasureStateManager] [skip] checkStateRelease called for ${actor.name()}, but auto release mini-game is disabled`);
  }

  function startReleaseMiniGame(actor) {
    console.log(`[PleasureStateManager] startReleaseMiniGame called for ${actor.name()}`);
    if (SceneManager._scene?.startPleasureReleaseMiniGame) {
      SceneManager._scene.startPleasureReleaseMiniGame(actor);
    }
  }

  // ✅ グローバル公開
  window.PleasureStateManager = {
    applyState,
    isActorInserted, // ← 追加
    checkStateRelease,
    isActorRestrained,
    startReleaseMiniGame,
    applyStateReleaseResult,
    applyFailurePenalty,
    triggerBustRedraw, // 念のため公開
  };

  // ✅ 全ステート付与に対応：addStateを拡張してhookする
  const _Game_Battler_addState = Game_Battler.prototype.addState;
  Game_Battler.prototype.addState = function(stateId) {
    _Game_Battler_addState.call(this, stateId);
      if (this.isActor && this.isActor() && RESTRAINT_STATE_IDS.includes(stateId)) {
    console.log(`[AutoHook] addState(${stateId}) → triggering restraint redraw & event`);
    const actor = this;
    actor._pleasure = actor._pleasure || {};
    actor._pleasure.restraintCount = (actor._pleasure.restraintCount || 0) + 1;
    setTimeout(() => {
      // ✅ 通常の立ち絵再描画（従来処理）
    const eventType = PleasureDataManager.determineEventType(actor);
    triggerBustRedraw(actor, eventType);
    try { OneShotSway?.play(this, { amplitude: 12, duration: 18, cycles: 2 }); } catch(e) { console.warn(e); }
      // ✅ 追加：RestraintEventHandler呼び出し（セリフ＋演出）
    if (window.RestraintEventHandler?.handle) {
      window.RestraintEventHandler.handle(actor);
      }
    }, 0);
    }
  };

})();
