(() => {
  console.log("[PleasureSystem] loaded");
  window.logExecutionPoint = function(point) {
    console.log(`[Debug] Execution Point: ${point} - Timestamp: ${Date.now()}`);
  };

  // stageごとの目標MP（danger開始・climax開始）
  const STAGE_TARGET_MP = {
    stage1: 0,     // 通常通り（全イベント有効）
    stage2: 50,    // danger開始MP
    stage3: 25     // climax開始MP
  };

  const RECOVERY_TURNS = 2;

  Game_Actor.prototype.initPleasureState = function () {
    if (!this._pleasure) {
      this._pleasure = {
        recTurns: 0,
        orgasmed: false,
        inserted: false,
        _standbyShown: false,
        orgasmCount: 0
      };
    } else {
      if (this._pleasure.orgasmCount === undefined) this._pleasure.orgasmCount = 0;
      if (this._pleasure._standbyShown === undefined) this._pleasure._standbyShown = false;
    }
  };

  // 絶頂回数取得
  Game_Actor.prototype.getOrgasmCount = function () {
    if (!this._pleasure) this.initPleasureState();
    return this._pleasure.orgasmCount || 0;
  };

  // 絶頂回数加算
  Game_Actor.prototype.incrementOrgasmCount = function () {
    if (!this._pleasure) this.initPleasureState();
    this._pleasure.orgasmCount = (this._pleasure.orgasmCount || 0) + 1;
    console.log(`[Pleasure] Orgasm Count: ${this._pleasure.orgasmCount}`);
  };

  // 戦闘開始時
  const _Game_Actor_onBattleStart = Game_Actor.prototype.onBattleStart;
  Game_Actor.prototype.onBattleStart = function () {
    logExecutionPoint("Game_Actor.onBattleStart");
    this.initPleasureState();
    _Game_Actor_onBattleStart.call(this);

    // 初期化
    if (!this._pleasure) this._pleasure = {};
    this._pleasureInitialized = true;

    const stageKey = PleasurePoseController.determinePleasureStage(this.getOrgasmCount());
    console.log(`[Test] Battle Start: stage=${stageKey}, targetMP=${STAGE_TARGET_MP[stageKey]}`);
  };

  // ターン終了時
  const _Game_Actor_onTurnEnd = Game_Actor.prototype.onTurnEnd;
  Game_Actor.prototype.onTurnEnd = function () {
    _Game_Actor_onTurnEnd.call(this);
    this.initPleasureState();

    if (this._pleasure.recTurns > 0) {
      this._pleasure.recTurns--;

      const stageKey = PleasurePoseController.determinePleasureStage(this.getOrgasmCount());
      const targetMp = Math.floor(this.mmp * (STAGE_TARGET_MP[stageKey] / 100));
      const perTurn = Math.ceil(targetMp / RECOVERY_TURNS);

      this.gainMp(perTurn);

      // 🔍 テスト出力
      console.log(`[Test] TurnEnd: stage=${stageKey}, gain=${perTurn}, currentMP=${this.mp}, targetMP=${targetMp}, recTurnsLeft=${this._pleasure.recTurns}`);

      if (this._pleasure.recTurns <= 0) {
        this._pleasure.orgasmed = false;
      }
    }
  };

  // 行動決定時
  const _Game_Actor_makeActions = Game_Actor.prototype.makeActions;
  Game_Actor.prototype.makeActions = function () {
    if (!this._pleasureInitialized) {
      console.warn(`[PleasureSystem] makeActions: Initialization missing for ${this.name()}, forcing initialization.`);
      if (!this._pleasure) this.initPleasureState();
      this._pleasureInitialized = true;
    }

    logExecutionPoint("Game_Actor.makeActions");
    _Game_Actor_makeActions.call(this);

    if (!BattleManager._phase || BattleManager._phase !== "input") return;

    if ($gameParty.inBattle() && !this._pleasure._standbyShown) {
      PleasureEventManager.trigger(this, "standby");
      this._pleasure._standbyShown = true;
    }
  };

})();
