(() => {
  console.log("[RegionViewManager] loaded");

  const REGION_FOLDER = "cutins/"; 
  const DEFAULT_POSITION = { x: Graphics.width - 150, y: Graphics.height - 150 };
  const DEFAULT_SCALE = 1.0;

  window.RegionViewManager = {
    _sprites: {},

    /**
     * 任意の部位をアップ表示
     * @param {string} key - 管理キー（例："pussy", "breasts"） ※重複防止用
     * @param {string} profile
     * @param {string} targetPart
     * @param {string} eventType
     * @param {Object} options
     */
    show(key, profile, targetPart, eventType, stage, options = {}) {
      this.hide(key);

      const filename = `${profile}_${targetPart}_${eventType}_${stage}`;
      const path = REGION_FOLDER + filename;
      const bitmap = ImageManager.loadPicture(path);
      const sprite = new Sprite(bitmap);

      sprite.anchor.set(0.5, 0.5);
      sprite.x = options.x ?? DEFAULT_POSITION.x;
      sprite.y = options.y ?? DEFAULT_POSITION.y;
      sprite.scale.set(options.scale ?? DEFAULT_SCALE);

      SceneManager._scene.addChild(sprite);
      this._sprites[key] = sprite;

      console.log(`[RegionViewManager] Show region view: key=${key}, file=${filename}`);
    },


    /**
     * 指定キーの部位を消す
     */
    hide(key) {
      if (this._sprites[key]) {
        SceneManager._scene.removeChild(this._sprites[key]);
        delete this._sprites[key];
        console.log(`[RegionViewManager] Region view hidden: ${key}`);
      }
    },

    /**
     * 全部位を一括で消す
     */
    hideAll() {
      for (const key in this._sprites) {
        SceneManager._scene.removeChild(this._sprites[key]);
      }
      this._sprites = {};
      console.log("[RegionViewManager] All region views hidden");
    }
  };
})();
