/*:
 * @target MZ
 * @plugindesc 拘束スキル解除用のプラグイン（もがく／確定脱出対応）
 * @author ChatGPT
 *
 * @help RestraintReleaseSkill.js
 *
 * 拘束状態（ステートID 10, 11）を解除する専用スキルの挙動を追加します。
 *
 * ◆ 低確率で拘束解除するスキル
 * <RestraintReleaseSkill>
 * <RestraintSuccessRate:0.3>
 *
 * ◆ 確定で拘束解除するスキル
 * <RestraintReleaseSkill:guaranteed>
 *
 * 拘束されていない状態で使用すると、何も起きません。
 *
 * ・ステートIDはスクリプト内の定数で変更可能です。
 * ・プラグインコマンドやパラメータはありません。
 */

(() => {
  // 拘束ステートID一覧（必要に応じて追加可能）
  const RESTRAINT_STATES = [10, 11];

  // 元の Game_Action.prototype.apply を保持
  const _Game_Action_apply = Game_Action.prototype.apply;

  // スキル適用時の処理を上書き
  Game_Action.prototype.apply = function(target) {
    // 元の適用処理を呼び出す
    _Game_Action_apply.call(this, target);

    const skill = this.item();
    // アクター対象かつスキルが存在しない場合は処理しない
    if (!skill || !(target instanceof Game_Actor)) return;

    const meta = skill.meta;
    // メモタグに <RestraintReleaseSkill> がなければ処理しない
    if (!meta.RestraintReleaseSkill) return;

    // 拘束状態でなければ何も起こさない（ログとメッセージのみ）
    const isRestrained = RESTRAINT_STATES.some(stateId => target.isStateAffected(stateId));
    if (!isRestrained) {
      $gameMessage.add(`${target.name()}は自由な状態だ……何も起きなかった。`);
      return;
    }

    // guaranteedなら100%、それ以外は確率判定（デフォルト0.3 = 30%）
    const isGuaranteed = meta.RestraintReleaseSkill === "guaranteed";
    const rate = Number(meta.RestraintSuccessRate) || 0.3;
    const success = isGuaranteed || Math.random() < rate;

    if (success) {
      // 拘束ステートをすべて解除
          const actor = target
          PleasureStateManager.applyStateReleaseResult(actor, true);

      $gameMessage.add(`${target.name()}は拘束を振りほどいた！`);
    } else {
      $gameMessage.add(`${target.name()}はもがいたが、拘束は解けなかった…`);
    }
  };
})();
