(() => {
  console.log("[VisualOverlayData] Loaded");

  // =============================================================================
  // デフォルトSFX定義（全モンスター共通）
  // =============================================================================
  // ★強弱対応3カテゴリ設計（拡張可能）
  // ※ファイル名は _left/_right を除いたベース名を指定
  // ※各モンスターのbustフォルダに同じ名前の画像を配置することで自動的に読み込まれる
  // ※配列で複数指定すると、連続回避しながらランダム選択される
  // ※soft/hardで演出の強度に応じて異なる擬音を表示可能
  const DEFAULT_SFX = {
    // 挿入時全般（挿入直後、ピストン弱、ピストン強すべて含む）
    inserted: {
      soft: [
        "default_pose_overlay_ぬちょっ1-6",
        "default_pose_overlay_ズプッ1-6",
        "default_pose_overlay_ヌプッ1-6"
      ],
      hard: [
        "default_pose_overlay_ズポ1-6",
        "default_pose_overlay_ぐちゅっ1-6",
        "default_pose_overlay_ズン1-6"
      ]
    },
    
    // 胸への愛撫
    breast: {
      soft: [
        "default_pose_overlay_ちゅぱ1-6"
      ],
      hard: [
        "default_pose_overlay_むぎゅ1-6",
        "default_pose_overlay_ちゅぱ1-6"
      ]
    },
    
    // その他（膣愛撫、絶頂など）
    other: {
      soft: [
        "default_pose_overlay_ぬちゃっ1-6",
        "default_pose_overlay_ヌポッ1-6"
      ],
      hard: [
        "default_pose_overlay_ぐちゃ1-6",
        "default_pose_overlay_ずぶ3-6"
      ]
    }
  };

  // =============================================================================
  // 演出シーケンスパターン定義
  // =============================================================================
  // ※dialogueSequenceの行数に応じて適切なパターンを選択
  const SEQUENCE_PATTERNS = {
    // 短い演出（1-2行）: 拘束、挿入pre
    quick: [
      { frame: 0, intensity: "soft" },
      { frame: 1, intensity: "hard" }
    ],
    
    // 標準演出（2-3行）: 通常エロ攻撃
    standard: [
      { frame: 0, intensity: "soft" },    // 開始
      { frame: 1, intensity: "hard" },    // 序盤
      { frame: 2, intensity: "hard" },    // クライマックス
      { frame: 3, intensity: "soft" },    // 余韻
      { frame: 4, intensity: "soft" }     // 終了
    ],
    
    // 中程度（3-5行）: 挿入main
    medium: [
      { frame: 0, intensity: "soft" },
      { frame: 1, intensity: "soft" },
      { frame: 2, intensity: "hard" },
      { frame: 3, intensity: "hard" },
      { frame: 4, intensity: "soft" },
      { frame: 5, intensity: "soft" }
    ],
    
    // 長い演出（4-6行以上）: 絶頂
    long: [
      { frame: 0, intensity: "soft" },
      { frame: 1, intensity: "soft" },
      { frame: 2, intensity: "hard" },
      { frame: 3, intensity: "hard" },
      { frame: 4, intensity: "hard" },
      { frame: 5, intensity: "soft" },
      { frame: 6, intensity: "soft" }
    ],
    
    // 激しい演出（ゴブリン用など）
    intense: [
      { frame: 0, intensity: "hard" },
      { frame: 1, intensity: "hard" },
      { frame: 2, intensity: "hard" },
      { frame: 3, intensity: "soft" }
    ],
    
    // 媚薬スライム専用：最初だけsoft、あとはhard継続
    // 用途: 媚薬効果で徐々に感度が上がり、最後まで激しく責められる
    aphrodisiacSlime: [
      { frame: 0, intensity: "hard" },    // 最初の接触（優しく）
      { frame: 1, intensity: "hard" },    // 媚薬が効き始める
      { frame: 2, intensity: "hard" },    // 激しく
      { frame: 3, intensity: "hard" },    // 継続
      { frame: 4, intensity: "hard" },    // 継続
      { frame: 5, intensity: "hard" },    // 継続
      { frame: 6, intensity: "hard" }     // 最後まで激しく
    ],
    
    // =============================================================================
    // ★差分少数モンスター用：hardのみパターン
    // =============================================================================
    // ※画像差分が少ないモンスター向けに、常にhardのみを使用
    // ※どんな長さの演出でも使える汎用パターン
    //
    // 【使用例】
    // attack: {
    //   breast: {
    //     soft: "attack_image",  // softもhardも同じ画像を指定（または片方だけ用意）
    //     hard: "attack_image",  // 同じ画像
    //     sequences: {
    //       danger: SEQUENCE_PATTERNS.hardonlyMedium  // ★常にhard画像を使用
    //     }
    //   }
    // }
    //
    // 【メリット】
    // - 画像枚数を削減できる（soft/hardで2枚 → 1枚でOK）
    // - 制作コスト削減（差分作業が不要）
    // - メモリ節約
    
    // 短い演出用（1-3行）: react等
    hardonlyShort: [
      { frame: 0, intensity: "hard" },
      { frame: 1, intensity: "hard" },
      { frame: 2, intensity: "hard" }
    ],
    
    // 中程度演出用（3-5行）: danger, climax, down_attack等
    hardonlyMedium: [
      { frame: 0, intensity: "hard" },
      { frame: 1, intensity: "hard" },
      { frame: 2, intensity: "hard" },
      { frame: 3, intensity: "hard" },
      { frame: 4, intensity: "hard" }
    ],
    
    // 長い演出用（5行以上）: orgasm等
    hardonlyLong: [
      { frame: 0, intensity: "hard" },
      { frame: 1, intensity: "hard" },
      { frame: 2, intensity: "hard" },
      { frame: 3, intensity: "hard" },
      { frame: 4, intensity: "hard" },
      { frame: 5, intensity: "hard" },
      { frame: 6, intensity: "hard" }
    ],
    
    // =============================================================================
    // ★挿入状態中のピストン演出（全モンスター共通）
    // =============================================================================
    // ※挿入状態でdanger/climax/down_attack/orgasmなどが発動した際のピストン演出
    
    // TYPE1: soft → hard → soft（緩急のあるピストン）
    // 用途: danger, orgasm など、緩急をつけたい演出
    pistoningType1: [
      { frame: 0, intensity: "soft" },    // ゆっくり始める
      { frame: 1, intensity: "hard" },
      { frame: 2, intensity: "soft" },    // 激しくピストン
      { frame: 3, intensity: "hard" },
      { frame: 4, intensity: "hard" }
    ],
    
    // TYPE2: 全てhard（激しいピストン）
    // 用途: climax, down_attack など、終始激しい演出
    pistoningType2: [
      { frame: 0, intensity: "hard" },    // 最初から激しく
      { frame: 1, intensity: "hard" },
      { frame: 2, intensity: "hard" },
      { frame: 4, intensity: "hard" },
      { frame: 5, intensity: "hard" },
      { frame: 6, intensity: "hard" }
    ],
    
    // =============================================================================
    // ★挿入イベント専用（全モンスター共通）
    // =============================================================================
    // ※モンスター固有の挿入シーケンスが定義されている場合はそちらが優先される
    // ※固有定義がない場合のみ、このデフォルト設定が使用される
    insertionCommon: {
      "insert:pre": [
        { frame: 0, intensity: "soft" },    // 抵抗・受け入れ（緩やか）
        { frame: 1, intensity: "soft" }
      ],
      "insert:main": [
        { frame: 0, intensity: "hard" },    // 挿入開始
        { frame: 1, intensity: "hard" },    // 序盤
        { frame: 2, intensity: "hard" },    // 中盤（激しく）
        { frame: 3, intensity: "hard" },    // クライマックス
        { frame: 4, intensity: "hard" },    // 余韻
        { frame: 5, intensity: "hard" }     // 終了
      ]
    },
    
    // 差分少数モンスター用：挿入イベントもhardのみ
    // ※soft差分がないモンスター向け（pre/mainの区別なく全てhard）
    //
    // 【使用例】
    // insert: {
    //   mouth: {
    //     soft: "insert_mouth",  // softもhardも同じ画像でOK
    //     hard: "insert_mouth",  // 同じ画像
    //     sequences: {
    //       ...SEQUENCE_PATTERNS.insertionHardOnly,  // ★pre/mainともにhard
    //       danger: SEQUENCE_PATTERNS.hardonlyMedium
    //     }
    //   }
    // }
    //
    // 【通常版との違い】
    // - insertionCommon: pre=soft(2frame), main=hard(6frame) → 計2種類の画像が必要
    // - insertionHardOnly: pre=hard(2frame), main=hard(6frame) → 1種類の画像でOK
    insertionHardOnly: {
      "insert:pre": [
        { frame: 0, intensity: "hard" },    // pre段階もhardで表現
        { frame: 1, intensity: "hard" }
      ],
      "insert:main": [
        { frame: 0, intensity: "hard" },
        { frame: 1, intensity: "hard" },
        { frame: 2, intensity: "hard" },
        { frame: 3, intensity: "hard" },
        { frame: 4, intensity: "hard" },
        { frame: 5, intensity: "hard" }
      ]
    }
  };

  // =============================================================================
  // デフォルトOverlay定義（全モンスター共通）
  // =============================================================================
  const DEFAULT_OVERLAY = {
    restrain: "restrain",
    attack: {
      breast: {
        soft: "attack_breast_soft",
        hard: "attack_breast_hard",
        layer: "overlay"
      },
      pussy: {
        soft: "attack_pussy_soft",
        hard: "attack_pussy_hard",
        layer: "overlay"
      }
    },
    insert: {
      pussy: {
        soft: "insert_pussy_soft",
        hard: "insert_pussy_hard",
        layer: "underOverlay"
      }
    },
    layer: "overlay"
  };

  window.OverlaySets = {
    slime: {
      // 挿入時の特殊挙動設定
      insertedBehavior: {
        layer: "underOverlay",         // ★挿入時のデフォルトレイヤー：衣装の下に描画（干渉する）
        alwaysShowBreast: true,        // 挿入時も常に胸オーバーレイを表示
        breastIntensityMode: "match",  // "match": 現在の強度に合わせる | "soft" | "hard"
        includeBreastSfx: true         // 挿入時に胸用SFXも追加
      },
      
      mapping: {
        // 常時表示する拘束エフェクト
        restrain: "restrain", // default_pose_overlay_restrain.png

      // 攻撃アクションごとの追加エフェクト（非挿入時）
      attack: {
        // 非挿入時の攻撃は主に胸を狙う
        breast: {
          soft: "attack_breast_soft",
          hard: "attack_breast_hard",
          layer: "overlay",  // 前面（衣服の上）
          
          // イベントタイプごとに異なるシーケンスパターンを使用
          sequences: {
            danger: SEQUENCE_PATTERNS.standard,      // 2-3行
            climax: SEQUENCE_PATTERNS.standard,      // 2-3行
            down_attack: SEQUENCE_PATTERNS.standard, // 2-3行
            orgasm: SEQUENCE_PATTERNS.long           // 4-6行以上
          }
        },
        
        // pussy/hipも一応定義（念のため）
        pussy: {
          soft: "attack_breast_soft",   // 非挿入時は胸スライムを使用
          hard: "attack_breast_hard",
          layer: "overlay",
          
          sequences: {
            danger: SEQUENCE_PATTERNS.standard,
            climax: SEQUENCE_PATTERNS.standard,
            down_attack: SEQUENCE_PATTERNS.standard,
            orgasm: SEQUENCE_PATTERNS.long
          }
        },
        hip: {
          soft: "attack_breast_soft",   // 非挿入時は胸スライムを使用
          hard: "attack_breast_hard",
          layer: "overlay",
          
          sequences: {
            danger: SEQUENCE_PATTERNS.standard,
            climax: SEQUENCE_PATTERNS.standard,
            down_attack: SEQUENCE_PATTERNS.standard,
            orgasm: SEQUENCE_PATTERNS.long
          }
        }
      },
      
      // 挿入中のエフェクト
      insert: {
        pussy: {
          soft: "insert_pussy_soft",
          hard: "insert_pussy_hard",
          layer: "underOverlay",
          
          sequences: {
            // 挿入イベント用
            ...SEQUENCE_PATTERNS.insertionCommon,
            
            // ★挿入状態中のエロ攻撃（ピストン）
            danger: SEQUENCE_PATTERNS.pistoningType1,      // 緩急あり
            climax: SEQUENCE_PATTERNS.pistoningType2,      // 激しい
            down_attack: SEQUENCE_PATTERNS.pistoningType2, // 激しい
            orgasm: SEQUENCE_PATTERNS.pistoningType1       // 緩急あり（余韻重視）
          }
        }
      },
      
      // グローバルデフォルト（部位で指定がない場合）
      layer: "overlay"
      }
      // sfx: DEFAULT_SFXを使用（上書きする場合はここに記述）
    },
    
    goblin: {
      // 挿入時の特殊挙動設定
      insertedBehavior: {
        layer: "overlay"  // ★挿入時のデフォルトレイヤー：衣装の上に描画（干渉しない）
      },
      
      mapping: {
        // ゴブリンは膣攻撃のみ（胸攻撃なし）
        attack: {
          pussy: {
            // 非挿入時: attack_pussy_soft/hard を使用（DEFAULT_OVERLAYと同じ）
            soft: "attack_pussy_soft",
            hard: "attack_pussy_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          }
        },
        insert: {
          pussy: {
            // 挿入時: ゴブリンは前面オーバーレイを使用（立ち絵の上に描画）
            soft: "insert_pussy_soft",
            hard: "insert_pussy_hard",
            layer: "overlay",
            
            sequences: {
              // 挿入イベント用
              ...SEQUENCE_PATTERNS.insertionCommon,
              
              // ★挿入状態中のエロ攻撃（ピストン）
              danger: SEQUENCE_PATTERNS.pistoningType1,      // 緩急あり
              climax: SEQUENCE_PATTERNS.pistoningType1,      // 激しい
              down_attack: SEQUENCE_PATTERNS.pistoningType1, // 激しい
              orgasm: SEQUENCE_PATTERNS.pistoningType1       
            }
          }
        }
      }
      // sfx: DEFAULT_SFXを使用（胸攻撃がないのでbreastカテゴリは不使用）
    },
    
    tentacle: {
      // 挿入時の特殊挙動設定
      insertedBehavior: {
        layer: "underOverlay"  // ★挿入時のデフォルトレイヤー：衣装の下に描画（干渉する）
      },
      
      mapping: {
        restrain: "restrain",
        // 触手は膣攻撃のみ（胸攻撃なし）
        attack: {
          pussy: {
            soft: "tentacle_soft",
            hard: "tentacle_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          }
        },
        insert: {
          pussy: {
            soft: "tentacle_insert_soft",
            hard: "tentacle_insert_hard",
            layer: "underOverlay",
            
            sequences: {
              // 挿入イベント用
              ...SEQUENCE_PATTERNS.insertionCommon,
              
              // ★挿入状態中のエロ攻撃（ピストン）
              danger: SEQUENCE_PATTERNS.pistoningType2,      // 緩急あり
              climax: SEQUENCE_PATTERNS.pistoningType2,      // 激しい
              down_attack: SEQUENCE_PATTERNS.pistoningType2, // 激しい
              orgasm: SEQUENCE_PATTERNS.pistoningType2       // 緩急あり（余韻重視）
            }
          }
        }
      }
      // sfx: DEFAULT_SFXを使用（胸攻撃がないのでbreastカテゴリは不使用）
    },
    
    tentacle_hebe: {
      // 挿入時の特殊挙動設定
      insertedBehavior: {
        layer: "underOverlay"  // ★挿入時のデフォルトレイヤー：衣装の下に描画（干渉する）
      },
      
      mapping: {
        restrain: "restrain",
        // ヘーベテンタクル：挿入時のみエロ攻撃可能（非挿入時のattackオーバーレイは使用されない）
        attack: {
          pussy: {
            soft: "tentacle_soft",
            hard: "tentacle_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          }
        },
        insert: {
          pussy: {
            soft: "tentacle_insert_soft",
            hard: "tentacle_insert_hard",
            layer: "underOverlay",
            
            sequences: {
              // 挿入イベント用
              ...SEQUENCE_PATTERNS.insertionCommon,
              
              // ★挿入状態中のエロ攻撃（ピストン）
              danger: SEQUENCE_PATTERNS.pistoningType2,      // 激しい
              climax: SEQUENCE_PATTERNS.pistoningType2,      // 激しい
              down_attack: SEQUENCE_PATTERNS.pistoningType2, // 激しい
              orgasm: SEQUENCE_PATTERNS.pistoningType2       // 激しい
            }
          }
        }
      }
      // sfx: DEFAULT_SFXを使用（胸攻撃がないのでbreastカテゴリは不使用）
    },
    
    breastTentacle: {
      // ★挿入時の特殊挙動設定
      insertedBehavior: {
        layer: "underOverlay",         // ★挿入時のデフォルトレイヤー：衣装の下に描画（干渉する）
        alwaysShowBreast: true,        // 挿入時も常に胸オーバーレイを表示
        breastIntensityMode: "match",  // "match": 現在の強度に合わせる | "soft" | "hard"
        includeBreastSfx: true         // 挿入時に胸用SFXも追加
      },
      
      mapping: {
        restrain: "restrain",
        // ルストテンタケルは胸攻撃がメイン
        attack: {
          breast: {
            soft: "attack_breast_soft",
            hard: "attack_breast_hard",
            layer: "overlay",
            
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          },
          pussy: {
            soft: "attack_breast_soft",   // ルストテンタケルは胸攻撃を使用
            hard: "attack_breast_hard",
            layer: "overlay",
            
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          }
        },
        insert: {
          pussy: {
            soft: "insert_pussy_soft",
            hard: "insert_pussy_hard",
            layer: "underOverlay",
            sequences: {
              ...SEQUENCE_PATTERNS.insertionCommon,
              danger: SEQUENCE_PATTERNS.pistoningType2,
              climax: SEQUENCE_PATTERNS.pistoningType2,
              down_attack: SEQUENCE_PATTERNS.pistoningType2,
              orgasm: SEQUENCE_PATTERNS.pistoningType2
            }
          }
        }
      }
      // sfx: DEFAULT_SFXを使用（breastカテゴリを使用）
    },
    
    aphrodisiacSlime: {
      // ★ 非挿入時の特殊挙動：胸のSFXを追加表示
      nonInsertedBehavior: {
        alwaysShowBreastSfx: true,      // 胸のSFXを追加表示
        breastSfxIntensityMode: "match" // メインと同じ強度
      },
      
      // ★ 挿入時の特殊挙動：非挿入攻撃を継続 + 胸SFX + 膣SFXを追加
      insertedBehavior: {
        layer: "overlay",               // ★挿入時のデフォルトレイヤー：衣装の上に描画（口挿入なので干渉しない）
        alwaysShowFullbodyAttack: true, // 非挿入エフェクト（全身攻撃）を継続表示
        fullbodyIntensityMode: "match", // メインと同じ強度
        includeBreastSfx: true,         // 胸のSFXを追加
        includePussySfx: true           // 膣のSFXも追加（口+胸+膣の3部位）
      },
      
      mapping: {
        restrain: "restrain",
        
        attack: {
          // 非挿入時：胸と膣を同時攻撃（1枚の画像で表現）
          // ※画像差分が少ない場合はhardonlyパターンも使用可能
          breast: {
            soft: "slime_fullbody_soft",
            hard: "slime_fullbody_hard",
            layer: "overlay",
            sequences: {
              react: SEQUENCE_PATTERNS.hardonlyShort,         // ★hardonlyパターン使用例
              danger: SEQUENCE_PATTERNS.hardonlyMedium,       // ★hardonlyパターン使用例
              climax: SEQUENCE_PATTERNS.hardonlyMedium,       // ★hardonlyパターン使用例
              down_attack: SEQUENCE_PATTERNS.hardonlyMedium,  // ★hardonlyパターン使用例
              orgasm: SEQUENCE_PATTERNS.hardonlyLong          // ★hardonlyパターン使用例
            }
          },
          
          pussy: {
            soft: "slime_fullbody_soft",
            hard: "slime_fullbody_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.hardonlyMedium,       // ★hardonlyパターン使用例
              climax: SEQUENCE_PATTERNS.hardonlyMedium,       // ★hardonlyパターン使用例
              down_attack: SEQUENCE_PATTERNS.hardonlyMedium,  // ★hardonlyパターン使用例
              orgasm: SEQUENCE_PATTERNS.hardonlyLong          // ★hardonlyパターン使用例
            }
          }
        },
        
        insert: {
          // 挿入時：口挿入がメイン（pre/main形式）
          // ※差分が少ない場合はinsertionHardOnlyを使用
          mouth: {
            soft: "insert_mouth_pre",   // 挿入前・受け入れ段階（差分なければhardと同じ画像でOK）
            hard: "insert_mouth_main",  // 挿入完了・攻撃中
            layer: "overlay",
            sequences: {
              // ★差分少ない場合の使用例：
              ...SEQUENCE_PATTERNS.insertionCommon,  // insert:pre, insert:mainともにhard
              // ★挿入後の攻撃もhardonlyで統一可能
              danger: SEQUENCE_PATTERNS.hardonlyMedium,
              climax: SEQUENCE_PATTERNS.hardonlyLong,
              down_attack: SEQUENCE_PATTERNS.hardonlyLong,
              orgasm: SEQUENCE_PATTERNS.hardonlyLong
            }
          }
        },
        
        layer: "overlay"
      },
      
      // ★ 媚薬スライム専用SFX（すべてhardで出力）
      sfx: {
        // 口挿入用（inserted カテゴリ）
        inserted: {
          soft: ["default_pose_overlay_ズポ1-6"],  // 念のため1つ定義
          hard: [
            "default_pose_overlay_ズポ1-6",
            "default_pose_overlay_ズプッ1-6",
            "default_pose_overlay_ヌポッ1-6",
            "default_pose_overlay_ヌプッ1-6",
            "default_pose_overlay_ずぶ3-6",
            "default_pose_overlay_ズプ2-6"
          ]
        },
        
        // 胸用（breast カテゴリ）
        breast: {
          soft: ["default_pose_overlay_ちゅぱ1-6"],  // 念のため1つ定義
          hard: [
            "default_pose_overlay_むぎゅ1-6",
            "default_pose_overlay_ちゅぱ1-6"
          ]
        },
        
        // 膣用（other カテゴリ）
        other: {
          soft: ["default_pose_overlay_ぬちょっ1-6"],  // 念のため1つ定義
          hard: [
            "default_pose_overlay_ぬちょっ1-6",
            "default_pose_overlay_ぬちゃっ1-6",
            "default_pose_overlay_ズン1-6",
            "default_pose_overlay_ぐちゅっ1-6",
            "default_pose_overlay_ぐちゃ1-6"
          ]
        }
      }
    },
    
    reider: {
      // ★挿入時の特殊挙動設定（slimeと同様）
      insertedBehavior: {
        layer: "underOverlay",         // ★挿入時のデフォルトレイヤー：衣装の下に描画（干渉する）
        alwaysShowBreast: true,        // 挿入時も常に胸オーバーレイを表示
        breastIntensityMode: "match",  // "match": 現在の強度に合わせる | "soft" | "hard"
        includeBreastSfx: true         // 挿入時に胸用SFXも追加
      },
      
      mapping: {
        restrain: "restrain",
        
        // 非挿入時の攻撃
        attack: {
          breast: {
            soft: "attack_breast_soft",
            hard: "attack_breast_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          },
          
          pussy: {
            soft: "attack_pussy_soft",
            hard: "attack_pussy_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          }
        },
        
        // 挿入中のエフェクト
        insert: {
          pussy: {
            soft: "insert_pussy_soft",
            hard: "insert_pussy_hard",
            layer: "overlay",
            sequences: {
              // 挿入イベント用
              ...SEQUENCE_PATTERNS.insertionCommon,
              
              // ★挿入状態中のエロ攻撃（ピストン）
              danger: SEQUENCE_PATTERNS.pistoningType1,
              climax: SEQUENCE_PATTERNS.pistoningType2,
              down_attack: SEQUENCE_PATTERNS.pistoningType2,
              orgasm: SEQUENCE_PATTERNS.pistoningType1
            }
          }
        },
        
        layer: "overlay"
      }
      // sfx: DEFAULT_SFXを使用（上書きする場合はここに記述）
    },
    
    hypnoticGhost: {
      // 催眠ゴースト：stage1は強制オナニー（胸のみ）、stage2以降はゴーストも参加（胸+膣）
      // stage2以降で膣攻撃のSFXを追加表示するための特殊設定
      
      // ★ 視覚エフェクトのスキップ設定（催眠は精神攻撃のため視覚エフェクト不要）
      // ※将来的に他の特殊モンスター（精神攻撃、幻覚、呪い系など）でも使用可能
      skipOverlays: [
        "restrain",         // 拘束オーバーレイ
        "attack_breast",    // 胸攻撃エフェクト（前方一致で _soft/_hard も含む）
        "attack_pussy",     // 膣攻撃エフェクト（前方一致で _soft/_hard も含む）
        "insert_pussy"      // 挿入エフェクト（念のため）
      ],
      
      // 挿入時の特殊挙動設定（念のため定義、催眠ゴーストは挿入しない想定）
      insertedBehavior: {
        layer: "overlay"  // ★デフォルト：衣装の上（催眠は物理的干渉なし）
      },
      
      multiPartBehavior: {
        enableFromStage: 2,           // stage2以降で複数部位攻撃を有効化
        alwaysShowPussy: false,       // stage1では膣攻撃なし（胸のみ）
        alwaysShowPussyFromStage2: true,  // stage2以降は膣も同時攻撃
        pussyIntensityMode: "match",  // 膣の強度を現在の攻撃強度に合わせる
        includePussySfx: true         // 膣用SFXも追加表示
      },
      
      mapping: {
        restrain: "restrain",
        attack: {
          // stage1: 強制オナニー（pussy攻撃のみ）
          pussy: {
            soft: "attack_pussy_soft",
            hard: "attack_pussy_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          },
          // stage2以降: ゴーストも胸を責める
          breast: {
            soft: "attack_breast_soft",
            hard: "attack_breast_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          }
        },
        // 挿入はなし（念のため定義）
        insert: {
          pussy: {
            soft: "insert_pussy_soft",
            hard: "insert_pussy_hard",
            layer: "underOverlay",
            sequences: {
              ...SEQUENCE_PATTERNS.insertionCommon,
              danger: SEQUENCE_PATTERNS.pistoningType1,
              climax: SEQUENCE_PATTERNS.pistoningType2,
              down_attack: SEQUENCE_PATTERNS.pistoningType2,
              orgasm: SEQUENCE_PATTERNS.pistoningType1
            }
          }
        },
        layer: "overlay"
      }
      // sfx: DEFAULT_SFXを使用
    },
    
    reiderBoss: {
      // ★レイダーの首領：非挿入時は胸責め、挿入時は通常ピストン
      insertedBehavior: {
        layer: "underOverlay",         // 挿入時のデフォルトレイヤー：衣装の下に描画
        alwaysShowBreast: true,        // 挿入時も常に胸オーバーレイを表示
        breastIntensityMode: "match",  // 現在の強度に合わせる
        includeBreastSfx: true         // 挿入時に胸用SFXも追加
      },
      
      mapping: {
        restrain: "restrain",
        
        // 非挿入時の攻撃：胸責めがメイン
        attack: {
          breast: {
            soft: "attack_breast_soft",
            hard: "attack_breast_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          },
          
          // pussyもbreastと同じ画像を使用（胸責めメイン）
          pussy: {
            soft: "attack_breast_soft",
            hard: "attack_breast_hard",
            layer: "overlay",
            sequences: {
              danger: SEQUENCE_PATTERNS.standard,
              climax: SEQUENCE_PATTERNS.standard,
              down_attack: SEQUENCE_PATTERNS.standard,
              orgasm: SEQUENCE_PATTERNS.long
            }
          }
        },
        
        // 挿入中：通常ピストン
        insert: {
          pussy: {
            soft: "insert_pussy_soft",
            hard: "insert_pussy_hard",
            layer: "underOverlay",
            sequences: {
              // 挿入イベント用
              ...SEQUENCE_PATTERNS.insertionCommon,
              
              // 挿入状態中のエロ攻撃（通常ピストン）
              danger: SEQUENCE_PATTERNS.pistoningType1,      // 緩急あり
              climax: SEQUENCE_PATTERNS.pistoningType2,      // 激しい
              down_attack: SEQUENCE_PATTERNS.pistoningType2, // 激しい
              orgasm: SEQUENCE_PATTERNS.pistoningType1       // 緩急あり（余韻重視）
            }
          }
        },
        
        layer: "overlay"
      }
      // sfx: DEFAULT_SFXを使用
    }
  };
  
  // =============================================================================
  // パフォーマンス最適化: マージ結果のキャッシュ
  // =============================================================================
  
  /**
   * 深いマージ（オブジェクトを再帰的にマージ）
   * ※初期化時に1回だけ実行してキャッシュするため、パフォーマンスへの影響は最小限
   */
  function deepMerge(target, source) {
    if (!source) return target;
    const result = { ...target };
    for (const key in source) {
      if (source[key] && typeof source[key] === 'object' && !Array.isArray(source[key])) {
        result[key] = deepMerge(result[key] || {}, source[key]);
      } else {
        result[key] = source[key];
      }
    }
    return result;
  }
  
  // 初期化時に全モンスターのマージ結果をキャッシュ
  window._mergedOverlaySets = {};
  
  for (const enemyKey in window.OverlaySets) {
    const enemyMapping = window.OverlaySets[enemyKey]?.mapping;
    
    if (enemyMapping) {
      // 敵固有のマッピングがある場合: デフォルトとマージ
      window._mergedOverlaySets[enemyKey] = deepMerge(DEFAULT_OVERLAY, enemyMapping);
      console.log(`[VisualOverlayData] Cached merged mapping for: ${enemyKey}`);
    } else {
      // 敵固有のマッピングがない場合: デフォルトをそのまま使用
      window._mergedOverlaySets[enemyKey] = DEFAULT_OVERLAY;
      console.log(`[VisualOverlayData] Using DEFAULT_OVERLAY for: ${enemyKey}`);
    }
    
    // 設定検証: insertedBehaviorの整合性チェック
    const behavior = window.OverlaySets[enemyKey]?.insertedBehavior;
    if (behavior) {
      if (behavior.includeBreastSfx && !behavior.alwaysShowBreast) {
        console.warn(
          `[VisualOverlayData] Inconsistent config for "${enemyKey}": ` +
          `includeBreastSfx=true but alwaysShowBreast=false. ` +
          `Breast SFX will play without visual overlay.`
        );
      }
      
      // breastIntensityModeの値検証
      const validModes = ["match", "soft", "hard"];
      if (behavior.breastIntensityMode && !validModes.includes(behavior.breastIntensityMode)) {
        console.warn(
          `[VisualOverlayData] Invalid breastIntensityMode for "${enemyKey}": "${behavior.breastIntensityMode}". ` +
          `Valid values are: ${validModes.join(", ")}. Defaulting to "match".`
        );
      }
    }
  }
  
  // デフォルトSFX・Overlay・シーケンスパターンをグローバルに公開（デバッグ・フォールバック用）
  window.DEFAULT_SFX = DEFAULT_SFX;
  window.DEFAULT_OVERLAY = DEFAULT_OVERLAY;
  window.SEQUENCE_PATTERNS = SEQUENCE_PATTERNS;
  
  console.log("[VisualOverlayData] OverlaySets defined:", window.OverlaySets);
  console.log("[VisualOverlayData] DEFAULT_SFX defined:", window.DEFAULT_SFX);
  console.log("[VisualOverlayData] DEFAULT_OVERLAY defined:", window.DEFAULT_OVERLAY);
  console.log("[VisualOverlayData] SEQUENCE_PATTERNS defined:", window.SEQUENCE_PATTERNS);
  console.log("[VisualOverlayData] Merged overlay sets cached:", Object.keys(window._mergedOverlaySets));
})();
