# ビジュアルオーバーレイシステム ガイド

このドキュメントでは、VisualOverlayData.js、OverlayBuilder.js、VisualAutoFill.js を使用したビジュアルオーバーレイとSFXシステムの使い方を説明します。

---

## 📋 目次

1. [概要](#概要)
2. [挿入シーケンスの共通定義](#挿入シーケンスの共通定義)
3. [ピストンパターン（TYPE1/TYPE2）](#ピストンパターンtype1type2)
4. [SFX抑制機能](#sfx抑制機能)
5. [使用例](#使用例)
6. [カスタマイズ方法](#カスタマイズ方法)

---

## 概要

### システム構成

```
VisualOverlayData.js
  ├── SEQUENCE_PATTERNS (シーケンスパターン定義)
  ├── DEFAULT_SFX (デフォルトSFX定義)
  └── OverlaySets (モンスター別設定)
       └── mapping (オーバーレイマッピング)
            ├── attack (非挿入時の攻撃)
            └── insert (挿入時のオーバーレイ)

OverlayBuilder.js
  └── buildOverlaysForLine() (オーバーレイ自動構築)
       └── getBubbleOverlaysFromContext() (SFX選択 + 抑制チェック)

VisualAutoFill.js
  └── autoFillDialogueSequence() (dialogueSequence自動補完)
       └── 行単位のSFX抑制対応
```

---

## 挿入シーケンスの共通定義

### 背景

以前は各モンスター（slime, goblin, tentacle）で挿入シーケンスを個別に定義していましたが、内容が重複していました。

**改善点:**
- 挿入シーケンスを共通パターン `insertionCommon` として定義
- 全モンスターで共通パターンを参照（DRY原則）
- モンスター固有のシーケンスが必要な場合は個別定義で上書き可能

### 共通挿入シーケンス定義

```javascript
// VisualOverlayData.js より抜粋

const SEQUENCE_PATTERNS = {
  // ... 既存のパターン ...
  
  // 挿入イベント専用（全モンスター共通）
  insertionCommon: {
    "insert:pre": [
      { frame: 0, intensity: "soft" },    // 抵抗・受け入れ（緩やか）
      { frame: 1, intensity: "soft" }
    ],
    "insert:main": [
      { frame: 0, intensity: "soft" },    // 挿入開始
      { frame: 1, intensity: "soft" },    // 序盤
      { frame: 2, intensity: "hard" },    // 中盤（激しく）
      { frame: 3, intensity: "hard" },    // クライマックス
      { frame: 4, intensity: "soft" },    // 余韻
      { frame: 5, intensity: "soft" }     // 終了
    ]
  }
};
```

### 使い方

#### パターン1: 共通定義を使用（推奨）

```javascript
window.OverlaySets = {
  slime: {
    mapping: {
      insert: {
        pussy: {
          soft: "insert_pussy_soft",
          hard: "insert_pussy_hard",
          layer: "underOverlay",
          
          // ★共通挿入シーケンスを使用
          sequences: SEQUENCE_PATTERNS.insertionCommon
        }
      }
    }
  }
};
```

#### パターン2: モンスター固有の定義で上書き

特別なモンスターで独自のシーケンスが必要な場合：

```javascript
window.OverlaySets = {
  specialMonster: {
    mapping: {
      insert: {
        pussy: {
          soft: "insert_pussy_soft",
          hard: "insert_pussy_hard",
          layer: "underOverlay",
          
          // ★固有の挿入シーケンスで上書き
          sequences: {
            "insert:pre": [
              { frame: 0, intensity: "hard" },  // 激しい開始
              { frame: 1, intensity: "hard" }
            ],
            "insert:main": [
              { frame: 0, intensity: "hard" },
              { frame: 1, intensity: "hard" },
              { frame: 2, intensity: "hard" },
              { frame: 3, intensity: "soft" }
            ]
          }
        }
      }
    }
  }
};
```

**優先順位:** モンスター固有定義 > 共通定義（insertionCommon）

---

## ピストンパターン（TYPE1/TYPE2）

### 背景

挿入状態中にエロ攻撃（danger/climax/down_attack/orgasm）が発動した際、ピストン演出を表現するための専用パターンです。

挿入イベント（`insert:pre/main`）とは別に、挿入状態を維持しながら追加でエロ攻撃を受ける際の演出を定義します。

### 2種類のピストンパターン

#### TYPE1: soft → hard → soft（緩急のあるピストン）

```javascript
pistoningType1: [
  { frame: 0, intensity: "soft" },    // ゆっくり始める
  { frame: 1, intensity: "soft" },
  { frame: 2, intensity: "hard" },    // 激しくピストン
  { frame: 3, intensity: "hard" },
  { frame: 4, intensity: "hard" },
  { frame: 5, intensity: "soft" },    // 余韻
  { frame: 6, intensity: "soft" }
]
```

**特徴:**
- 緩やかに始まり、中盤で激しくなり、最後は余韻を残す
- 自然な流れのピストン演出
- 演出に緩急をつけたい場合に使用

**用途:**
- `danger` - 通常のピストン攻撃
- `orgasm` - 絶頂時（余韻重視）

---

#### TYPE2: 全てhard（激しいピストン）

```javascript
pistoningType2: [
  { frame: 0, intensity: "hard" },    // 最初から激しく
  { frame: 1, intensity: "hard" },
  { frame: 2, intensity: "hard" },
  { frame: 3, intensity: "hard" },
  { frame: 4, intensity: "hard" },
  { frame: 5, intensity: "hard" },
  { frame: 6, intensity: "hard" }
]
```

**特徴:**
- 最初から最後まで激しいピストン
- 容赦ない攻めの演出
- 高まった状態での攻撃に使用

**用途:**
- `climax` - クライマックス時の激しいピストン
- `down_attack` - ダウン時の容赦ない攻め

---

### 実装例

全モンスター共通で以下のように適用されています：

```javascript
window.OverlaySets = {
  slime: {
    mapping: {
      insert: {
        pussy: {
          soft: "insert_pussy_soft",
          hard: "insert_pussy_hard",
          layer: "underOverlay",
          
          sequences: {
            // 挿入イベント用
            ...SEQUENCE_PATTERNS.insertionCommon,
            
            // ★挿入状態中のエロ攻撃（ピストン）
            danger: SEQUENCE_PATTERNS.pistoningType1,      // 緩急あり
            climax: SEQUENCE_PATTERNS.pistoningType2,      // 激しい
            down_attack: SEQUENCE_PATTERNS.pistoningType2, // 激しい
            orgasm: SEQUENCE_PATTERNS.pistoningType1       // 緩急あり（余韻重視）
          }
        }
      }
    }
  }
};
```

### イベントタイプ別の動作

| イベント | パターン | 演出イメージ |
|---------|---------|------------|
| **insert:pre** | insertionCommon | 挿入される瞬間の反応（2フレーム） |
| **insert:main** | insertionCommon | 挿入シーン本番（6フレーム） |
| **danger（挿入中）** | pistoningType1 | 緩やかに始まる通常ピストン |
| **climax（挿入中）** | pistoningType2 | 激しいピストン |
| **down_attack（挿入中）** | pistoningType2 | 容赦ないピストン |
| **orgasm（挿入中）** | pistoningType1 | 絶頂の余韻を含むピストン |

### カスタマイズ

特定のモンスターで異なるパターンを使いたい場合：

```javascript
window.OverlaySets = {
  specialMonster: {
    mapping: {
      insert: {
        pussy: {
          soft: "insert_pussy_soft",
          hard: "insert_pussy_hard",
          layer: "underOverlay",
          
          sequences: {
            ...SEQUENCE_PATTERNS.insertionCommon,
            
            // ★このモンスターだけ全てTYPE2（激しい）
            danger: SEQUENCE_PATTERNS.pistoningType2,
            climax: SEQUENCE_PATTERNS.pistoningType2,
            down_attack: SEQUENCE_PATTERNS.pistoningType2,
            orgasm: SEQUENCE_PATTERNS.pistoningType2
          }
        }
      }
    }
  }
};
```

---

## SFX抑制機能

### 3段階の抑制レベル

システムは3段階のSFX抑制をサポートしています：

| レベル | 設定方法 | 説明 | 優先度 |
|--------|---------|------|--------|
| **1. グローバル抑制** | `context.suppressSfx = true` | イベント全体でSFXを完全に抑制 | 最高 |
| **2. カテゴリ抑制** | `context.suppressSfxCategories = ["breast"]` | 特定カテゴリのみ抑制 | 中 |
| **3. 行単位抑制** | `line.suppressSfx = true` | 特定の行のみSFX抑制 | 低 |

### 実装箇所

#### OverlayBuilder.js: `getBubbleOverlaysFromContext()`

```javascript
function getBubbleOverlaysFromContext(context, intensity, forcedCategory = null) {
  // 1. グローバル抑制チェック
  if (context.suppressSfx === true) {
    console.log(`[OverlayBuilder-SFX] Skipped: global suppressSfx flag enabled`);
    return null;
  }
  
  // 2. 挿入pre時の抑制（既存の動作）
  if (eventType === "insert" && phase === "pre") {
    console.log(`[OverlayBuilder-SFX] Skipped: insert:pre phase (default behavior)`);
    return null;
  }
  
  // カテゴリ決定...
  
  // 3. カテゴリ別抑制チェック
  if (Array.isArray(context.suppressSfxCategories) && 
      context.suppressSfxCategories.includes(categoryName)) {
    console.log(`[OverlayBuilder-SFX] Skipped: category "${categoryName}" is in suppressSfxCategories`);
    return null;
  }
  
  // SFX選択処理...
}
```

#### VisualAutoFill.js: `autoFillDialogueSequence()`

```javascript
// 行単位のSFX抑制チェック
const shouldSuppressSfx = line.suppressSfx === true || context.suppressSfx === true;

if (!hasBubble && !shouldSuppressSfx) {
  // SFX追加処理...
}
```

---

## 使用例

### 例1: 通常の使用（SFX抑制なし）

```javascript
const context = {
  enemyKey: "slime",
  eventType: "danger",
  targetPart: "breast",
  isInserted: false,
  isRestrained: true,
  stage: "stage2"
};

// 自動的にSFXが追加される
const result = window.VisualAutoFill.autoFillDialogueSequence(dialogueSequence, context);
```

### 例2: グローバルSFX抑制（イベント全体でSFXなし）

```javascript
const context = {
  enemyKey: "slime",
  eventType: "danger",
  targetPart: "breast",
  isInserted: false,
  isRestrained: true,
  stage: "stage2",
  suppressSfx: true  // ★全SFXを抑制
};
```

**用途:** 静かな演出、緊張感のあるシーンなど

### 例3: カテゴリ別SFX抑制（特定カテゴリのみ抑制）

```javascript
const context = {
  enemyKey: "slime",
  eventType: "insert",
  phase: "main",
  targetPart: "pussy",
  isInserted: true,
  isRestrained: true,
  stage: "stage2",
  suppressSfxCategories: ["breast"]  // ★胸SFXのみ抑制（挿入SFXは表示）
};
```

**用途:** 
- スライムの挿入時に胸SFXだけ表示したくない場合
- 特定部位の音を消したい場合

**利用可能なカテゴリ:**
- `"inserted"` - 挿入時のSFX
- `"breast"` - 胸への愛撫SFX
- `"other"` - その他のSFX（膣愛撫、絶頂など）

### 例4: 行単位のSFX抑制（特定の台詞だけ抑制）

```json
{
  "eventKey": "slime_danger_1",
  "context": {
    "enemyKey": "slime",
    "eventType": "danger",
    "targetPart": "breast"
  },
  "dialogueSequence": [
    { "text": "んっ..." },
    { 
      "text": "やめ...っ", 
      "suppressSfx": true  
    },
    { "text": "あぁっ...!" }
  ]
}
```

**用途:**
- 台詞に集中させたい行
- 演出上、一時的に静かにしたい場面

### 例5: 挿入シーケンスの使用

挿入イベントでは自動的に共通シーケンス `insertionCommon` が使用されます：

```javascript
const context = {
  enemyKey: "goblin",
  eventType: "insert",
  phase: "main",        // "pre" または "main"
  targetPart: "pussy",
  isInserted: true,
  isRestrained: true,
  stage: "stage2"
};

// insert:main シーケンス（6フレーム: soft → soft → hard → hard → soft → soft）が適用される
const result = window.VisualAutoFill.autoFillDialogueSequence(dialogueSequence, context);
```

---

## カスタマイズ方法

### 新しいモンスターの追加

```javascript
window.OverlaySets.newMonster = {
  // 挿入時の特殊挙動（オプション）
  insertedBehavior: {
    alwaysShowBreast: false,        // 挿入時に胸オーバーレイを表示するか
    breastIntensityMode: "match",   // "match" | "soft" | "hard"
    includeBreastSfx: false         // 挿入時に胸SFXも追加するか
  },
  
  mapping: {
    // 拘束エフェクト
    restrain: "restrain",
    
    // 非挿入時の攻撃
    attack: {
      pussy: {
        soft: "attack_pussy_soft",
        hard: "attack_pussy_hard",
        layer: "overlay",
        sequences: {
          danger: SEQUENCE_PATTERNS.standard,
          orgasm: SEQUENCE_PATTERNS.long
        }
      }
    },
    
    // 挿入時
    insert: {
      pussy: {
        soft: "insert_pussy_soft",
        hard: "insert_pussy_hard",
        layer: "underOverlay",
        
        // ★共通シーケンスを使用（推奨）
        sequences: SEQUENCE_PATTERNS.insertionCommon
      }
    }
  }
};
```

### 新しいSFXカテゴリの追加

```javascript
// VisualOverlayData.js
const DEFAULT_SFX = {
  inserted: { /* ... */ },
  breast: { /* ... */ },
  other: { /* ... */ },
  
  // ★新しいカテゴリ追加
  anal: {
    soft: [
      "default_pose_overlay_くちゅ1-6",
      "default_pose_overlay_ぬぷ1-6"
    ],
    hard: [
      "default_pose_overlay_ずぷ1-6",
      "default_pose_overlay_ぐちゅ1-6"
    ]
  }
};
```

```javascript
// OverlayBuilder.js の getBubbleOverlaysFromContext に分岐追加
if (targetPart === "anal") {
  categoryMap = sfxMap.anal;
  categoryName = "anal";
}
```

### カスタムシーケンスパターンの作成

```javascript
// VisualOverlayData.js
const SEQUENCE_PATTERNS = {
  // ... 既存のパターン ...
  
  // カスタムパターン追加
  gentle: [
    { frame: 0, intensity: "soft" },
    { frame: 1, intensity: "soft" },
    { frame: 2, intensity: "soft" },
    { frame: 3, intensity: "soft" }
  ],
  
  extreme: [
    { frame: 0, intensity: "hard" },
    { frame: 1, intensity: "hard" },
    { frame: 2, intensity: "hard" },
    { frame: 3, intensity: "hard" },
    { frame: 4, intensity: "hard" }
  ]
};

// モンスター定義で使用
window.OverlaySets.gentleMonster = {
  mapping: {
    attack: {
      pussy: {
        soft: "attack_pussy_soft",
        hard: "attack_pussy_hard",
        layer: "overlay",
        sequences: {
          danger: SEQUENCE_PATTERNS.gentle  // ★カスタムパターン使用
        }
      }
    }
  }
};
```

---

## デバッグ

### コンソールログ

システムは詳細なログを出力します：

```
[OverlayBuilder-SFX] Skipped: global suppressSfx flag enabled
[OverlayBuilder-SFX] Skipped: insert:pre phase (default behavior)
[OverlayBuilder-SFX] Skipped: category "breast" is in suppressSfxCategories
[OverlayBuilder-SFX] Using forced category: breast
[OverlayBuilder-SFX] Selected: category="inserted", intensity="hard", key="default_pose_overlay_ズン1-6"
[OverlayBuilder-Sequence] Resolved by "insert:main"
[OverlayBuilder-Sequence] Frame 3/6 (progress=0.50) → pattern[2] intensity=hard
```

### よくある問題

#### Q: SFXが表示されない

**確認事項:**
1. `context.suppressSfx` が `true` になっていないか
2. `context.suppressSfxCategories` に該当カテゴリが含まれていないか
3. `line.suppressSfx` が `true` になっていないか
4. `eventType === "insert" && phase === "pre"` ではないか（デフォルトで非表示）

#### Q: 挿入シーケンスが適用されない

**確認事項:**
1. `eventType` が `"insert"` になっているか
2. `phase` が `"pre"` または `"main"` になっているか
3. `frameIndex` と `totalFrames` が正しく渡されているか

#### Q: モンスター固有のシーケンスが適用されない

**確認事項:**
1. `window.OverlaySets[enemyKey].mapping.insert.pussy.sequences` が正しく定義されているか
2. 定義が `insertionCommon` を上書きしているか（オブジェクト代入になっているか）

---

## まとめ

### 設計原則

1. **DRY原則**: 共通定義を活用し、重複を避ける
2. **柔軟性**: モンスター固有の定義で上書き可能
3. **段階的制御**: 3段階のSFX抑制レベルで細かい制御が可能
4. **拡張性**: 新しいモンスター、SFXカテゴリ、シーケンスパターンの追加が容易

### 変更履歴

| 日付 | 変更内容 |
|------|---------|
| 2025-11-30 | 共通挿入シーケンス追加、SFX抑制機能実装 |
| 2025-11-30 | ピストンパターン（TYPE1/TYPE2）追加 |

---

## 参考

- `js/plugins/VisualOverlayData.js` - データ定義
- `js/plugins/OverlayBuilder.js` - オーバーレイ構築ロジック
- `js/plugins/VisualAutoFill.js` - 統合API

