import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# ファイルパスとprofileNameのマッピング
meta_additions = {
    'dataEx/cutinProfiles/slime_restrained_low.json': 'slime_restrained_low',
    'dataEx/introProfiles/insert/slime.json': 'slime_restrained_insert_low',
    'dataEx/introProfiles/insert/slime_restrained_high.json': 'slime_restrained_insert_high',
    'dataEx/orgasmDetailProfiles/goblin_restrained_insert_high.json': 'goblin_restrained_insert_high_orgasm',
    'dataEx/orgasmDetailProfiles/slime_restrained_high.json': 'slime_restrained_high_orgasm',
    'dataEx/orgasmDetailProfiles/slime_restrained_insert_high.json': 'slime_restrained_insert_high_orgasm',
    'dataEx/poseProfiles/slime_restrained_insert_high.json': 'slime_restrained_insert_high',
    'dataEx/poseProfiles/slime_restrained_insert_low.json': 'slime_restrained_insert_low',
    'dataEx/poseProfiles/slime_restrained_low.json': 'slime_restrained_low',
    'dataEx/poseProfiles/堕落度high/スライム堕落度high/挿入時通常エロ.json': 'slime_restrained_insert_high',
    'dataEx/poseProfiles/堕落度high/スライム堕落度high/非挿入絶頂エロ.json': 'slime_restrained_high',
    'dataEx/poseProfiles/堕落度low/ゴブリン関係/ゴブリン拘束時セリフ（転移完了）.json': 'goblin_restrained_low',
    'dataEx/restraintProfiles/goblin_restrained_low.json': 'goblin_restrained_low',
    # 電撃スライム（未実装だが、一応追加）
    'dataEx/poseProfiles/堕落度low/電撃スライム/拘束時エロ.json': 'electSlime_restrained_low',
    'dataEx/poseProfiles/堕落度low/電撃スライム/挿入瞬間エロ.json': 'electSlime_restrained_insert_low',
    'dataEx/poseProfiles/堕落度low/電撃スライム/挿入絶頂エロ.json': 'electSlime_restrained_insert_low',
    'dataEx/poseProfiles/堕落度low/電撃スライム/挿入通常エロ.json': 'electSlime_restrained_insert_low',
    'dataEx/poseProfiles/堕落度low/電撃スライム/非挿入絶頂エロ.json': 'electSlime_restrained_low',
    'dataEx/poseProfiles/堕落度low/電撃スライム/非挿入通常エロ.json': 'electSlime_restrained_low'
}

print("=" * 80)
print("meta情報の追加")
print("=" * 80)

added_count = 0
skipped_count = 0

for json_path, profile_name in meta_additions.items():
    json_file = Path(json_path)
    
    if not json_file.exists():
        print(f"\n⚠️  存在しない: {json_path}")
        skipped_count += 1
        continue
    
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        # metaが既に存在する場合はスキップ
        if 'meta' in data and 'profileName' in data['meta']:
            rel_path = json_file.relative_to(Path('dataEx'))
            print(f"\n⊘ {rel_path}")
            print(f"  既にmeta存在: {data['meta']['profileName']}")
            skipped_count += 1
            continue
        
        # metaを追加（先頭に挿入）
        new_data = {
            'meta': {
                'profileName': profile_name
            }
        }
        new_data.update(data)
        
        # JSONを書き戻す（インデントを整えて）
        with open(json_file, 'w', encoding='utf-8') as f:
            json.dump(new_data, f, ensure_ascii=False, indent=2)
        
        rel_path = json_file.relative_to(Path('dataEx'))
        print(f"\n✓ {rel_path}")
        print(f"  profileName: {profile_name}")
        
        added_count += 1
        
    except Exception as e:
        print(f"\n✗ エラー: {json_path}: {e}")
        skipped_count += 1

print("\n" + "=" * 80)
print("修正結果")
print("=" * 80)
print(f"追加成功: {added_count}件")
print(f"スキップ: {skipped_count}件")
print("=" * 80)

