import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# meta欠落ファイルのリスト
meta_missing = [
    'dataEx/TRPSkitData.json',
    'dataEx/cutinProfiles/slime_restrained_low.json',
    'dataEx/introProfiles/insert/slime.json',
    'dataEx/introProfiles/insert/slime_restrained_high.json',
    'dataEx/orgasmDetailProfiles/goblin_restrained_insert_high.json',
    'dataEx/orgasmDetailProfiles/slime_restrained_high.json',
    'dataEx/orgasmDetailProfiles/slime_restrained_insert_high.json',
    'dataEx/overlays/overlaySets_slime.json',
    'dataEx/poseProfiles/slime_low.json',
    'dataEx/poseProfiles/slime_restrained_insert_high.json',
    'dataEx/poseProfiles/slime_restrained_insert_low.json',
    'dataEx/poseProfiles/slime_restrained_low.json',
    'dataEx/poseProfiles/tentacle_low.json',
    'dataEx/poseProfiles/.vscode/settings.json',
    'dataEx/poseProfiles/スライム関係/slime_low.json',
    'dataEx/poseProfiles/スライム関係/slime_restrained_low.json',
    'dataEx/poseProfiles/堕落度high/スライム堕落度high/挿入時通常エロ.json',
    'dataEx/poseProfiles/堕落度high/スライム堕落度high/非挿入絶頂エロ.json',
    'dataEx/poseProfiles/堕落度low/ゴブリン関係/ゴブリン拘束時セリフ（転移完了）.json',
    'dataEx/poseProfiles/堕落度low/電撃スライム/拘束時エロ.json',
    'dataEx/poseProfiles/堕落度low/電撃スライム/挿入瞬間エロ.json',
    'dataEx/poseProfiles/堕落度low/電撃スライム/挿入絶頂エロ.json',
    'dataEx/poseProfiles/堕落度low/電撃スライム/挿入通常エロ.json',
    'dataEx/poseProfiles/堕落度low/電撃スライム/非挿入絶頂エロ.json',
    'dataEx/poseProfiles/堕落度low/電撃スライム/非挿入通常エロ.json',
    'dataEx/restraintProfiles/electSlime_restrained_low.json',
    'dataEx/restraintProfiles/electSlime_restrained_mid.json',
    'dataEx/restraintProfiles/goblin_restrained_low.json',
    'dataEx/restraintProfiles/insaneMan_restrained_high.json',
    'dataEx/restraintProfiles/insaneMan_restrained_low.json',
    'dataEx/restraintProfiles/insaneMan_restrained_mid.json',
    'dataEx/restraintProfiles/poisonSlime_restrained_high.json',
    'dataEx/restraintProfiles/poisonSlime_restrained_low.json',
    'dataEx/restraintProfiles/poisonSlime_restrained_mid.json',
    'dataEx/restraintProfiles/reider_restrained_high.json',
    'dataEx/restraintProfiles/reider_restrained_low.json',
    'dataEx/restraintProfiles/reider_restrained_mid.json',
    'dataEx/restraintProfiles/slapper_restrained_high.json',
    'dataEx/restraintProfiles/slapper_restrained_low.json',
    'dataEx/restraintProfiles/slapper_restrained_mid.json'
]

print("=" * 80)
print("meta欠落ファイルの分析")
print("=" * 80)

# カテゴリ分類
categories = {
    '特殊ファイル': [],
    '未実装モンスター（restraintProfiles）': [],
    '未実装モンスター（poseProfiles）': [],
    '旧形式/重複': [],
    '要修正（実装済み）': []
}

for file_path in meta_missing:
    p = Path(file_path)
    if not p.exists():
        continue
    
    name = p.stem
    
    # 分類
    if p.name in ['TRPSkitData.json', 'overlaySets_slime.json', 'settings.json']:
        categories['特殊ファイル'].append(file_path)
    elif 'electSlime' in name or 'insaneMan' in name or 'poisonSlime' in name or 'reider' in name or 'slapper' in name:
        if 'restraintProfiles' in str(p):
            categories['未実装モンスター（restraintProfiles）'].append(file_path)
        else:
            categories['未実装モンスター（poseProfiles）'].append(file_path)
    elif name in ['slime_low', 'tentacle_low'] or 'スライム関係' in str(p):
        categories['旧形式/重複'].append(file_path)
    else:
        # 実装済みモンスターで使われている可能性があるファイル
        categories['要修正（実装済み）'].append(file_path)

# 表示
for category, files in categories.items():
    if not files:
        continue
    
    print(f"\n【{category}】({len(files)}件)")
    print("-" * 80)
    for file_path in files:
        rel_path = Path(file_path).relative_to(Path('dataEx'))
        print(f"  • {rel_path}")

print("\n" + "=" * 80)
print("推奨アクション")
print("=" * 80)
print("""
1. 特殊ファイル: そのまま（meta不要）
2. 未実装モンスター: そのまま（将来の実装用）
3. 旧形式/重複: そのまま（互換性のため）
4. 要修正（実装済み）: metaとprofileNameを追加
""")
print("=" * 80)

