from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# 修正後に必要なディレクトリ
required_dirs = [
    'goblin_restrained_insert_low',
    'goblin_restrained_insert_high',
    'slime_restrained_insert_low',
    'tentacle_restrained_insert_low',
    'tentacle_restrained_high'
]

print("=" * 70)
print("必要なディレクトリの確認")
print("=" * 70)

missing = []
existing = []

for dir_name in required_dirs:
    dir_path = Path(f"img/pictures/busts/{dir_name}")
    if dir_path.exists():
        existing.append(dir_name)
        print(f"  ✓ {dir_name}")
    else:
        missing.append(dir_name)
        print(f"  ✗ {dir_name}")

print("\n" + "=" * 70)
print(f"存在: {len(existing)}個, 不足: {len(missing)}個")
print("=" * 70)

if missing:
    print("\n不足しているディレクトリ:")
    for m in missing:
        # コピー元の候補を探す
        if '_insert_' in m:
            base = m.replace('_insert_', '_')
            if Path(f"img/pictures/busts/{base}").exists():
                print(f"  {m}")
                print(f"    ← {base} からコピー可能")

