import json
from pathlib import Path
import re
import sys

# Windows環境でUTF-8出力を強制
sys.stdout.reconfigure(encoding='utf-8')

# JSON読み込み
json_path = Path("dataEx/poseProfiles/tentacle_restrained_low.json")
with open(json_path, encoding='utf-8') as f:
    data = json.load(f)

# 全てのoverlays/underOverlaysを収集
overlays_in_json = set()

def collect_overlays(obj):
    if isinstance(obj, dict):
        if 'overlays' in obj and isinstance(obj['overlays'], list):
            overlays_in_json.update(obj['overlays'])
        if 'underOverlays' in obj and isinstance(obj['underOverlays'], list):
            overlays_in_json.update(obj['underOverlays'])
        for value in obj.values():
            collect_overlays(value)
    elif isinstance(obj, list):
        for item in obj:
            collect_overlays(item)

collect_overlays(data)

# 擬音系（ぬちゃっ、ぐちゅっ など）だけフィルタ
onomatopoeia = [name for name in overlays_in_json if any(x in name for x in ['ぬちゃっ', 'ぐちゅっ', 'ぬちょっ', 'ぐちゃ'])]

# 実際のファイルを確認
img_dir = Path("img/pictures/busts/tentacle_restrained_low")
if img_dir.exists():
    existing_files = {f.stem.replace('default_pose_overlay_', '') for f in img_dir.glob('*.png')}
else:
    print(f"警告: ディレクトリが存在しません: {img_dir}")
    existing_files = set()

print("=" * 60)
print("JSON内で参照されている擬音オーバーレイ:")
print("=" * 60)
for name in sorted(onomatopoeia):
    exists = name in existing_files
    status = "[OK]" if exists else "[NG]"
    print(f"  {status}: {name}")

print("\n" + "=" * 60)
print(f"合計: {len(onomatopoeia)}個の擬音オーバーレイ参照")
missing = [name for name in onomatopoeia if name not in existing_files]
print(f"不在: {len(missing)}個")
print("=" * 60)

if missing:
    print("\n不在の画像リスト:")
    for name in sorted(missing):
        print(f"  - {name}")

