import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

def collect_overlays(obj):
    overlays = set()
    if isinstance(obj, dict):
        if 'overlays' in obj and isinstance(obj['overlays'], list):
            overlays.update(obj['overlays'])
        for value in obj.values():
            overlays.update(collect_overlays(value))
    elif isinstance(obj, list):
        for item in obj:
            overlays.update(collect_overlays(item))
    return overlays

# slime_restrained_low.json を確認
low_path = Path('dataEx/poseProfiles/slime_restrained_low.json')
with open(low_path, encoding='utf-8') as f:
    low_data = json.load(f)

low_overlays = collect_overlays(low_data)
low_onomatopoeia = sorted([o for o in low_overlays if any(ord(c) > 127 for c in o)])

# slime_restrained_high.json を確認
high_path = Path('dataEx/poseProfiles/slime_restrained_high.json')
with open(high_path, encoding='utf-8') as f:
    high_data = json.load(f)

high_overlays = collect_overlays(high_data)
high_onomatopoeia = sorted([o for o in high_overlays if any(ord(c) > 127 for c in o)])

print("=" * 70)
print("slime_restrained_low.json (参考)")
print("=" * 70)
print(f"擬音オーバーレイ: {len(low_onomatopoeia)}個")
for o in low_onomatopoeia:
    print(f"  ✓ {o}")

print("\n" + "=" * 70)
print("slime_restrained_high.json (現在)")
print("=" * 70)
print(f"擬音オーバーレイ: {len(high_onomatopoeia)}個")
for o in high_onomatopoeia:
    # 画像が存在するか確認
    img_path = Path(f"img/pictures/busts/slime_restrained_high/default_pose_overlay_{o}.png")
    status = "✓" if img_path.exists() else "✗"
    print(f"  {status} {o}")

# 不在の画像
high_missing = [o for o in high_onomatopoeia if not Path(f"img/pictures/busts/slime_restrained_high/default_pose_overlay_{o}.png").exists()]

print("\n" + "=" * 70)
print("対処方法")
print("=" * 70)
if high_missing:
    print(f"slime_restrained_high.json に不在の擬音: {len(high_missing)}個")
    print("\n推奨: slime_restrained_low.json と同じ擬音画像に置き換える")
    print("または: 全ての擬音オーバーレイを削除する")
else:
    print("✅ 全ての擬音画像が存在します")

