import shutil
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# コピーするペア
copy_pairs = [
    ('goblin_restrained_low', 'goblin_restrained_high'),
    ('slime_restrained_insert_low', 'slime_restrained_insert_high'),
    ('tentacle_restrained_insert_low', 'tentacle_restrained_insert_high'),
    ('tentacle_restrained_low', 'tentacle_restrained_high')
]

print("=" * 80)
print("画像ディレクトリのコピー: low → high")
print("=" * 80)

total_copied = 0
total_files = 0

for low_name, high_name in copy_pairs:
    source_dir = Path(f"img/pictures/busts/{low_name}")
    target_dir = Path(f"img/pictures/busts/{high_name}")
    
    if not source_dir.exists():
        print(f"\n⚠️  スキップ: {low_name} (存在しません)")
        continue
    
    print(f"\n📁 {low_name}")
    print(f"   → {high_name}")
    
    # ファイル数をカウント
    files = list(source_dir.rglob('*'))
    file_count = len([f for f in files if f.is_file()])
    total_files += file_count
    print(f"   ファイル数: {file_count}個")
    
    try:
        # ディレクトリごとコピー
        if target_dir.exists():
            print(f"   ⚠️  既に存在するためスキップ")
            continue
        
        shutil.copytree(source_dir, target_dir)
        total_copied += file_count
        print(f"   ✅ コピー完了")
        
    except Exception as e:
        print(f"   ❌ エラー: {e}")

print("\n" + "=" * 80)
print("コピー結果")
print("=" * 80)
print(f"対象ファイル数: {total_files}個")
print(f"コピー成功: {total_copied}個")

if total_copied > 0:
    print(f"\n✅ {len(copy_pairs)}個のディレクトリをコピーしました")

