import shutil
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# コピー元とコピー先
source_dir = Path("img/pictures/busts/slime_restrained_low")
target_dir = Path("img/pictures/busts/slime_restrained_high")

# コピー対象の擬音オーバーレイ
target_overlays = [
    'ぐちゃ1-6_left',
    'ぐちゃ1-6_right',
    'ぐちゅっ1-6_left',
    'ぐちゅっ1-6_right',
    'ずぶ3-6_left',
    'ぬちゃっ1-6_left',
    'ぬちょっ1-6_left',
    'ぬちょっ1-6_right'
]

print("=" * 70)
print("擬音画像のコピー: slime_restrained_low → slime_restrained_high")
print("=" * 70)

# ターゲットディレクトリが存在しない場合は作成
if not target_dir.exists():
    print(f"\n✓ ディレクトリを作成: {target_dir}")
    target_dir.mkdir(parents=True, exist_ok=True)

# 各擬音オーバーレイをコピー
copied = []
not_found = []

for overlay in target_overlays:
    filename = f"default_pose_overlay_{overlay}.png"
    
    # 再帰的に検索
    source_files = list(source_dir.rglob(filename))
    
    if source_files:
        source_file = source_files[0]
        target_file = target_dir / filename
        
        try:
            shutil.copy2(source_file, target_file)
            copied.append(overlay)
            print(f"  ✓ コピー: {overlay}")
        except Exception as e:
            print(f"  ✗ エラー: {overlay} - {e}")
    else:
        not_found.append(overlay)
        print(f"  ? 見つからない: {overlay}")

print("\n" + "=" * 70)
print("結果")
print("=" * 70)
print(f"コピー成功: {len(copied)}個")
print(f"見つからない: {len(not_found)}個")

if not_found:
    print("\n見つからなかったファイル:")
    for o in not_found:
        print(f"  - {o}")

if copied:
    print(f"\n✅ {len(copied)}個の擬音画像をコピーしました")

