#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
addUnderOverlays.py

slime関連の4ファイルでunderOverlaysが欠けている箇所を補完
- slime_restrained_low.json: visuals に "slime_pussy_all" を追加
- slime_restrained_high.json: visuals に "slime_pussy_all" を追加
- slime_restrained_insert_low.json: 既に完備（スキップ）
- slime_restrained_insert_high.json: 全体に "slime_pussy_back_1" を追加
"""

import json
import sys
from pathlib import Path

# UTF-8出力設定
sys.stdout.reconfigure(encoding='utf-8')

def add_under_overlays_recursive(obj, target_value, path="", added_count=0):
    """再帰的にunderOverlaysを追加"""
    if isinstance(obj, dict):
        # dialogueSequence内の各要素をチェック
        if 'overlays' in obj:
            # overlaysがあるのにunderOverlaysがない場合
            if 'underOverlays' not in obj:
                obj['underOverlays'] = [target_value]
                added_count += 1
                print(f"  [追加] {path}")
        
        # 再帰的に処理
        for key, value in obj.items():
            new_path = f"{path}.{key}" if path else key
            added_count = add_under_overlays_recursive(value, target_value, new_path, added_count)
    
    elif isinstance(obj, list):
        for idx, item in enumerate(obj):
            new_path = f"{path}[{idx}]"
            added_count = add_under_overlays_recursive(item, target_value, new_path, added_count)
    
    return added_count

def process_file(file_path, under_overlay_value):
    """単一ファイルを処理"""
    print(f"\n📄 処理中: {file_path.name}")
    
    try:
        with open(file_path, 'r', encoding='utf-8') as f:
            data = json.load(f)
        
        added_count = add_under_overlays_recursive(data, under_overlay_value)
        
        if added_count > 0:
            # バックアップ作成
            backup_path = file_path.with_suffix(file_path.suffix + '.backup')
            with open(backup_path, 'w', encoding='utf-8') as f:
                json.dump(json.loads(open(file_path, 'r', encoding='utf-8').read()), f, ensure_ascii=False, indent=2)
            
            # 修正版を保存
            with open(file_path, 'w', encoding='utf-8') as f:
                json.dump(data, f, ensure_ascii=False, indent=2)
            
            print(f"  ✅ 完了: {added_count}箇所に追加")
            print(f"  💾 バックアップ: {backup_path.name}")
            return True
        else:
            print(f"  ℹ️  追加不要（既に完備）")
            return False
            
    except Exception as e:
        print(f"  ❌ エラー: {e}")
        return False

def main():
    print("=" * 80)
    print("🔧 underOverlays 自動補完ツール")
    print("=" * 80)
    
    project_root = Path(__file__).parent.parent.parent
    
    # 処理対象ファイルと対応するunderOverlay値
    targets = [
        {
            'file': project_root / 'dataEx/poseProfiles/slime_restrained_low.json',
            'value': 'slime_pussy_all',
            'desc': '非挿入・低堕落度'
        },
        {
            'file': project_root / 'dataEx/poseProfiles/slime_restrained_high.json',
            'value': 'slime_pussy_all',
            'desc': '非挿入・高堕落度'
        },
        {
            'file': project_root / 'dataEx/poseProfiles/slime_restrained_insert_low.json',
            'value': 'slime_pussy_back_1',
            'desc': '挿入・低堕落度'
        },
        {
            'file': project_root / 'dataEx/poseProfiles/slime_restrained_insert_high.json',
            'value': 'slime_pussy_back_1',
            'desc': '挿入・高堕落度'
        }
    ]
    
    fixed_count = 0
    
    for target in targets:
        file_path = target['file']
        if not file_path.exists():
            print(f"\n⚠️  ファイルが見つかりません: {file_path.name}")
            continue
        
        print(f"\n[{target['desc']}]")
        if process_file(file_path, target['value']):
            fixed_count += 1
    
    print("\n" + "=" * 80)
    if fixed_count > 0:
        print(f"✨ 完了: {fixed_count}ファイルを修正しました")
        print("\n📝 注意:")
        print("  - バックアップファイル (*.backup) が作成されています")
        print("  - 問題がなければバックアップを削除してください")
    else:
        print("✅ すべてのファイルが既に完備されています")
    print("=" * 80)
    print()

if __name__ == "__main__":
    main()

