import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

mismatches = []

# 全JSONファイルを調査
for json_file in Path('dataEx').rglob('*.json'):
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        if not isinstance(data, dict) or 'meta' not in data:
            continue
        
        profile_name = data['meta'].get('profileName')
        if not profile_name:
            continue
        
        # 対応する画像ディレクトリを確認
        img_dir = Path(f"img/pictures/busts/{profile_name}")
        
        # orgasm系は除外（poseProfileを参照するため）
        if '_orgasm' in profile_name:
            continue
        
        if not img_dir.exists():
            # 類似のディレクトリを検索
            similar = []
            base_name = profile_name.replace('inserted', 'restrained_insert').replace('_insert', '_restrained_insert')
            
            # パターン1: inserted → restrained_insert
            alt1 = profile_name.replace('inserted', 'restrained_insert')
            if Path(f"img/pictures/busts/{alt1}").exists():
                similar.append(alt1)
            
            # パターン2: rub → restrained
            alt2 = profile_name.replace('_rub_', '_restrained_')
            if Path(f"img/pictures/busts/{alt2}").exists():
                similar.append(alt2)
            
            # パターン3: _insert → _restrained_insert
            alt3 = profile_name.replace('_low_insert', '_restrained_insert_low').replace('_high_insert', '_restrained_insert_high')
            if Path(f"img/pictures/busts/{alt3}").exists():
                similar.append(alt3)
            
            mismatches.append({
                'file': json_file,
                'current': profile_name,
                'similar': similar
            })
    
    except:
        pass

print("=" * 80)
print("profileName の不一致")
print("=" * 80)

for item in mismatches:
    relative_path = item['file'].relative_to(Path('dataEx'))
    print(f"\n📄 {relative_path}")
    print(f"   現在: {item['current']}")
    print(f"   ディレクトリ: img/pictures/busts/{item['current']} (存在しない)")
    
    if item['similar']:
        print(f"   候補:")
        for sim in item['similar']:
            print(f"     → {sim}")
    else:
        print(f"   候補: なし（新規作成が必要）")

print("\n" + "=" * 80)
print(f"合計: {len(mismatches)}個の不一致")
print("=" * 80)

