import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

def collect_overlays(obj):
    overlays = set()
    if isinstance(obj, dict):
        if 'overlays' in obj and isinstance(obj['overlays'], list):
            overlays.update(obj['overlays'])
        for value in obj.values():
            overlays.update(collect_overlays(value))
    elif isinstance(obj, list):
        for item in obj:
            overlays.update(collect_overlays(item))
    return overlays

# 問題のあるファイルをチェック
problem_files = [
    ('dataEx/introProfiles/insert/tentacle_restrained_low.json', 'tentacle_restrained_insert_low'),
    ('dataEx/introProfiles/insert/goblin_restrained_high.json', 'goblin_restrained_insert_high'),
    ('dataEx/orgasmDetailProfiles/goblin_restrained_insert_low.json', 'goblin_restrained_insert_low')
]

print("=" * 80)
print("存在しない擬音の置き換え候補")
print("=" * 80)

for json_path, profile_name in problem_files:
    json_file = Path(json_path)
    img_dir = Path(f"img/pictures/busts/{profile_name}")
    
    print(f"\n📄 {json_file.name}")
    print(f"   ディレクトリ: {profile_name}")
    
    # JSONから擬音を収集
    with open(json_file, encoding='utf-8') as f:
        data = json.load(f)
    
    all_overlays = collect_overlays(data)
    onomatopoeia = sorted([o for o in all_overlays if any(ord(c) > 127 for c in o)])
    
    # 存在する擬音画像を取得
    if img_dir.exists():
        existing_files = {f.stem.replace('default_pose_overlay_', '') for f in img_dir.rglob('*.png')}
        existing_onomatopoeia = sorted([f for f in existing_files if any(ord(c) > 127 for c in f)])
        
        print(f"\n   参照されている擬音: {len(onomatopoeia)}個")
        missing = []
        for o in onomatopoeia:
            if o not in existing_files:
                missing.append(o)
                print(f"     ✗ {o}")
            else:
                print(f"     ✓ {o}")
        
        if missing:
            print(f"\n   存在する擬音（候補）: {len(existing_onomatopoeia)}個")
            for e in existing_onomatopoeia[:10]:  # 最初の10個を表示
                print(f"     • {e}")
            if len(existing_onomatopoeia) > 10:
                print(f"     ... 他{len(existing_onomatopoeia)-10}個")
    else:
        print(f"   ✗ ディレクトリが存在しません")

print("\n" + "=" * 80)

