import json
from pathlib import Path
import sys
import shutil

sys.stdout.reconfigure(encoding='utf-8')

print("=" * 80)
print("緊急問題の修正")
print("=" * 80)

# 1. 空ファイルの削除
empty_files = [
    'dataEx/poseProfiles/各種スケルトン/非挿入.json',
    'dataEx/restraintProfiles/electSlime_restrained_high.json'
]

print("\n【1】空ファイルの削除")
print("-" * 80)
for file_path in empty_files:
    p = Path(file_path)
    if p.exists():
        if p.stat().st_size == 0:
            print(f"  ✓ 削除: {file_path}")
            p.unlink()
        else:
            print(f"  ⚠️  スキップ: {file_path} (空ではない)")
    else:
        print(f"  ⚠️  存在しない: {file_path}")

# 2. 堕落度high系の擬音不在を修正（特定のオーバーレイを削除）
print("\n【2】使用されていない擬音オーバーレイの削除")
print("-" * 80)

# これらは堕落度highの古いファイルで、新しいファイルに統合されている可能性が高い
files_to_clean = {
    'dataEx/poseProfiles/各種スケルトン/拘束イベント.json': {
        'remove': ['ひゃあっ1-1_left', 'んっ1-1_right', 'おほッ1-1_left', 'ああぁッ1-1_right']
    },
    'dataEx/poseProfiles/堕落度high/スライム堕落度high/拘束瞬間.json': {
        'remove': ['ひゃあっ1-1_left', 'ひゃあっ1-1_right', 'おほッ1-1_left', 'んむっ1-1_right', 'あっ1-1_right', 'あっ1-1_left']
    },
    'dataEx/poseProfiles/堕落度high/堕落度highゴブリン/拘束時エロ.json': {
        'remove': ['ひゃあっ1-1_left', 'あっ1-1_right', 'おほッ1-1_left', 'んむっ1-1_right']
    },
    'dataEx/poseProfiles/堕落度high/触手堕落度high/拘束時エロ.json': {
        'remove': ['ひゃあっ1-1_left', '股攻撃', 'おほッ1-1_left', 'んむっ1-1_right']
    }
}

def remove_overlays(obj, to_remove):
    """再帰的にoverlays配列から特定の要素を削除"""
    if isinstance(obj, dict):
        result = {}
        for key, value in obj.items():
            if key == 'overlays' and isinstance(value, list):
                # to_removeリストの要素を除外
                result[key] = [item for item in value if item not in to_remove]
            else:
                result[key] = remove_overlays(value, to_remove)
        return result
    elif isinstance(obj, list):
        return [remove_overlays(item, to_remove) for item in obj]
    else:
        return obj

for json_path, config in files_to_clean.items():
    json_file = Path(json_path)
    if not json_file.exists():
        print(f"  ⚠️  存在しない: {json_path}")
        continue
    
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        modified_data = remove_overlays(data, config['remove'])
        
        with open(json_file, 'w', encoding='utf-8') as f:
            json.dump(modified_data, f, ensure_ascii=False, indent=2)
        
        rel_path = json_file.relative_to(Path('dataEx'))
        print(f"  ✓ {rel_path}")
        print(f"    削除した擬音: {len(config['remove'])}個")
    except Exception as e:
        print(f"  ✗ エラー: {json_path}: {e}")

# 3. 明らかな誤記の修正
print("\n【3】擬音オーバーレイの誤記修正")
print("-" * 80)

typo_fixes = {
    'dataEx/poseProfiles/堕落度low/ゴブリン関係/絶頂イベント_挿入時（転移完了）.json': {
        'ぐちゅっ1-4': 'ぐちゅっ1-6_left',
        'ぐちゅっ1-4 left': 'ぐちゅっ1-6_left',
        'ぬちゃっ1-4': 'ぬちゃっ1-6_left',
        'ぬちゃっ1-4_left': 'ぬちゃっ1-6_left',
        'ぬちゃっ1-4_right': 'ぬちゃっ1-6_right'
    },
    'dataEx/poseProfiles/堕落度low/触手①関係/挿入エロ.json': {
        'ひゃあッ1-1_left': 'ぬちゃっ1-6_left',
        'ひぃい1-1_left': 'ぐちゅっ1-6_left',
        'やだっ1-1_left': 'ズプッ1-6_left'
    }
}

def replace_in_overlays(obj, mapping):
    """再帰的にoverlays配列内の文字列を置換"""
    if isinstance(obj, dict):
        result = {}
        for key, value in obj.items():
            if key == 'overlays' and isinstance(value, list):
                result[key] = [mapping.get(item, item) for item in value]
            else:
                result[key] = replace_in_overlays(value, mapping)
        return result
    elif isinstance(obj, list):
        return [replace_in_overlays(item, mapping) for item in obj]
    else:
        return obj

for json_path, mapping in typo_fixes.items():
    json_file = Path(json_path)
    if not json_file.exists():
        print(f"  ⚠️  存在しない: {json_path}")
        continue
    
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        modified_data = replace_in_overlays(data, mapping)
        
        with open(json_file, 'w', encoding='utf-8') as f:
            json.dump(modified_data, f, ensure_ascii=False, indent=2)
        
        rel_path = json_file.relative_to(Path('dataEx'))
        print(f"  ✓ {rel_path}")
        print(f"    置換: {len(mapping)}個")
    except Exception as e:
        print(f"  ✗ エラー: {json_path}: {e}")

print("\n" + "=" * 80)
print("緊急問題の修正完了")
print("=" * 80)

