import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

print("=" * 80)
print("最後の擬音不在問題の修正")
print("=" * 80)

# 最後の3件を修正
fixes = {
    'dataEx/poseProfiles/堕落度high/堕落度highゴブリン/拘束時エロ.json': {
        'remove': ['ああぁッ1-1_right']
    },
    'dataEx/poseProfiles/堕落度high/触手堕落度high/挿入時イベント.json': {
        'remove': ['ひゃあッ1-1_left']
    },
    'dataEx/poseProfiles/堕落度low/ゴブリン関係/絶頂イベント_挿入時（転移完了）.json': {
        'remove': ['んんっッ1-1']
    }
}

def remove_overlays(obj, to_remove):
    """再帰的にoverlays配列から特定の要素を削除"""
    if isinstance(obj, dict):
        result = {}
        for key, value in obj.items():
            if key == 'overlays' and isinstance(value, list):
                result[key] = [item for item in value if item not in to_remove]
            else:
                result[key] = remove_overlays(value, to_remove)
        return result
    elif isinstance(obj, list):
        return [remove_overlays(item, to_remove) for item in obj]
    else:
        return obj

fixed_count = 0

for json_path, config in fixes.items():
    json_file = Path(json_path)
    if not json_file.exists():
        print(f"\n⚠️  存在しない: {json_path}")
        continue
    
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        modified_data = remove_overlays(data, config['remove'])
        
        with open(json_file, 'w', encoding='utf-8') as f:
            json.dump(modified_data, f, ensure_ascii=False, indent=2)
        
        rel_path = json_file.relative_to(Path('dataEx'))
        print(f"\n✓ {rel_path}")
        print(f"  削除: {', '.join(config['remove'])}")
        
        fixed_count += 1
        
    except Exception as e:
        print(f"\n✗ エラー: {json_path}: {e}")

print("\n" + "=" * 80)
print(f"修正完了: {fixed_count}件")
print("=" * 80)

