import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# 修正マッピング
fixes = {
    # goblin系
    'goblin_rub_high': 'goblin_restrained_high',
    'goblin_inserted_low': 'goblin_restrained_insert_low',
    'goblin_inserted_high': 'goblin_restrained_insert_high',
    'goblin_restrained_insert_high': 'goblin_restrained_insert_high',  # すでに正しいが念のため
    
    # tentacle系
    'tentacle_restrained_low_insert': 'tentacle_restrained_insert_low',
    'tentacle_high_insert_normal': 'tentacle_restrained_insert_high',
    '触手_restrained_high': 'tentacle_restrained_high',
    
    # slime系
    'slime_insert_low': 'slime_restrained_insert_low',
}

# 全JSONファイルを検索
fixed_count = 0
error_count = 0

print("=" * 80)
print("profileName の修正")
print("=" * 80)

for json_file in Path('dataEx').rglob('*.json'):
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        if not isinstance(data, dict) or 'meta' not in data:
            continue
        
        current_name = data['meta'].get('profileName')
        if not current_name or current_name not in fixes:
            continue
        
        new_name = fixes[current_name]
        data['meta']['profileName'] = new_name
        
        # JSONを書き戻す
        with open(json_file, 'w', encoding='utf-8') as f:
            json.dump(data, f, ensure_ascii=False, indent=2)
        
        relative_path = json_file.relative_to(Path('dataEx'))
        print(f"\n✓ {relative_path}")
        print(f"  {current_name}")
        print(f"  → {new_name}")
        
        fixed_count += 1
        
    except Exception as e:
        error_count += 1
        print(f"\n✗ エラー: {json_file}: {e}")

print("\n" + "=" * 80)
print("修正結果")
print("=" * 80)
print(f"修正成功: {fixed_count}個")
print(f"エラー: {error_count}個")

if fixed_count > 0:
    print(f"\n✅ {fixed_count}個のprofileNameを修正しました")

