import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

print("=" * 80)
print("残りの擬音不在問題の修正")
print("=" * 80)

# 存在しない「はぁ」系や特殊な擬音を削除
files_to_clean = {
    'dataEx/poseProfiles/堕落度high/スライム堕落度high/非挿入通常エロ.json': {
        'keep_only': ['restrain', 'blush_low', 'blush_mid', 'blush_high', 'ぬちゅっ1-6_left', 'ぬちゅっ1-6_right', 'ぐちゅっ1-6_left', 'ぐちゅっ1-6_right']
    },
    'dataEx/poseProfiles/堕落度high/堕落度highゴブリン/ゴブリン非挿入通常エロ.json': {
        'keep_only': ['restrain', 'blush_low', 'blush_mid', 'blush_high', 'ぬちゅっ1-6_left', 'ぬちゅっ1-6_right', 'ぐちゅっ1-6_left', 'ぐちゅっ1-6_right', 'ぬちょっ1-6_left', 'ぬちょっ1-6_right']
    },
    'dataEx/poseProfiles/堕落度high/堕落度highゴブリン/挿入時イベント.json': {
        'keep_only': ['restrain', 'blush_low', 'blush_mid', 'blush_high', 'ぬちゃっ1-6_left', 'ぬちゃっ1-6_right', 'ぐちゅっ1-6_left', 'ぐちゅっ1-6_right', 'ぬちょっ1-6_left', 'ぬちょっ1-6_right', 'ズプッ1-6_left', 'ズプッ1-6_right', 'ズポ1-6_left', 'ズポ1-6_right']
    },
    'dataEx/poseProfiles/堕落度high/堕落度highゴブリン/挿入時通常エロ.json': {
        'keep_only': ['restrain', 'blush_low', 'blush_mid', 'blush_high', 'ぬちゃっ1-6_left', 'ぬちゃっ1-6_right', 'ぐちゅっ1-6_left', 'ぐちゅっ1-6_right', 'ぬちょっ1-6_left', 'ぬちょっ1-6_right']
    },
    'dataEx/poseProfiles/堕落度high/触手堕落度high/挿入時イベント.json': {
        'remove': ['股攻撃']  # 特殊なオーバーレイを削除
    },
    'dataEx/poseProfiles/堕落度high/触手堕落度high/挿入時通常エロ.json': {
        'keep_only': ['restrain', 'blush_low', 'blush_mid', 'blush_high', 'ぬちゃっ1-6_left', 'ぬちゃっ1-6_right', 'ぐちゅっ1-6_left', 'ぐちゅっ1-6_right', 'ズプッ1-6_left', 'ズプッ1-6_right', 'ズポ1-6_left', 'ズポ1-6_right']
    },
    'dataEx/poseProfiles/堕落度high/触手堕落度high/非挿入通常エロ.json': {
        'keep_only': ['restrain', 'blush_low', 'blush_mid', 'blush_high', 'ぬちゃっ1-6_left', 'ぬちゃっ1-6_right', 'ぐちゅっ1-6_left', 'ぐちゅっ1-6_right']
    }
}

def clean_overlays(obj, keep_only=None, remove=None):
    """再帰的にoverlays配列を整理"""
    if isinstance(obj, dict):
        result = {}
        for key, value in obj.items():
            if key == 'overlays' and isinstance(value, list):
                if keep_only is not None:
                    # keep_onlyリストの要素のみを保持
                    result[key] = [item for item in value if item in keep_only]
                elif remove is not None:
                    # removeリストの要素を削除
                    result[key] = [item for item in value if item not in remove]
                else:
                    result[key] = value
            else:
                result[key] = clean_overlays(value, keep_only, remove)
        return result
    elif isinstance(obj, list):
        return [clean_overlays(item, keep_only, remove) for item in obj]
    else:
        return obj

cleaned_count = 0
error_count = 0

for json_path, config in files_to_clean.items():
    json_file = Path(json_path)
    if not json_file.exists():
        print(f"\n⚠️  存在しない: {json_path}")
        error_count += 1
        continue
    
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        keep_only = config.get('keep_only')
        remove = config.get('remove')
        
        modified_data = clean_overlays(data, keep_only, remove)
        
        with open(json_file, 'w', encoding='utf-8') as f:
            json.dump(modified_data, f, ensure_ascii=False, indent=2)
        
        rel_path = json_file.relative_to(Path('dataEx'))
        print(f"\n✓ {rel_path}")
        if keep_only:
            print(f"  保持するオーバーレイ: {len(keep_only)}種類")
        if remove:
            print(f"  削除: {', '.join(remove)}")
        
        cleaned_count += 1
        
    except Exception as e:
        print(f"\n✗ エラー: {json_path}: {e}")
        error_count += 1

print("\n" + "=" * 80)
print("修正結果")
print("=" * 80)
print(f"成功: {cleaned_count}個")
print(f"エラー: {error_count}個")
print("=" * 80)

