import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

print("=" * 80)
print("スライム系の擬音不在修正")
print("=" * 80)

# スライム系の擬音を修正
fixes = {
    'dataEx/poseProfiles/slime_restrained_insert_high.json': {
        'replace': {
            'ズプッ3-6_left': 'ズプッ1-6_left',
            'ズポ3-6_right': 'ズポ1-6_right'
        }
    },
    'dataEx/poseProfiles/堕落度high/スライム堕落度high/非挿入絶頂エロ.json': {
        'keep_only': ['slime_bind_base', 'restrain', 'blush_low', 'blush_mid', 'blush_high', 
                      'slime_pussy_all', 'slime_breast_low', 'slime_breast_high',
                      'ぐちゃ1-6_left', 'ぐちゃ1-6_right', 'ぐちゅっ1-6_left', 'ぐちゅっ1-6_right',
                      'ぬちょっ1-6_left', 'ぬちょっ1-6_right', 'ずぶ3-6_left']
    }
}

def replace_overlays(obj, mapping):
    """再帰的にoverlays配列内の文字列を置換"""
    if isinstance(obj, dict):
        result = {}
        for key, value in obj.items():
            if key == 'overlays' and isinstance(value, list):
                result[key] = [mapping.get(item, item) for item in value]
            else:
                result[key] = replace_overlays(value, mapping)
        return result
    elif isinstance(obj, list):
        return [replace_overlays(item, mapping) for item in obj]
    else:
        return obj

def filter_overlays(obj, keep_only):
    """再帰的にoverlays配列をフィルタリング"""
    if isinstance(obj, dict):
        result = {}
        for key, value in obj.items():
            if key == 'overlays' and isinstance(value, list):
                result[key] = [item for item in value if item in keep_only]
            elif key in ['underOverlays'] and isinstance(value, list):
                result[key] = value  # underOverlaysはそのまま
            else:
                result[key] = filter_overlays(value, keep_only)
        return result
    elif isinstance(obj, list):
        return [filter_overlays(item, keep_only) for item in obj]
    else:
        return obj

fixed_count = 0

for json_path, config in fixes.items():
    json_file = Path(json_path)
    if not json_file.exists():
        print(f"\n⚠️  存在しない: {json_path}")
        continue
    
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
        
        if 'replace' in config:
            modified_data = replace_overlays(data, config['replace'])
        elif 'keep_only' in config:
            modified_data = filter_overlays(data, config['keep_only'])
        else:
            continue
        
        with open(json_file, 'w', encoding='utf-8') as f:
            json.dump(modified_data, f, ensure_ascii=False, indent=2)
        
        rel_path = json_file.relative_to(Path('dataEx'))
        print(f"\n✓ {rel_path}")
        if 'replace' in config:
            print(f"  置換: {len(config['replace'])}個")
        elif 'keep_only' in config:
            print(f"  フィルタリング: {len(config['keep_only'])}種類を保持")
        
        fixed_count += 1
        
    except Exception as e:
        print(f"\n✗ エラー: {json_path}: {e}")

print("\n" + "=" * 80)
print(f"修正完了: {fixed_count}件")
print("=" * 80)

