import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# dataEx内の全JSONファイルからprofileNameを収集
profile_names = set()

for json_file in Path('dataEx').rglob('*.json'):
    if json_file.name == 'filelist_png.txt':
        continue
    try:
        with open(json_file, encoding='utf-8') as f:
            data = json.load(f)
            if isinstance(data, dict) and 'meta' in data:
                profile_name = data['meta'].get('profileName')
                if profile_name:
                    profile_names.add(profile_name)
    except:
        pass

# lowとhighのペアを見つける
low_profiles = {p for p in profile_names if '_low' in p and not p.endswith('_orgasm')}
high_profiles = {p for p in profile_names if '_high' in p and not p.endswith('_orgasm')}

# 対応するペアを作成
pairs = []
for low in sorted(low_profiles):
    # lowをhighに置き換える
    potential_high = low.replace('_low', '_high')
    if potential_high in high_profiles:
        # 実際のディレクトリ存在を確認
        low_dir = Path(f"img/pictures/busts/{low}")
        high_dir = Path(f"img/pictures/busts/{potential_high}")
        
        if low_dir.exists() and not high_dir.exists():
            pairs.append((low, potential_high))

print("=" * 80)
print("画像ディレクトリのコピー候補")
print("=" * 80)
print(f"見つかった low プロファイル: {len(low_profiles)}個")
print(f"見つかった high プロファイル: {len(high_profiles)}個")
print(f"コピーが必要なペア: {len(pairs)}個\n")

if pairs:
    for low, high in pairs:
        low_dir = Path(f"img/pictures/busts/{low}")
        high_dir = Path(f"img/pictures/busts/{high}")
        file_count = len(list(low_dir.rglob('*.png')))
        print(f"  📁 {low}")
        print(f"     → {high}")
        print(f"     ファイル数: {file_count}個\n")
else:
    print("✅ コピーが必要なペアはありません（またはslime_restrained以外）")

print("=" * 80)
print("既に存在するディレクトリ (low)")
print("=" * 80)
for low in sorted(low_profiles):
    low_dir = Path(f"img/pictures/busts/{low}")
    if low_dir.exists():
        print(f"  ✓ {low}")

print("\n" + "=" * 80)
print("存在しないディレクトリ (high)")
print("=" * 80)
for high in sorted(high_profiles):
    high_dir = Path(f"img/pictures/busts/{high}")
    if not high_dir.exists():
        print(f"  ✗ {high}")

