import json
from pathlib import Path
import sys

sys.stdout.reconfigure(encoding='utf-8')

# 置き換えマッピング
replacements = {
    'dataEx/introProfiles/insert/tentacle_restrained_low.json': {
        'ぬちゃっ1-6右': 'ぬちゃっ1-6_right'
    },
    'dataEx/introProfiles/insert/goblin_restrained_high.json': {
        'ぐちゃ1_left': 'ぐちゃ1-6_left',
        'ぐちゃ1_right': 'ぐちゃ1-6_right',
        'ぐちゅっ1_left': 'ぐちゅっ1-6_left',
        'ぐちゅっ1_right': 'ぐちゅっ1-6_right',
        'ぬちゃっ1_left': 'ぬちゃっ1-6_left',
        'ぬちゃっ1_right': 'ぬちゃっ1-6_right',
        'ぬちゃっ2_left': 'ぬちゃっ1-6_left',
        'ぬちょっ1_left': 'ぬちょっ1-6_left',
        'ぬちょっ1_right': 'ぬちょっ1-6_right',
        'ぬちょっ5_right': 'ぬちょっ1-6_right'
    },
    'dataEx/orgasmDetailProfiles/goblin_restrained_insert_low.json': {
        'ぐちゅっ1-6': 'ぐちゅっ1-6_left',
        'ぬちゃっ1-6': 'ぬちゃっ1-6_left'
    }
}

def replace_in_obj(obj, mapping):
    """再帰的にオブジェクト内の文字列を置換"""
    if isinstance(obj, dict):
        result = {}
        for key, value in obj.items():
            if key == 'overlays' and isinstance(value, list):
                # overlays配列内の文字列を置換
                result[key] = [mapping.get(item, item) for item in value]
            else:
                result[key] = replace_in_obj(value, mapping)
        return result
    elif isinstance(obj, list):
        return [replace_in_obj(item, mapping) for item in obj]
    else:
        return obj

print("=" * 80)
print("擬音オーバーレイの置き換え")
print("=" * 80)

total_replaced = 0

for json_path, mapping in replacements.items():
    json_file = Path(json_path)
    
    if not json_file.exists():
        print(f"\n⚠️  {json_file.name}: ファイルが存在しません")
        continue
    
    # JSONを読み込み
    with open(json_file, encoding='utf-8') as f:
        data = json.load(f)
    
    # 置き換え
    modified_data = replace_in_obj(data, mapping)
    
    # 保存
    with open(json_file, 'w', encoding='utf-8') as f:
        json.dump(modified_data, f, ensure_ascii=False, indent=2)
    
    relative_path = json_file.relative_to(Path('dataEx'))
    print(f"\n✓ {relative_path}")
    print(f"   置き換え: {len(mapping)}個")
    for old, new in mapping.items():
        print(f"     {old} → {new}")
    
    total_replaced += len(mapping)

print("\n" + "=" * 80)
print(f"合計: {total_replaced}個の擬音を置き換えました")
print("=" * 80)

